/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.changetracking;

import com.ontotext.graphdb.plugin.changetracking.SingleThreadedMemoryStore;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.QueryRequest;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import com.ontotext.trree.sdk.impl.RequestContextImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class ChangeTrackingPlugin
extends PluginBase
implements StatementListener,
PluginTransactionListener,
Preprocessor,
PatternInterpreter,
UpdateInterpreter,
StatelessPlugin {
    private static final IRI implicitContext = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/implicit");
    private static final IRI explicitContext = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/explicit");
    private static final IRI addedContext = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/added");
    private static final IRI removedContext = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/removed");
    private static final String ADDED_CONTEXT_PREFIX = "http://www.ontotext.com/added/";
    private static final String REMOVED_CONTEXT_PREFIX = "http://www.ontotext.com/removed/";
    private static final IRI trackChangesIri = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/track-changes");
    private static final IRI deleteChangesIri = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/delete-changes");
    private long trackChangesId;
    private long deleteChangesId;
    private boolean trackChanges;
    private MemoryStore store;
    private final Map<String, SailConnection> storeInsertConnections = new HashMap<String, SailConnection>();
    private final Map<String, SailConnection> storeDeleteConnections = new HashMap<String, SailConnection>();
    private SailConnection storeInsertConnection;
    private SailConnection storeDeleteConnection;

    public String getName() {
        return "change-tracking";
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        this.store = new SingleThreadedMemoryStore();
        this.store.init();
        this.trackChangesId = pluginConnection.getEntities().put((Value)trackChangesIri, Entities.Scope.SYSTEM);
        this.deleteChangesId = pluginConnection.getEntities().put((Value)deleteChangesIri, Entities.Scope.SYSTEM);
    }

    public void shutdown(ShutdownReason reason) {
        this.storeInsertConnections.forEach((id, connection) -> {
            connection.rollback();
            connection.close();
        });
        this.storeDeleteConnections.forEach((id, connection) -> {
            connection.rollback();
            connection.close();
        });
        this.store.shutDown();
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.trackChangesId, this.deleteChangesId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.trackChangesId) {
            String id = pluginConnection.getEntities().get(object).stringValue();
            this.startTracking(id);
            return true;
        }
        if (predicate == this.deleteChangesId) {
            String id = pluginConnection.getEntities().get(object).stringValue();
            this.stopTracking(id);
            return true;
        }
        return false;
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean isExplicit, PluginConnection pluginConnection) {
        if (this.trackChanges) {
            this.addChange(subject, predicate, object, context, isExplicit, true, pluginConnection.getEntities());
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean isExplicit, PluginConnection pluginConnection) {
        if (this.trackChanges) {
            this.addChange(subject, predicate, object, context, isExplicit, false, pluginConnection.getEntities());
        }
        return false;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.trackChanges = false;
        this.storeInsertConnection = null;
        this.storeDeleteConnection = null;
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.trackChanges = false;
        this.storeInsertConnection = null;
        this.storeDeleteConnection = null;
    }

    private void startTracking(String id) {
        this.stopTracking(id);
        this.storeInsertConnection = this.store.getConnection();
        this.storeInsertConnection.begin();
        this.storeInsertConnections.put(id, this.storeInsertConnection);
        this.storeDeleteConnection = this.store.getConnection();
        this.storeDeleteConnection.begin();
        this.storeDeleteConnections.put(id, this.storeDeleteConnection);
        this.trackChanges = true;
    }

    private void stopTracking(String id) {
        SailConnection storeDeleteConnection;
        this.trackChanges = false;
        this.storeInsertConnection = null;
        this.storeDeleteConnection = null;
        SailConnection storeInsertConnection = this.storeInsertConnections.remove(id);
        if (storeInsertConnection != null) {
            storeInsertConnection.rollback();
            storeInsertConnection.close();
        }
        if ((storeDeleteConnection = this.storeDeleteConnections.remove(id)) != null) {
            storeDeleteConnection.rollback();
            storeDeleteConnection.close();
        }
    }

    public RequestContext preprocess(Request request) {
        Dataset dataset;
        if (request instanceof QueryRequest && (dataset = ((QueryRequest)request).getDataset()) != null) {
            Set defaultGraphs = dataset.getDefaultGraphs();
            for (IRI dg : defaultGraphs) {
                if (dg == null) continue;
                String dgs = dg.stringValue();
                if (dgs.startsWith(ADDED_CONTEXT_PREFIX)) {
                    RequestContextImpl requestContext = new RequestContextImpl();
                    String id = dgs.substring(ADDED_CONTEXT_PREFIX.length());
                    requestContext.setAttribute("added", (Object)id);
                    return requestContext;
                }
                if (!dgs.startsWith(REMOVED_CONTEXT_PREFIX)) continue;
                RequestContextImpl requestContext = new RequestContextImpl();
                String id = dgs.substring(REMOVED_CONTEXT_PREFIX.length());
                requestContext.setAttribute("removed", (Object)id);
                return requestContext;
            }
        }
        return null;
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        return 1.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (requestContext != null) {
            String addedId = (String)((RequestContextImpl)requestContext).getAttribute("added");
            if (addedId != null) {
                SailConnection storeInsertConnection = this.storeInsertConnections.get(addedId);
                if (storeInsertConnection == null) {
                    return StatementIterator.EMPTY;
                }
                return this.getStatements(subject, predicate, object, context, requestContext.getRequest().getIncludeInferred(), storeInsertConnection, pluginConnection.getEntities());
            }
            String removedId = (String)((RequestContextImpl)requestContext).getAttribute("removed");
            if (removedId != null) {
                SailConnection storeDeleteConnection = this.storeDeleteConnections.get(removedId);
                if (storeDeleteConnection == null) {
                    return StatementIterator.EMPTY;
                }
                return this.getStatements(subject, predicate, object, context, requestContext.getRequest().getIncludeInferred(), storeDeleteConnection, pluginConnection.getEntities());
            }
        }
        return null;
    }

    private void addChange(long subject, long predicate, long object, long context, boolean isExplicit, boolean isAdded, Entities entities) {
        Resource subjectValue = (Resource)entities.get(subject);
        IRI predicateValue = (IRI)entities.get(predicate);
        Value objectValue = entities.get(object);
        Resource contextValue = (Resource)entities.get(context);
        if (!isExplicit) {
            contextValue = implicitContext;
        }
        if (isAdded) {
            this.storeInsertConnection.addStatement(subjectValue, predicateValue, objectValue, new Resource[]{contextValue});
        } else {
            this.storeDeleteConnection.addStatement(subjectValue, predicateValue, objectValue, new Resource[]{contextValue});
        }
    }

    private StatementIterator getStatements(long subject, long predicate, long object, long context, final boolean includeInferred, SailConnection storeConnection, final Entities entities) {
        Resource subjectValue = (Resource)entities.get(subject);
        IRI predicateValue = (IRI)entities.get(predicate);
        Value objectValue = entities.get(object);
        Resource contextValue = (Resource)entities.get(context);
        Resource[] contexts = contextValue == null ? new Resource[]{} : (contextValue.equals((Object)SESAME.NIL) ? new Resource[]{null} : new Resource[]{contextValue});
        final CloseableIteration statements = storeConnection.getStatements(subjectValue, predicateValue, objectValue, true, contexts);
        return new StatementIterator(){

            public boolean next() {
                while (statements.hasNext()) {
                    Statement statement = (Statement)statements.next();
                    if (!includeInferred && implicitContext.equals((Object)statement.getContext())) continue;
                    this.subject = entities.put((Value)statement.getSubject(), Entities.Scope.REQUEST);
                    this.predicate = entities.put((Value)statement.getPredicate(), Entities.Scope.REQUEST);
                    this.object = entities.put(statement.getObject(), Entities.Scope.REQUEST);
                    Resource context = statement.getContext();
                    this.context = context != null ? entities.put((Value)context, Entities.Scope.REQUEST) : entities.put((Value)explicitContext, Entities.Scope.REQUEST);
                    return true;
                }
                return false;
            }

            public void close() {
                statements.close();
            }
        };
    }
}

