/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.helper.rdf.aggr;

import com.ontotext.graphdb.helper.rdf.InternalRdfValue;
import com.ontotext.graphdb.helper.tuple.ValuesTuple;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateCollector;

public class ModelCollector
implements AggregateCollector {
    private static final int MODEL_LIMIT = 10000;
    private final Model model = new TreeModel();

    public void add(Value value) {
        if (this.model.size() < 10000) {
            if (value instanceof Triple) {
                this.model.add(((Triple)value).getSubject(), ((Triple)value).getPredicate(), ((Triple)value).getObject(), new Resource[0]);
            } else {
                ValuesTuple vvt = ValuesTuple.fromValue(value);
                List<Value> values = vvt.getValues();
                if (values.size() == 3 || values.size() == 4) {
                    Value context;
                    Value subject = values.get(0);
                    Value predicate = values.get(1);
                    Value object = values.get(2);
                    Value value2 = context = values.size() > 3 ? values.get(3) : null;
                    if (subject instanceof Resource && predicate instanceof IRI && (context == null || context instanceof Resource)) {
                        this.model.add((Resource)subject, (IRI)predicate, object, new Resource[]{(Resource)context});
                    }
                }
            }
        } else {
            throw new QueryEvaluationException("Too many statements, the limit is 10000");
        }
    }

    public Value getFinalValue() {
        return new InternalRdfValue(this.model);
    }
}

