/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.helper;

import com.ontotext.graphdb.ContextAwareMagicProperty;
import com.ontotext.graphdb.MagicPropertyContext;
import com.ontotext.graphdb.helper.HelperFunctionCommon;
import com.ontotext.graphdb.helper.rdf.RdfValue;
import com.ontotext.graphdb.helper.tuple.ValuesTuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.spin.function.InverseMagicProperty;

public class IterateMagicProperty
implements InverseMagicProperty,
ContextAwareMagicProperty {
    public String getURI() {
        return HelperFunctionCommon.newIri("iterate");
    }

    public CloseableIteration<? extends List<? extends Value>> evaluate(MagicPropertyContext context, ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        int numVariables = context.getResultVariables().size();
        if (args[0] instanceof RdfValue) {
            if (numVariables < 3 || numVariables > 4) {
                throw new QueryEvaluationException("Iterating RDF requires 3 or 4 output variables but " + numVariables + " were given");
            }
            final boolean withGraph = numVariables > 3;
            Model model = ((RdfValue)args[0]).getModel();
            return new ConvertingIteration<Statement, List<? extends Value>>(this, (CloseableIteration)new CloseableIteratorIteration(model.iterator())){

                protected List<? extends Value> convert(Statement st) throws QueryEvaluationException {
                    if (withGraph) {
                        return Arrays.asList(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
                    }
                    return Arrays.asList(st.getSubject(), st.getPredicate(), st.getObject());
                }
            };
        }
        if (numVariables != 1) {
            throw new QueryEvaluationException("Iterating tuples requires 1 output variable but " + numVariables + " were given");
        }
        ValuesTuple valuesTuple = ValuesTuple.fromValue(args[0]);
        return new ConvertingIteration<Value, List<? extends Value>>(this, (CloseableIteration)new CloseableIteratorIteration(valuesTuple.iterator())){

            protected List<? extends Value> convert(Value value) throws QueryEvaluationException {
                return Collections.singletonList(value);
            }
        };
    }
}

