/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt.functions;

import com.ontotext.graphdb.ContextAwareMagicProperty;
import com.ontotext.graphdb.MagicPropertyContext;
import com.ontotext.graphdb.gpt.functions.AbstractGptMagicProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;

public class GptTable
extends AbstractGptMagicProperty
implements ContextAwareMagicProperty {
    private static final Pattern LIST_NUMBERS = Pattern.compile("^\\d+[.)] ");

    public String getURI() {
        return GptTable.newIri("table");
    }

    public CloseableIteration<? extends List<? extends Value>> evaluate(MagicPropertyContext context, ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        List<List<Value>> result = this.convertFromMarkdownTable(valueFactory, this.callGpt(AbstractGptMagicProperty.GPTResponseFormat.TABLE, context, args), context.getResultVariables().size());
        return new CollectionIteration(result);
    }

    private List<List<Value>> convertFromMarkdownTable(ValueFactory valueFactory, String result, int numOutputColumns) {
        String[] lines = result.split("\\n");
        for (int startIdx = 0; startIdx <= 2 && startIdx < lines.length; ++startIdx) {
            String[] headers;
            int numColumns;
            if (!lines[startIdx].contains("|") || (numColumns = (headers = this.trimRow(lines[startIdx]).split("\\|")).length) <= 0) continue;
            return this.extractTable(valueFactory, lines, startIdx, numOutputColumns);
        }
        Value[] resultArray = new Value[numOutputColumns];
        resultArray[0] = valueFactory.createLiteral(result);
        return Collections.singletonList(Arrays.asList(resultArray));
    }

    private List<List<Value>> extractTable(ValueFactory valueFactory, String[] lines, int startIndex, int numOutputColumns) {
        return Stream.of(lines).skip(startIndex + 2).map(line -> this.trimRow((String)line).split("\\s*\\|\\s*")).map(data -> {
            Matcher matcher = LIST_NUMBERS.matcher(data[0]);
            if (matcher.find()) {
                data[0] = matcher.replaceFirst("");
            }
            List values = Stream.of(data).limit(numOutputColumns).map(String::trim).map(arg_0 -> ((ValueFactory)valueFactory).createLiteral(arg_0)).collect(Collectors.toList());
            while (values.size() < numOutputColumns) {
                values.add(null);
            }
            return values;
        }).collect(Collectors.toList());
    }

    private String trimRow(String row) {
        if ((row = row.trim()).startsWith("|")) {
            row = row.substring(1);
        }
        if (row.endsWith("|")) {
            row = row.substring(0, row.length() - 1);
        }
        return row.trim();
    }
}

