/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import com.ontotext.graphdb.helper.rdf.RdfValue;
import com.ontotext.graphdb.helper.tuple.ValuesTuple;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.eclipse.collections.api.tuple.Triplet;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class GptUtil {
    public static String trimQuotes(String message) {
        if (message != null && message.startsWith("\"") && message.endsWith("\"")) {
            return message.substring(1, message.length() - 1);
        }
        return message;
    }

    public static List<String> valueToGptMessages(Map<String, String> namespaces, Value value) {
        if (value instanceof RdfValue) {
            Model model = ((RdfValue)value).getModel();
            boolean hasGraphs = false;
            for (Resource context : model.contexts()) {
                if (context == null) continue;
                hasGraphs = true;
                break;
            }
            return Collections.singletonList(GptUtil.serializeRdf(namespaces, hasGraphs, (Iterable<Statement>)model));
        }
        return ValuesTuple.fromValue(value).toDelimitedTable("\t");
    }

    public static double parseTemperature(String doubleString) {
        try {
            double temperature = Double.parseDouble(doubleString);
            if (temperature < 0.0 || temperature > 2.0) {
                throw new NumberFormatException();
            }
            return temperature;
        }
        catch (NumberFormatException e) {
            throw new QueryEvaluationException("Temperature must be a number between 0 and 2: " + doubleString);
        }
    }

    public static String serializeRdf(Map<String, String> namespaces, boolean hasGraphs, Iterable<Statement> statements) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            RDFWriter rdfWriter = Rio.createWriter((RDFFormat)(hasGraphs ? RDFFormat.TRIGSTAR : RDFFormat.TURTLESTAR), (Writer)writer);
            rdfWriter.startRDF();
            GptUtil.findUsedNamespacesForStatements(namespaces, statements).forEach((arg_0, arg_1) -> ((RDFWriter)rdfWriter).handleNamespace(arg_0, arg_1));
            statements.forEach(arg_0 -> ((RDFWriter)rdfWriter).handleStatement(arg_0));
            rdfWriter.endRDF();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return string;
    }

    public static Triplet<String> findIriNamespace(String iriString, BidiMap<String, String> namespaces) {
        String namespace;
        String prefix;
        int splitIdx = TurtleUtil.findURISplitIndex((String)iriString);
        if (splitIdx > 0 && (prefix = (String)namespaces.getKey((Object)(namespace = iriString.substring(0, splitIdx)))) != null) {
            return Tuples.triplet((Object)prefix, (Object)namespace, (Object)iriString.substring(splitIdx));
        }
        return null;
    }

    public static BidiMap<String, String> findUsedNamespacesForBindingSet(Map<String, String> namespaces, Iterable<BindingSet> result) {
        DualLinkedHashBidiMap usedNamespaces = new DualLinkedHashBidiMap();
        DualHashBidiMap allNamespaces = new DualHashBidiMap(namespaces);
        result.forEach(arg_0 -> GptUtil.lambda$findUsedNamespacesForBindingSet$1((BidiMap)allNamespaces, (BidiMap)usedNamespaces, arg_0));
        return usedNamespaces;
    }

    private static BidiMap<String, String> findUsedNamespacesForStatements(Map<String, String> namespaces, Iterable<Statement> statements) {
        DualLinkedHashBidiMap usedNamespaces = new DualLinkedHashBidiMap();
        DualHashBidiMap allNamespaces = new DualHashBidiMap(namespaces);
        statements.forEach(arg_0 -> GptUtil.lambda$findUsedNamespacesForStatements$2((BidiMap)allNamespaces, (BidiMap)usedNamespaces, arg_0));
        return usedNamespaces;
    }

    private static void addNamespaces(BidiMap<String, String> allNamespaces, Map<String, String> usedNamespaces, Value value) {
        if (value instanceof IRI) {
            Triplet<String> iriNamespace = GptUtil.findIriNamespace(value.stringValue(), allNamespaces);
            if (iriNamespace != null) {
                usedNamespaces.put((String)iriNamespace.getOne(), (String)iriNamespace.getTwo());
            }
        } else if (value instanceof Triple) {
            GptUtil.addNamespaces(allNamespaces, usedNamespaces, (Value)((Triple)value).getSubject());
            GptUtil.addNamespaces(allNamespaces, usedNamespaces, (Value)((Triple)value).getPredicate());
            GptUtil.addNamespaces(allNamespaces, usedNamespaces, ((Triple)value).getObject());
        }
    }

    private static /* synthetic */ void lambda$findUsedNamespacesForStatements$2(BidiMap allNamespaces, BidiMap usedNamespaces, Statement statement) {
        GptUtil.addNamespaces((BidiMap<String, String>)allNamespaces, (Map<String, String>)usedNamespaces, (Value)statement.getSubject());
        GptUtil.addNamespaces((BidiMap<String, String>)allNamespaces, (Map<String, String>)usedNamespaces, (Value)statement.getPredicate());
        GptUtil.addNamespaces((BidiMap<String, String>)allNamespaces, (Map<String, String>)usedNamespaces, statement.getObject());
        GptUtil.addNamespaces((BidiMap<String, String>)allNamespaces, (Map<String, String>)usedNamespaces, (Value)statement.getContext());
    }

    private static /* synthetic */ void lambda$findUsedNamespacesForBindingSet$1(BidiMap allNamespaces, BidiMap usedNamespaces, BindingSet bs) {
        bs.forEach(b -> GptUtil.addNamespaces((BidiMap<String, String>)allNamespaces, (Map<String, String>)usedNamespaces, b.getValue()));
    }
}

