/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import com.ontotext.graphdb.EnrichingExplainer;
import com.ontotext.graphdb.gpt.BindingSetPrinter;
import com.ontotext.graphdb.gpt.BufferingIteration;
import com.ontotext.graphdb.gpt.GptClients;
import com.ontotext.graphdb.gpt.GptExplainParameters;
import com.ontotext.graphdb.gpt.GptUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;

public class GptExplainer
extends EnrichingExplainer {
    private static final int PEEK_NUM_RESULTS = 1000;
    private static final IRI GPT_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/gpt");
    private GptExplainParameters params;
    private CloseableIteration<BindingSet> iteration;

    public GptExplainer() {
        super("gpt");
    }

    public IRI getIri() {
        return GPT_IRI;
    }

    protected void setExplainData(String queryString, boolean isGraph, Set<String> projectionVars, Map<String, String> namespaces) {
        this.params = new GptExplainParameters(queryString, isGraph, projectionVars, namespaces);
    }

    protected boolean replacesResult() {
        return this.params.noEval;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected String getExplanation(CloseableIteration<BindingSet> result) {
        queryResult = null;
        peekResult /* !! */  = Collections.emptyList();
        if (this.params.noEval) {
            this.iteration = new EmptyIteration();
            var4_4 = result;
            try {
                if (this.params.queryOnly) ** GOTO lbl16
                peekResult /* !! */  = result.stream().limit(1000L).collect(Collectors.toList());
            }
            finally {
                if (var4_4 != null) {
                    var4_4.close();
                }
            }
        } else {
            this.iteration = new BufferingIteration(result, 1000);
            peekResult /* !! */  = ((BufferingIteration)this.iteration).peek();
        }
lbl16:
        // 3 sources

        if (!this.params.queryOnly) {
            queryResult = this.queryResultToString(peekResult /* !! */ );
        }
        return this.explainWithParameters(this.params, queryResult);
    }

    public CloseableIteration<BindingSet> explainedIteration() {
        return this.iteration;
    }

    private String queryResultToString(List<BindingSet> result) {
        BidiMap<String, String> usedNamespaces = GptUtil.findUsedNamespacesForBindingSet(this.params.namespaces, result);
        if (this.params.isGraph) {
            return GptUtil.serializeRdf(usedNamespaces, false, () -> result.stream().map(bs -> SimpleValueFactory.getInstance().createStatement((Resource)bs.getValue("subject"), (IRI)bs.getValue("predicate"), bs.getValue("object"))).iterator());
        }
        return BindingSetPrinter.printBindings(this.params.bindingNames, result, usedNamespaces);
    }

    private String explainWithParameters(GptExplainParameters params, String sparqlResult) {
        if (params.queryOnly) {
            if (params.custom != null) {
                return this.explainCustom(params.custom, params.query, params.instructions, params.temperature);
            }
            return this.explainQuery(params.query, params.instructions, params.temperature);
        }
        if (params.resultOnly) {
            if (params.custom != null) {
                return this.explainCustom(params.custom, sparqlResult, params.instructions, params.temperature);
            }
            return this.explainResult(sparqlResult, params.isGraph, params.instructions, params.temperature);
        }
        return this.explainQueryAndResult(params.query, sparqlResult, params.instructions, params.temperature);
    }

    private String explainQueryAndResult(String sparqlQuery, String sparqlResult, List<String> instructions, Double temperature) {
        List<String> messages = List.of("Given this SPARQL query:", sparqlQuery, "Explain the SPARQL result.");
        return this.explain(instructions, messages, sparqlResult, temperature);
    }

    private String explainCustom(String custom, String customData, List<String> instructions, Double temperature) {
        List<String> messages = Collections.singletonList(custom);
        return this.explain(instructions, messages, customData, temperature);
    }

    private String explainQuery(String sparqlQuery, List<String> instructions, Double temperature) {
        List<String> messages = Collections.singletonList("Explain this SPARQL query.");
        return this.explain(instructions, messages, sparqlQuery, temperature);
    }

    private String explainResult(String sparqlResult, boolean isGraph, List<String> instructions, Double temperature) {
        List<String> messages = isGraph ? Collections.singletonList("Summarize this RDF data.") : Collections.singletonList("Summarize this SPARQL result.");
        return this.explain(instructions, messages, sparqlResult, temperature);
    }

    private String explain(List<String> systemMessages, List<String> messages, String dataMessage, Double temperature) {
        return GptClients.getInstance().chat(systemMessages, messages, List.of(dataMessage.split("\\n")), temperature);
    }
}

