/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class BufferingIteration
implements CloseableIteration<BindingSet> {
    private final CloseableIteration<BindingSet> delegate;
    private final List<BindingSet> buffer = new ArrayList<BindingSet>();
    private final int maxBufferSize;
    private int bufferPosition;

    public BufferingIteration(CloseableIteration<BindingSet> delegate, int maxBufferSize) {
        this.delegate = delegate;
        this.maxBufferSize = maxBufferSize;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.bufferPosition < this.buffer.size() || this.delegate.hasNext();
    }

    public BindingSet next() throws QueryEvaluationException {
        BindingSet bs;
        if (this.bufferPosition < this.buffer.size()) {
            bs = this.buffer.get(this.bufferPosition);
            ++this.bufferPosition;
        } else {
            bs = (BindingSet)this.delegate.next();
            if (this.buffer.size() < this.maxBufferSize) {
                this.buffer.add(bs);
                ++this.bufferPosition;
            }
        }
        return bs;
    }

    public void reset() {
        this.bufferPosition = 0;
    }

    public List<BindingSet> peek() {
        try {
            List<BindingSet> list = this.stream().limit(this.maxBufferSize).collect(Collectors.toList());
            return list;
        }
        finally {
            this.reset();
        }
    }

    public void remove() throws QueryEvaluationException {
        throw new IllegalStateException();
    }

    public void close() throws QueryEvaluationException {
        this.delegate.close();
    }
}

