/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalStore;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class SmartMultiFieldQueryParser
extends MultiFieldQueryParser {
    private final Lucene4ExternalStore externalStore;

    public SmartMultiFieldQueryParser(Lucene4ExternalStore externalStore, Map<String, Float> boosts) {
        super(externalStore.indexedFieldsArray, externalStore.searchAnalyzer, boosts);
        this.externalStore = externalStore;
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        if (!this.isFTS(field)) {
            return new TermQuery(new Term(field, queryText));
        }
        return super.newFieldQuery(analyzer, field, queryText, quoted);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(this.getPrefixQuery(this.fields[i], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        if (!this.getAllowLeadingWildcard() && termStr.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (!this.isFTS(field)) {
            return this.newPrefixQuery(new Term(field, termStr));
        }
        return super.getPrefixQuery(field, termStr);
    }

    private boolean isFTS(String field) {
        return this.externalStore.indexedFields.getOrDefault(field, false) != false && !this.externalStore.isFieldURI(field);
    }
}

