/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptCompiler;

public class Lucene4SearchOptions
extends SearchOptions {
    private static final String LIST_SEPARATOR = ",";
    private static final String BOOST_SEPARATOR_REGEX = "\\^";
    public Map<String, Float> boosts = null;
    public String scoreExpr = null;
    public Expression expression;

    public void setBoosts(String strBoosts) {
        this.boosts = new HashMap<String, Float>();
        for (String kvp : strBoosts.split(LIST_SEPARATOR)) {
            String[] keyValue = kvp.split(BOOST_SEPARATOR_REGEX);
            String field = keyValue[0];
            float boost = 1.0f;
            if (keyValue.length > 1) {
                boost = Float.parseFloat(keyValue[1]);
            }
            this.boosts.put(field, Float.valueOf(boost));
        }
    }

    public void setScoreExpr(String strScoreExpr) {
        this.scoreExpr = strScoreExpr;
        try {
            this.expression = JavascriptCompiler.compile((String)strScoreExpr);
        }
        catch (ParseException e) {
            throw new ConnectorUserException("Cannot compile expression", (Throwable)e);
        }
    }
}

