/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.hl.HLHelperFastVector;
import com.ontotext.trree.sdk.ServerErrorException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;

public class Lucene4Result
implements DocumentsResult {
    private final IndexSearcher searcher;
    private final TopDocs topDocs;
    private final HLHelperFastVector hlHelper;
    private final String indexName;
    private final Logger logger;
    private int currentPosition;

    Lucene4Result(String indexName, Logger logger, IndexSearcher searcher, TopDocs topDocs, HLHelperFastVector hlHelper) {
        this.searcher = searcher;
        this.topDocs = topDocs;
        this.hlHelper = hlHelper;
        this.indexName = indexName;
        this.logger = logger;
        this.currentPosition = -1;
    }

    public long totalSize() {
        return this.topDocs.totalHits.value;
    }

    public double getCurrentScore() {
        return this.topDocs.scoreDocs[this.currentPosition].score;
    }

    public String getCurrentSubject() {
        try {
            Document doc = this.searcher.doc(this.topDocs.scoreDocs[this.currentPosition].doc);
            String subject = doc.getField("subject").stringValue();
            this.logger.debug("[{}] RESULT: {} with score {}", new Object[]{this.indexName, subject, Float.valueOf(this.topDocs.scoreDocs[this.currentPosition].score)});
            return subject;
        }
        catch (Exception e) {
            this.logger.error("[" + this.indexName + "] Reading document failed", (Throwable)e);
            throw new ServerErrorException("Reading document failed", (Throwable)e);
        }
    }

    public Collection<SnippetResult> getCurrentSnippets() {
        return this.hlHelper.getSnippetsForResultIndex(this.topDocs, this.currentPosition);
    }

    public boolean next() {
        boolean hasNext;
        ++this.currentPosition;
        boolean bl = hasNext = this.currentPosition < this.topDocs.scoreDocs.length;
        if (!hasNext) {
            this.currentPosition = -1;
        }
        return hasNext;
    }
}

