/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.google.common.collect.ImmutableList;
import com.ontotext.graphdb.Config;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4SearchOptions;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ServerErrorException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.search.IndexSearcher;
import org.eclipse.rdf4j.model.Value;

public class Lucene4Plugin
extends ExternalSyncPlugin {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-lucene-option-description", Locale.getDefault());
    private static final String BOOST_PROPERTIES_OPTION = "boostProperties";
    private static final String ANALYZER_OPTION = "analyzer";
    private static final String STRIP_MARKUP_OPTION = "stripMarkup";
    private static final String SEARCH_OPTION_BOOSTS = "boosts";
    private static final String SEARCH_OPTION_SCORE_EXPR = "scoreExpr";
    private long searchOptionBoostsId;
    private long searchOptionScoreExprId;
    public static final Option<Boolean> stripMarkup;
    public static final Option<String> analyzer;
    public static final Option<List<String>> BOOST_PROPERTIES;
    public static final List<Option<?>> LUCENE_OPTIONS;

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return Lucene4ExternalStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        try {
            return Lucene4ExternalStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
        }
        catch (IOException e) {
            this.getLogger().error("[" + storeName + "] Unable to create index", (Throwable)e);
            throw new ServerErrorException("Unable to create index", (Throwable)e);
        }
    }

    public List<Option<?>> getAllOptions() {
        return LUCENE_OPTIONS;
    }

    public String getURIComponent() {
        return "lucene";
    }

    public String getName() {
        return "lucene-connector";
    }

    public String getShortName() {
        return "Lucene";
    }

    protected long[] getCustomSearchOptions(Entities entities) {
        this.searchOptionBoostsId = entities.put((Value)this.valueFactory.createIRI(this.getURIPrefixControl() + SEARCH_OPTION_BOOSTS), Entities.Scope.SYSTEM);
        return new long[]{this.searchOptionBoostsId, this.searchOptionScoreExprId = entities.put((Value)this.valueFactory.createIRI(this.getURIPrefixControl() + SEARCH_OPTION_SCORE_EXPR), Entities.Scope.SYSTEM)};
    }

    protected void processCustomSearchOption(long predicate, SearchOptions searchOptions, String optionStr) {
        if (predicate == this.searchOptionBoostsId) {
            ((Lucene4SearchOptions)searchOptions).setBoosts(optionStr);
        } else if (predicate == this.searchOptionScoreExprId) {
            ((Lucene4SearchOptions)searchOptions).setScoreExpr(optionStr);
        }
    }

    protected SearchOptions createSearchOptions() {
        return new Lucene4SearchOptions();
    }

    public void checkRequiredCapabilities(PluginConnection pluginConnection) {
    }

    static {
        ClassLoader actualClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Lucene4ExternalRetrieve.class.getClassLoader());
            Class.forName(PostingsFormat.class.getName());
            Class.forName(Codec.class.getName());
            Class.forName(DocValuesFormat.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't workaround the dumb PostingsFormat class loading in lucene4", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(actualClassLoader);
        }
        IndexSearcher.setMaxClauseCount((int)Config.getPropertyAsInt((String)"graphdb.lucene.maxclause", (int)4096));
        stripMarkup = Option.flag((String)STRIP_MARKUP_OPTION, (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
        analyzer = Option.string((String)ANALYZER_OPTION, (ResourceBundle)RESOURCE_BUNDLE).build();
        BOOST_PROPERTIES = Option.stringList((String)BOOST_PROPERTIES_OPTION, (ResourceBundle)RESOURCE_BUNDLE).build();
        LUCENE_OPTIONS = ImmutableList.builder().add((Object)Lucene4Plugin.createFieldsOptions((Option[])new Option[]{Option.flag((String)"facet", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build()})).addAll((Iterable)DEFAULT_OPTIONS).add(BOOST_PROPERTIES).add(stripMarkup).add(analyzer).build();
    }
}

