/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.plugin;

import com.ontotext.graphdb.plugins.textmining.plugin.ClientType;
import com.ontotext.trree.sdk.PluginException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class ClientConfig
implements Serializable {
    private static final Header TEXT_PLAIN_CONTENT_TYPE_HEADER = new BasicHeader("Content-Type", "text/plain");
    private static final Header APPLICATION_JSON_CONTENT_TYPE_HEADER = new BasicHeader("Content-Type", "application/json");
    private static final Header CES_ACCEPT_TYPE_HEADER = new BasicHeader("Accept", "application/vnd.ontotext.ces+json");
    private static final Header GATE_ACCEPT_TYPE_HEADER = new BasicHeader("Accept", "application/gate+json");
    private ClientType type;
    private String name;
    private URI serviceLocation;
    private final Set<Header> headers = new HashSet<Header>();
    private String transformation;
    private boolean sense2Vec = true;

    public ClientType getType() {
        return this.type;
    }

    public void setType(ClientType type) {
        this.type = type;
        this.addPredefinedHeaders();
    }

    public URI getServiceLocation() {
        return this.serviceLocation;
    }

    public void setServiceLocation(URI serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    public Set<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(String header) {
        String[] split = header.split("[:]");
        assert (split.length == 2);
        String headerKey = split[0].trim();
        if (this.type != ClientType.CES && this.type != ClientType.GENERIC && (headerKey.equals("Content-Type") || headerKey.equals("Accept"))) {
            throw new PluginException(String.format("Can not modify predefined \"%s\" for %s service", headerKey, this.getType().toString()));
        }
        BasicHeader headerPair = new BasicHeader(headerKey, split[1].trim());
        this.headers.removeIf(arg_0 -> ClientConfig.lambda$addHeader$0((Header)headerPair, arg_0));
        this.headers.add((Header)headerPair);
    }

    public void setBaseAuthHeader(String baseAuthHeader) {
        if (this.type == ClientType.GATE) {
            throw new PluginException("Please provide your API key ID and password for Basic authentication");
        }
        String[] split = baseAuthHeader.split("[:]");
        assert (split.length == 2);
        this.headers.add((Header)new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(baseAuthHeader.getBytes(StandardCharsets.UTF_8))));
    }

    private void addPredefinedHeaders() {
        switch (this.type) {
            case CES: {
                this.headers.add(TEXT_PLAIN_CONTENT_TYPE_HEADER);
                this.headers.add(CES_ACCEPT_TYPE_HEADER);
                break;
            }
            case GATE: {
                this.headers.add(TEXT_PLAIN_CONTENT_TYPE_HEADER);
                this.headers.add(GATE_ACCEPT_TYPE_HEADER);
                break;
            }
            case SPACY: 
            case GENERIC: {
                this.headers.add(APPLICATION_JSON_CONTENT_TYPE_HEADER);
            }
        }
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSense2Vec() {
        return this.sense2Vec;
    }

    public void setSense2Vec(boolean sense2Vec) {
        this.sense2Vec = sense2Vec;
    }

    private static /* synthetic */ boolean lambda$addHeader$0(Header headerPair, Header headerToRemove) {
        return headerToRemove.getName().equalsIgnoreCase(headerPair.getName());
    }
}

