/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ontotext.graphdb.plugins.textmining.model.Annotation;
import com.ontotext.graphdb.plugins.textmining.plugin.TextMiningPlugin;
import com.ontotext.trree.sdk.PluginException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.DigestUtils;

public class Document {
    public static final String ID = "id";
    public static final String TYPE = "type";
    public static final String AUTHOR = "author";
    public static final String SOURCE = "source";
    public static final String TITLE = "title";
    public static final String CATEGORY = "category";
    public static final String DATE = "date";
    private String content;
    private List<String> sentences = new LinkedList<String>();
    private String language;
    private Map<String, Object> features = new HashMap<String, Object>();
    private List<Annotation> annotations = new LinkedList<Annotation>();
    private String rawSource;
    @JsonIgnore
    private MemoryStore rdf;

    public List<String> getSentences() {
        return this.sentences;
    }

    public void setSentences(List<String> sentences) {
        this.sentences = sentences;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRawSource() {
        return this.rawSource;
    }

    public void setRawSource(String rawSource) {
        this.rawSource = rawSource;
    }

    public void setRDF(MemoryStore rdf) {
        this.rdf = rdf;
    }

    public MemoryStore getRDF() {
        return this.rdf;
    }

    public void generateRDF(String clientName) {
        if (StringUtils.isEmpty((CharSequence)this.content)) {
            throw new PluginException("Document must have content.");
        }
        MemoryStore innerRdf = new MemoryStore();
        HashMap<String, Resource> sentenceMap = new HashMap<String, Resource>();
        NotifyingSailConnection conn = innerRdf.getConnection();
        conn.begin();
        ValueFactory vf = innerRdf.getValueFactory();
        IRI documentIRI = vf.createIRI("http://www.ontotext.com/textmining/document/", DigestUtils.md5DigestAsHex((byte[])this.content.getBytes(StandardCharsets.UTF_8)));
        this.processFeatures(vf, conn, (Resource)documentIRI, this.getFeatures());
        int sentenceCount = 1;
        long annotationCount = 1L;
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation == null) {
                throw new InvalidParameterException("Not proper transformation for the provided response for client: " + clientName);
            }
            Resource annotationIRI = this.createAnnotationIRI(vf, documentIRI, annotation, annotationCount++, clientName);
            conn.addStatement((Resource)documentIRI, TextMiningPlugin.ANNOTATIONS_PREDICATE, (Value)annotationIRI, new Resource[0]);
            annotation.setResource((Value)annotationIRI);
            String sentenceText = annotation.getSentenceText();
            Resource sentenceIRI = null;
            if (sentenceText != null) {
                sentenceIRI = (Resource)sentenceMap.get(sentenceText);
                if (sentenceIRI == null) {
                    sentenceIRI = vf.createIRI("http://www.ontotext.com/textmining#", "sentence" + sentenceCount++);
                    sentenceMap.put(sentenceText, sentenceIRI);
                    conn.addStatement(sentenceIRI, TextMiningPlugin.SENTENCE_TEXT, (Value)vf.createLiteral(sentenceText), new Resource[0]);
                }
                conn.addStatement(annotationIRI, TextMiningPlugin.HAS_SENTENSE_PREDICATE, (Value)sentenceIRI, new Resource[0]);
            }
            conn.addStatement(annotationIRI, TextMiningPlugin.ANNOTATION_KEY, (Value)this.createAnnotationKey(vf, documentIRI, annotation), new Resource[0]);
            conn.addStatement(annotationIRI, TextMiningPlugin.ANNOTATION_TEXT, (Value)vf.createLiteral(annotation.getText()), new Resource[0]);
            conn.addStatement(annotationIRI, TextMiningPlugin.ANNOTATION_TYPE, (Value)vf.createLiteral(annotation.getType()), new Resource[0]);
            conn.addStatement(annotationIRI, TextMiningPlugin.ANNOTATION_START, (Value)vf.createLiteral(annotation.getStartOffset()), new Resource[0]);
            conn.addStatement(annotationIRI, TextMiningPlugin.ANNOTATION_END, (Value)vf.createLiteral(annotation.getEndOffset()), new Resource[0]);
            Map<String, Object> annotationFeatures = annotation.getFeatures();
            this.processFeatures(vf, conn, annotationIRI, annotationFeatures);
        }
        conn.commit();
        this.setRDF(innerRdf);
    }

    private Resource createAnnotationIRI(ValueFactory vf, IRI documentIRI, Annotation annotation, long annotationNumber, String clientName) {
        return vf.createIRI(documentIRI.stringValue(), this.getAnnotationOffsetPart(annotation) + "/" + clientName + "/" + annotationNumber);
    }

    @NotNull
    private String getAnnotationOffsetPart(Annotation annotation) {
        return "/annotation/" + annotation.getStartOffset() + "/" + annotation.getEndOffset();
    }

    private Resource createAnnotationKey(ValueFactory vf, IRI documentIRI, Annotation annotation) {
        return vf.createIRI(documentIRI.stringValue(), "/annotation/" + annotation.getStartOffset() + "/" + annotation.getEndOffset());
    }

    private void processFeatures(ValueFactory vf, NotifyingSailConnection conn, Resource nodeId, Map<String, ?> features) {
        if (features != null && features.size() > 0) {
            for (Map.Entry<String, ?> pair : features.entrySet()) {
                Object pairValue = pair.getValue();
                if (pairValue == null) continue;
                if (pairValue instanceof List) {
                    this.resolveListObject(vf, conn, nodeId, pair);
                    continue;
                }
                this.processNonArrayFeatures(vf, conn, nodeId, pair.getKey(), pairValue);
            }
        }
    }

    private void processNonArrayFeatures(ValueFactory vf, NotifyingSailConnection conn, Resource nodeId, String pairKey, Object pairValue) {
        BNode item = vf.createBNode();
        if (pairValue instanceof Map) {
            this.resolveMapObject(pairValue, vf, conn, (Resource)item, pairKey);
        } else {
            conn.addStatement((Resource)item, vf.createIRI("http://www.ontotext.com/textmining#", pairKey), this.createLiteral(vf, pairValue), new Resource[0]);
        }
        conn.addStatement(nodeId, TextMiningPlugin.FEATURES_PREDICATE, (Value)item, new Resource[0]);
    }

    private void resolveListObject(ValueFactory vf, NotifyingSailConnection conn, Resource nodeId, Map.Entry<String, ?> pair) {
        List elements = (List)pair.getValue();
        if (elements.isEmpty()) {
            return;
        }
        for (Object element : elements) {
            this.processNonArrayFeatures(vf, conn, nodeId, pair.getKey(), element);
        }
    }

    private void resolveMapObject(Object element, ValueFactory vf, NotifyingSailConnection conn, Resource nodeId, String pairKey) {
        BNode item = vf.createBNode();
        for (Map.Entry currentEntry : ((Map)element).entrySet()) {
            String key = (String)currentEntry.getKey();
            Object value = currentEntry.getValue();
            if (value instanceof Double || value instanceof Float) {
                conn.addStatement((Resource)item, vf.createIRI("http://www.ontotext.com/textmining#", key), (Value)vf.createLiteral(((Number)value).doubleValue()), new Resource[0]);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                conn.addStatement((Resource)item, vf.createIRI("http://www.ontotext.com/textmining#", key), (Value)vf.createLiteral(((Number)value).longValue()), new Resource[0]);
                continue;
            }
            if (value instanceof List) {
                this.resolveListObject(vf, conn, nodeId, currentEntry);
                continue;
            }
            if (value instanceof Map) {
                this.resolveMapObject(element, vf, conn, (Resource)item, key);
                continue;
            }
            if (this.isValidIRI(value.toString())) {
                conn.addStatement((Resource)item, vf.createIRI("http://www.ontotext.com/textmining#", key), (Value)vf.createIRI(value.toString()), new Resource[0]);
                continue;
            }
            conn.addStatement((Resource)item, vf.createIRI("http://www.ontotext.com/textmining#", key), (Value)vf.createLiteral(value.toString()), new Resource[0]);
        }
        conn.addStatement(nodeId, vf.createIRI("http://www.ontotext.com/textmining#", pairKey), (Value)item, new Resource[0]);
    }

    private Value createLiteral(ValueFactory vf, Object value) {
        if (value instanceof Byte) {
            return vf.createLiteral(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return vf.createLiteral(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return vf.createLiteral(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return vf.createLiteral(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return vf.createLiteral((BigInteger)value);
        }
        if (value instanceof Date) {
            return vf.createLiteral((Date)value);
        }
        if (value instanceof Float) {
            return vf.createLiteral(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return vf.createLiteral(((Double)value).doubleValue());
        }
        if (this.isValidIRI(value.toString())) {
            return vf.createIRI(value.toString());
        }
        if (value instanceof String) {
            return vf.createLiteral((String)value);
        }
        return vf.createLiteral(value.toString());
    }

    private boolean isValidIRI(String iriString) {
        if (iriString == null) {
            return false;
        }
        try {
            return new ParsedIRI(iriString).isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

