/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.iterators;

import com.ontotext.graphdb.plugins.textmining.model.Annotation;
import com.ontotext.trree.sdk.Entities;
import java.util.List;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMiningEntityResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextMiningEntityResult.class);
    private final List<Annotation> textMiningEntities;
    private int currentPosition;
    private Entities entities;

    public TextMiningEntityResult(List<Annotation> textMiningEntities) {
        this.textMiningEntities = textMiningEntities;
        this.currentPosition = -1;
    }

    public long getCurrentEntityText() {
        String entityValue = this.textMiningEntities.get(this.currentPosition).getText();
        return this.registerEntity(entityValue);
    }

    public long getCurrentEntityType() {
        String entityValue = this.textMiningEntities.get(this.currentPosition).getType();
        return this.registerEntity(entityValue);
    }

    public long getCurrentEntityStart() {
        long entityValue = this.textMiningEntities.get(this.currentPosition).getStartOffset();
        return this.registerEntity(entityValue);
    }

    public long getCurrentEntityEnd() {
        long entityValue = this.textMiningEntities.get(this.currentPosition).getEndOffset();
        return this.registerEntity(entityValue);
    }

    public Value getCurrentEntityResource() {
        return this.textMiningEntities.get(this.currentPosition).getResource();
    }

    private long registerEntity(String entity) {
        Literal l = SimpleValueFactory.getInstance().createLiteral(entity);
        long valueId = this.entities.put((Value)l, Entities.Scope.REQUEST);
        return valueId;
    }

    private long registerEntity(Long entity) {
        Literal l = SimpleValueFactory.getInstance().createLiteral(entity.longValue());
        long valueId = this.entities.put((Value)l, Entities.Scope.REQUEST);
        return valueId;
    }

    public boolean next() {
        boolean hasNext;
        ++this.currentPosition;
        boolean bl = hasNext = this.currentPosition < this.textMiningEntities.size();
        if (!hasNext) {
            this.currentPosition = -1;
        }
        return hasNext;
    }

    public void setEntities(Entities entities) {
        this.entities = entities;
    }
}

