/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.iterators;

import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientType;
import com.ontotext.graphdb.plugins.textmining.plugin.TextMiningPlugin;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.eclipse.rdf4j.model.Value;

public class TextMiningConfigIterator
extends StatementIterator {
    private final TextMiningPlugin plugin;
    private final Entities entities;
    private final long[] predicates;
    private final ClientConfig clientConfig;
    private final Deque<Header> headersCopy;
    private int index;
    private final boolean isRestricted;

    public TextMiningConfigIterator(TextMiningPlugin plugin, ClientConfig clientConfig, long predicate, PluginConnection pluginConnection) {
        this.plugin = plugin;
        this.entities = pluginConnection.getEntities();
        this.clientConfig = clientConfig;
        this.headersCopy = new ArrayDeque<Header>(clientConfig.getHeaders());
        boolean bl = this.isRestricted = !pluginConnection.getSecurityContext().hasWriteAccess();
        if (predicate == 0L) {
            this.predicates = this.getPredicatesToListen();
        } else if (predicate == plugin.getHeaderPredicateId() && !this.isRestricted) {
            this.predicates = new long[this.headersCopy.size()];
            Arrays.fill(this.predicates, predicate);
        } else {
            this.predicates = new long[]{predicate};
        }
    }

    public boolean next() {
        if (this.index < this.predicates.length) {
            this.predicate = this.predicates[this.index++];
            if (this.predicate == this.plugin.getConnectPredicateId()) {
                if (this.clientConfig.getType() != null) {
                    this.object = this.getTypeIdFromConfigType(this.clientConfig.getType());
                } else {
                    return this.next();
                }
            }
            if (this.predicate == this.plugin.getServicePredicateId()) {
                if (this.isRestricted) {
                    this.object = this.createRestrictedLiteral(this.entities);
                } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientConfig.getServiceLocation().toString()})) {
                    this.object = this.entities.put((Value)TextMiningPlugin.VF.createLiteral(this.clientConfig.getServiceLocation().toString()), Entities.Scope.REQUEST);
                } else {
                    return this.next();
                }
            }
            if (this.predicate == this.plugin.getHeaderPredicateId()) {
                if (this.isRestricted) {
                    this.object = this.createRestrictedLiteral(this.entities);
                } else if (!this.headersCopy.isEmpty() && this.headersCopy.peek() != null) {
                    this.object = this.entities.put((Value)TextMiningPlugin.VF.createLiteral(this.headersCopy.poll().toString()), Entities.Scope.REQUEST);
                } else {
                    return this.next();
                }
            }
            if (this.predicate == this.plugin.getSense2VecPredicateId()) {
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientConfig.getServiceLocation().toString()})) {
                    this.object = this.entities.put((Value)TextMiningPlugin.VF.createLiteral(this.clientConfig.isSense2Vec()), Entities.Scope.REQUEST);
                } else {
                    return this.next();
                }
            }
            if (this.predicate == this.plugin.getTransformationPredicateId()) {
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientConfig.getTransformation()})) {
                    this.object = this.entities.put((Value)TextMiningPlugin.VF.createLiteral(this.clientConfig.getTransformation()), Entities.Scope.REQUEST);
                } else {
                    return this.next();
                }
            }
            return true;
        }
        return false;
    }

    public void close() {
    }

    private long[] getPredicatesToListen() {
        ArrayList<Long> preds = new ArrayList<Long>();
        preds.add(this.plugin.getConnectPredicateId());
        preds.add(this.plugin.getServicePredicateId());
        preds.add(this.plugin.getTransformationPredicateId());
        if (this.clientConfig.getType() == ClientType.SPACY) {
            preds.add(this.plugin.getSense2VecPredicateId());
        }
        if (this.isRestricted) {
            preds.add(this.plugin.getHeaderPredicateId());
        } else {
            this.headersCopy.forEach(header -> preds.add(this.plugin.getHeaderPredicateId()));
        }
        return preds.stream().mapToLong(l -> l).toArray();
    }

    private long getTypeIdFromConfigType(ClientType clientType) {
        switch (clientType) {
            case CES: {
                return this.plugin.getCesTypeId();
            }
            case GATE: {
                return this.plugin.getGateTypeId();
            }
            case GENERIC: {
                return this.plugin.getProviderTypeId();
            }
            case SPACY: {
                return this.plugin.getSpacyTypeId();
            }
        }
        throw new PluginException("Unknown client type");
    }

    private long createRestrictedLiteral(Entities entities) {
        return entities.put((Value)TextMiningPlugin.VF.createLiteral("<restricted>"), Entities.Scope.REQUEST);
    }
}

