/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.clients;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.graphdb.plugins.textmining.clients.TextMiningClient;
import com.ontotext.graphdb.plugins.textmining.model.Document;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientConfig;
import com.ontotext.graphdb.plugins.textmining.plugin.ClientType;
import com.ontotext.graphdb.plugins.textmining.plugin.TextMiningException;
import com.ontotext.trree.sdk.PluginException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.RDFHandlerWrapper;
import org.eclipse.rdf4j.rio.jsonld.JSONLDParser;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase
implements TextMiningClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBase.class);
    protected final ClientConfig clientConfig;
    private int ignoreErrors = 0;
    private int currentErrors = 0;
    private IRI clientIRI;

    protected ClientBase(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void setErrorsToIgnore(int errors) {
        this.ignoreErrors = errors;
    }

    protected abstract Document convertJSONToDocument(JsonNode var1);

    protected abstract StringEntity getStringEntity(String var1, Map<String, String> var2) throws IOException;

    protected boolean checkResponseStatusOK(HttpResponse response) {
        try {
            if (response.getStatusLine().getStatusCode() != 200) {
                if (this.ignoreErrors == -1 || this.currentErrors < this.ignoreErrors) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ignoring errors. Threshold is : {} and current errors are {}", (Object)this.ignoreErrors, (Object)this.currentErrors);
                    }
                    return false;
                }
                String responseContent = IOUtil.readString((InputStream)response.getEntity().getContent());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Server response: {} Status: {}", (Object)responseContent, (Object)response.getStatusLine().getStatusCode());
                }
                throw new TextMiningException(responseContent);
            }
        }
        catch (IOException e) {
            throw new TextMiningException(e.getMessage());
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private Document getAnnotatedDocument(String content, Resource docIRI, Map<String, String> documentFeatures) throws IOException, PluginException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            Document document;
            block27: {
                ObjectMapper objectMapper;
                CloseableHttpResponse response;
                block25: {
                    Document document2;
                    block26: {
                        block23: {
                            Document document3;
                            block24: {
                                HttpPost httpPost = new HttpPost(this.getEndpoint().toString());
                                this.clientConfig.getHeaders().forEach(arg_0 -> ((HttpPost)httpPost).setHeader(arg_0));
                                httpPost.setEntity((HttpEntity)this.getStringEntity(content, documentFeatures));
                                response = httpclient.execute((HttpUriRequest)httpPost);
                                if (this.checkResponseStatusOK((HttpResponse)response)) break block23;
                                String message = IOUtil.readString((InputStream)response.getEntity().getContent());
                                document3 = this.writeError(content, response.getStatusLine().getStatusCode(), message);
                                if (response == null) break block24;
                                response.close();
                            }
                            return document3;
                        }
                        objectMapper = new ObjectMapper();
                        if (!this.isJSONLDClient()) break block25;
                        final Document result = new Document();
                        JSONLDParser parser = new JSONLDParser();
                        final MemoryStore rdfStore = new MemoryStore();
                        parser.setRDFHandler((RDFHandler)new RDFHandlerWrapper(new RDFHandler[0]){
                            private NotifyingSailConnection connection;

                            public void startRDF() throws RDFHandlerException {
                                super.startRDF();
                                this.connection = rdfStore.getConnection();
                                this.connection.begin();
                            }

                            public void handleStatement(Statement statement) throws RDFHandlerException {
                                this.connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
                            }

                            public void endRDF() throws RDFHandlerException {
                                super.endRDF();
                                this.connection.commit();
                                result.setRDF(rdfStore);
                            }
                        });
                        parser.parse(response.getEntity().getContent());
                        document2 = result;
                        if (response == null) break block26;
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (response != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (TextMiningException tme) {
                                    throw tme;
                                }
                                catch (Exception e) {
                                    if (this.ignoreErrors == -1 || this.currentErrors < this.ignoreErrors) {
                                        Document document4 = this.writeError(content, 500, e.getMessage());
                                        return document4;
                                    }
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("An error occurred while executing annotation request: {}", (Object)e.getMessage());
                                    }
                                    throw new TextMiningException(e.getMessage());
                                }
                            }
                        }
                        response.close();
                    }
                    return document2;
                }
                JsonNode jsonNode = objectMapper.readTree(response.getEntity().getContent());
                Document doc = this.convertJSONToDocument(jsonNode);
                doc.setContent(content);
                doc.generateRDF(this.clientConfig.getName());
                document = doc;
                if (response == null) break block27;
                response.close();
            }
            return document;
        }
    }

    @NotNull
    private Document writeError(String content, int statusCode, String message) {
        HashMap<String, Object> errorDocFeatures = new HashMap<String, Object>();
        errorDocFeatures.put("errorCode", String.valueOf(statusCode));
        errorDocFeatures.put("errorMessage", message);
        Document result = new Document();
        result.setContent(content);
        result.setFeatures(errorDocFeatures);
        ++this.currentErrors;
        result.generateRDF(this.clientConfig.getName());
        return result;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    protected boolean isJSONLDClient() {
        for (Header h : this.clientConfig.getHeaders()) {
            if (!h.getName().equals("Accept") || !h.getValue().contains(RDFFormat.JSONLD.getDefaultMIMEType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Document annotateDocument(String text, Resource docIRI, Map<String, String> documentFeatures) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Annotating document content starting with: \"{}...\" with length: {}", (Object)text.substring(0, Math.min(100, text.length())), (Object)text.length());
        }
        return this.getAnnotatedDocument(text, docIRI, documentFeatures);
    }

    @Override
    public URI getEndpoint() {
        return this.clientConfig.getType() == ClientType.SPACY ? this.clientConfig.getServiceLocation().resolve("/ner") : this.clientConfig.getServiceLocation();
    }

    public String getTransformation() {
        if (this.clientConfig.getType() != ClientType.GENERIC) {
            throw new PluginException("Transformation field is supported only for Generic services");
        }
        return this.clientConfig.getTransformation();
    }

    @Override
    public ClientType getClientType() {
        return this.clientConfig.getType();
    }

    @Override
    public IRI getClientIRI() {
        return this.clientIRI;
    }

    @Override
    public void setClientIRI(IRI clientIRI) {
        this.clientIRI = clientIRI;
    }
}

