/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history.collection.factored;

import com.ontotext.graphdb.plugin.history.collection.AbstractHistoryStorage;
import com.ontotext.trree.big.collections.Utils;
import com.ontotext.trree.big.collections.storage.ArrayPools;
import java.util.Arrays;

public class FactoredHistoryStorage
extends AbstractHistoryStorage {
    private int[] dateTimeElement;

    FactoredHistoryStorage(ArrayPools factory, int size, int entityIdSize) {
        super(factory, size, entityIdSize);
        this.dateTimeElement = factory == null ? new int[size] : factory.allocateIntArray(size);
    }

    public FactoredHistoryStorage clone(ArrayPools factory, boolean copyData) {
        FactoredHistoryStorage cloned = new FactoredHistoryStorage(factory, this.size(), this.getEntityIdSize());
        if (copyData) {
            System.arraycopy(this.dateTimeElement, 0, cloned.dateTimeElement, 0, this.dateTimeElement.length);
            this.copyInherited(cloned);
        }
        return cloned;
    }

    @Override
    public void resizeDateTime(int newSize) {
        this.dateTimeElement = Arrays.copyOf(this.dateTimeElement, newSize);
    }

    @Override
    protected int dateTimeByteSize() {
        return 4;
    }

    @Override
    protected int readDateTime(byte[] bytes, int offset, int size) {
        int startOffset = offset;
        int idx = 0;
        while (idx < size) {
            this.dateTimeElement[idx] = Utils.restoreInt((byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        return offset - startOffset;
    }

    @Override
    protected int readDateTime(int index, byte[] bytes, int offset) {
        this.dateTimeElement[index] = Utils.restoreInt((byte[])bytes, (int)offset);
        return 4;
    }

    @Override
    protected int writeDateTime(byte[] bytes, int offset, int size) {
        int startOffset = offset;
        int idx = 0;
        while (idx < size) {
            Utils.serializeInt((int)this.dateTimeElement[idx], (byte[])bytes, (int)offset);
            ++idx;
            offset += 4;
        }
        return offset - startOffset;
    }

    @Override
    protected int writeDateTime(int index, byte[] bytes, int offset) {
        Utils.serializeInt((int)this.dateTimeElement[index], (byte[])bytes, (int)offset);
        return 4;
    }

    @Override
    protected void setDateTime(int index, long[] tuple, int tupleIndex) {
        this.dateTimeElement[index] = (int)tuple[tupleIndex];
    }

    @Override
    protected void getDateTime(int index, long[] tuple, int tupleIndex) {
        tuple[tupleIndex] = (long)this.dateTimeElement[index] & 0xFFFFFFFFL;
    }

    @Override
    protected long getDateTime(int index) {
        return (long)this.dateTimeElement[index] & 0xFFFFFFFFL;
    }

    @Override
    protected void setDateTime(int index, long value) {
        this.dateTimeElement[index] = (int)value;
    }

    @Override
    protected int compareDateTime(int index, long[] tuple, int tupleIndex) {
        return Utils.compare((long)tuple[tupleIndex], (long)((long)this.dateTimeElement[index] & 0xFFFFFFFFL));
    }

    @Override
    protected void cleanDateTime(ArrayPools factory) {
        if (factory != null && this.dateTimeElement != null) {
            factory.release(this.dateTimeElement);
            this.dateTimeElement = null;
        }
    }
}

