/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.ServerErrorException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Value;

public class StatementFilterPattern
implements Comparable {
    FilterPattern subjectFilter;
    FilterPattern predicateFilter;
    FilterPattern objectFilter;
    FilterPattern contextFilter;
    public static final String WILDCARD_FILTER_PATTERN = "*";

    public StatementFilterPattern(String pattern) {
        String[] patterns = pattern.trim().split("\\s+");
        if (patterns.length != 4) {
            throw new ClientErrorException("Statement pattern must have four positions: " + pattern);
        }
        this.subjectFilter = new FilterPattern(patterns[0]);
        this.predicateFilter = new FilterPattern(patterns[1]);
        this.objectFilter = new FilterPattern(patterns[2]);
        this.contextFilter = new FilterPattern(patterns[3]);
    }

    public int getMatchWeight() {
        return this.getMatchWeightOnPosition(this.subjectFilter) + this.getMatchWeightOnPosition(this.predicateFilter) + this.getMatchWeightOnPosition(this.objectFilter) + this.getMatchWeightOnPosition(this.contextFilter);
    }

    private int getMatchWeightOnPosition(FilterPattern filterPattern) {
        if (filterPattern.isWildcardPattern) {
            return 0;
        }
        if (this.isTypePattern(filterPattern.pattern)) {
            return 1;
        }
        if (filterPattern.pattern.endsWith(WILDCARD_FILTER_PATTERN)) {
            return 3;
        }
        return 4;
    }

    public int compareTo(Object o) {
        if (!(o instanceof StatementFilterPattern)) {
            return -1;
        }
        int compared = Integer.compare(this.getMatchWeight(), ((StatementFilterPattern)o).getMatchWeight());
        if (compared == 0) {
            if (this.toString().equals(o.toString())) {
                return 0;
            }
            return 1;
        }
        return compared;
    }

    public boolean accepts(long subject, long predicate, long object, long context, boolean isExplicit, PluginConnection pluginConnection) {
        return this.acceptsPosition(this.subjectFilter, subject, pluginConnection) && this.acceptsPosition(this.predicateFilter, predicate, pluginConnection) && this.acceptsPosition(this.objectFilter, object, pluginConnection) && this.acceptsPosition(context, pluginConnection, isExplicit);
    }

    private boolean isTypePattern(String pattern) {
        return StringUtils.equalsIgnoreCase((CharSequence)Entities.Type.LITERAL.name(), (CharSequence)pattern) || StringUtils.equalsIgnoreCase((CharSequence)Entities.Type.URI.name(), (CharSequence)pattern) || StringUtils.equalsIgnoreCase((CharSequence)Entities.Type.BNODE.name(), (CharSequence)pattern) || StringUtils.equalsIgnoreCase((CharSequence)Entities.Type.TRIPLE.name(), (CharSequence)pattern);
    }

    private boolean acceptsPosition(long context, PluginConnection pluginConnection, boolean isExplicit) {
        if (this.contextFilter.isWildcardPattern) {
            return true;
        }
        if (isExplicit && this.contextFilter.pattern.equals(SystemGraphs.EXPLICIT_GRAPH.toString())) {
            return true;
        }
        if (!isExplicit) {
            context = SystemGraphs.IMPLICIT_GRAPH.getId();
        }
        if (context == 0L) {
            return this.contextFilter.isNegation != (this.contextFilter.pattern.equals(SystemGraphs.RDF4J_NIL.toString()) || this.contextFilter.pattern.equals(SystemGraphs.SESAME_NIL.toString()));
        }
        return this.contextFilter.isNegation != this.doesValueMatchPattern(this.contextFilter.pattern, context, pluginConnection);
    }

    private boolean acceptsPosition(FilterPattern filterPattern, long entity, PluginConnection pluginConnection) {
        if (filterPattern.isWildcardPattern) {
            return true;
        }
        if (this.isTypePattern(filterPattern.pattern)) {
            Entities.Type type = pluginConnection.getEntities().getType(entity);
            if (type == null) {
                throw new ServerErrorException(String.format("No entity type for id %d in pluginConnection", entity));
            }
            return filterPattern.isNegation != StringUtils.equalsIgnoreCase((CharSequence)type.name(), (CharSequence)filterPattern.pattern);
        }
        return filterPattern.isNegation != this.doesValueMatchPattern(filterPattern.pattern, entity, pluginConnection);
    }

    private boolean doesValueMatchPattern(String pattern, long entity, PluginConnection pluginConnection) {
        Value entityValue = pluginConnection.getEntities().get(entity);
        if (entityValue == null) {
            throw new ServerErrorException(String.format("No entity with id %d in pluginConnection", entity));
        }
        String entityString = entityValue.stringValue();
        if (pattern.contains(WILDCARD_FILTER_PATTERN)) {
            return entityString.startsWith(pattern.substring(0, pattern.indexOf(WILDCARD_FILTER_PATTERN)));
        }
        return entityString.equals(pattern);
    }

    public String toString() {
        Object subjectPattern = this.subjectFilter.isNegation ? "!" + this.subjectFilter.pattern : this.subjectFilter.pattern;
        Object predicatePattern = this.predicateFilter.isNegation ? "!" + this.predicateFilter.pattern : this.predicateFilter.pattern;
        Object objectPattern = this.objectFilter.isNegation ? "!" + this.objectFilter.pattern : this.objectFilter.pattern;
        Object contextPattern = this.contextFilter.isNegation ? "!" + this.contextFilter.pattern : this.contextFilter.pattern;
        return (String)subjectPattern + " " + (String)predicatePattern + " " + (String)objectPattern + " " + (String)contextPattern;
    }

    private static class FilterPattern {
        String pattern;
        boolean isWildcardPattern;
        boolean isNegation;

        FilterPattern(String pattern) {
            if (pattern.equals("!")) {
                throw new PluginException("Negation cannot be used by itself.");
            }
            this.isNegation = pattern.charAt(0) == '!';
            this.pattern = this.isNegation ? pattern.substring(1) : pattern;
            this.isWildcardPattern = StatementFilterPattern.WILDCARD_FILTER_PATTERN.equals(this.pattern);
            if (this.isNegation && this.isWildcardPattern) {
                throw new PluginException("Wildcard and negation cannot be used together.");
            }
        }
    }
}

