/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.trree.big.collections.ModifiableIterator;
import com.ontotext.trree.big.collections.StatementCollection;
import com.ontotext.trree.entitypool.EntityPoolConnection;
import com.ontotext.trree.transactions.JournalBasedTransactionUnit;
import java.io.File;

public class IdTimestampCollection
extends StatementCollection {
    public IdTimestampCollection(File file) {
        super(file, "psoc", 1000, 32);
    }

    public IdTimestampConnection getConnection() {
        return new IdTimestampConnection(this);
    }

    public static class IdTimestampConnection
    extends StatementCollection.StatementConnection {
        private EntityPoolConnection entities;

        public IdTimestampConnection(IdTimestampCollection statementCollection) {
            super((StatementCollection)statementCollection);
            this.doOnBegin(() -> ((JournalBasedTransactionUnit)this.getTransactionUnit()).addOnCommitAfterHook(() -> {
                if (this.entities != null) {
                    this.entities.commitComplete();
                }
            }));
        }

        public boolean setTimestamp(long id, long timestamp) {
            if (this.hasTimestamp(id)) {
                return false;
            }
            long p = id;
            long s = this.timestampToS(timestamp);
            long o = this.timestampToO(timestamp);
            long c = 0L;
            this.add(s, p, o, c, 0);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getTimestamp(long id) {
            try (ModifiableIterator iter = this.get(new long[]{id, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, 0L, id, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, 0L});){
                if (iter.hasNext()) {
                    long[] tuple = iter.tuple();
                    long s = tuple[0];
                    long o = tuple[1];
                    long l = this.soToTimestamp(s, o);
                    return l;
                }
                long l = Long.MIN_VALUE;
                return l;
            }
        }

        public void setEntities(EntityPoolConnection entities) {
            this.entities = entities;
        }

        private boolean hasTimestamp(long id) {
            return this.getTimestamp(id) != Long.MIN_VALUE;
        }

        private long timestampToS(long timestamp) {
            return timestamp >> 32;
        }

        private long timestampToO(long timestamp) {
            return timestamp & 0xFFFFFFFFL;
        }

        private long soToTimestamp(long s, long o) {
            return s << 32 | o;
        }
    }
}

