/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.graphdb.plugin.history.History;
import com.ontotext.graphdb.plugin.history.HistoryConnection;
import com.ontotext.graphdb.plugin.history.HistoryElement;
import com.ontotext.graphdb.plugin.history.HistoryIterator;
import com.ontotext.graphdb.plugin.history.HistoryParameters;
import com.ontotext.graphdb.plugin.history.HistoryPlugin;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.StatementIterator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class HistoryRequestContext
implements RequestContext {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMddHHmmssSSS");
    Map<Long, HistoryElement> historyList = new HashMap<Long, HistoryElement>();
    long timestamp = 0L;
    private Request request;
    private final History history;
    private HistoryConnection historyConnection;

    HistoryRequestContext(Request request, History history) {
        this.request = request;
        this.history = history;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public HistoryConnection getHistoryConnection() {
        if (this.historyConnection == null || !this.historyConnection.isOpen()) {
            this.historyConnection = this.history.getConnection();
        }
        return this.historyConnection;
    }

    StatementIterator createHistoryIterator(PluginConnection pluginConnection, long subject) {
        if (this.historyList.containsKey(subject)) {
            return StatementIterator.TRUE();
        }
        long timestamp = Long.MIN_VALUE;
        if (subject != 0L && (timestamp = this.timestampFromId(pluginConnection.getEntities().get(subject))) == Long.MIN_VALUE) {
            return StatementIterator.EMPTY;
        }
        HistoryParameters historyParameters = new HistoryParameters(subject);
        if (timestamp != Long.MIN_VALUE) {
            historyParameters.fromTimeStamp = timestamp;
            historyParameters.toTimeStamp = timestamp;
        }
        return new HistoryIterator(pluginConnection, this, historyParameters);
    }

    StatementIterator createHistoryIterator(PluginConnection pluginConnection, HistoryParameters historyParameters) {
        return new HistoryIterator(pluginConnection, this, historyParameters);
    }

    Literal getUsername(long timestamp) {
        Literal username = this.getHistoryConnection().getUsername(timestamp);
        if (username == null) {
            username = HistoryPlugin.UNKNOWN_USERNAME;
        }
        return username;
    }

    IRI getTransactionId(long timestamp) {
        IRI txId = this.getHistoryConnection().getCustomTxId(timestamp);
        if (txId == null) {
            String tx = DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.UTC));
            return SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/" + tx);
        }
        return txId;
    }

    long timestampFromId(Value transactionId) {
        String id = transactionId.stringValue();
        if (id.startsWith("http://www.ontotext.com/at/")) {
            String timestampString = id.substring("http://www.ontotext.com/at/".length());
            try {
                return LocalDateTime.from(DATE_TIME_FORMATTER.parse(timestampString)).toInstant(ZoneOffset.UTC).toEpochMilli();
            }
            catch (DateTimeParseException e) {
                throw new ClientErrorException("Cannot parse the supplied transaction ID: " + id, (Throwable)e);
            }
        }
        return this.getHistoryConnection().getTimestampFromCustomTxId(transactionId);
    }

    public void close() {
        if (this.historyConnection != null) {
            this.historyConnection.close();
        }
    }
}

