/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.google.common.base.Objects;
import com.ontotext.graphdb.plugin.history.CollectionHistory;
import com.ontotext.graphdb.plugin.history.HistoryConnection;
import com.ontotext.graphdb.plugin.history.HistoryElement;
import com.ontotext.graphdb.plugin.history.HistoryPlugin;
import com.ontotext.graphdb.plugin.history.IdTimestampCollection;
import com.ontotext.graphdb.plugin.history.collection.CloseableIterator;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionConnection;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionException;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionIterator;
import com.ontotext.graphdb.plugin.history.collection.nonfactored.TxDetailsHistoryCollectionConnection;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.entitypool.EntityPoolConnection;
import com.ontotext.trree.entitypool.EntityPoolConnectionException;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.transactions.TransactionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHistoryConnection
implements HistoryConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionHistoryConnection.class);
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final HistoryCollectionConnection connection;
    private final TxDetailsHistoryCollectionConnection detailsHistoryConn;
    private final IdTimestampCollection.IdTimestampConnection customTxIdToTimestampConn;
    private final EntityPoolConnection txIdUsernameEntityPoolConn;
    private long txTime;
    private long usernameEntityId;
    private long customTxEntityId;
    private boolean modified;
    private final Map<StatementsKey, SortedSet<HistoryElement>> cache;

    public CollectionHistoryConnection(CollectionHistory collectionHistory) {
        this.connection = collectionHistory.collection.getConnection();
        this.detailsHistoryConn = collectionHistory.detailsHistoryColl.getConnection();
        this.customTxIdToTimestampConn = collectionHistory.customTxIdToTimestampColl.getConnection();
        this.txIdUsernameEntityPoolConn = collectionHistory.txIdUsernameEntityPool.getConnection();
        this.customTxIdToTimestampConn.setEntities(this.txIdUsernameEntityPoolConn);
        this.cache = new HashMap<StatementsKey, SortedSet<HistoryElement>>();
    }

    @Override
    public long begin() {
        this.txTime = System.currentTimeMillis();
        try {
            this.connection.begin();
            this.detailsHistoryConn.begin();
            this.txIdUsernameEntityPoolConn.beginExclusive();
            this.customTxIdToTimestampConn.beginTransaction();
        }
        catch (HistoryCollectionException | TransactionException e) {
            throw new PluginException("Unable to start history transaction", e);
        }
        return this.txTime;
    }

    @Override
    public void precommit() {
        try {
            this.connection.commitStageOne();
            this.detailsHistoryConn.commitStageOne();
            this.txIdUsernameEntityPoolConn.precommit();
            this.customTxIdToTimestampConn.precommit();
        }
        catch (HistoryCollectionException e) {
            try {
                throw new PluginException("Unable to precommit history transaction", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.rollback();
                throw throwable;
            }
        }
    }

    @Override
    public void commit() {
        try {
            this.connection.commitStageTwo();
            this.detailsHistoryConn.commitStageTwo();
            this.txIdUsernameEntityPoolConn.commit();
            this.customTxIdToTimestampConn.commit();
        }
        catch (HistoryCollectionException | TransactionException e) {
            throw new PluginException("Unable to commit history transaction", e);
        }
    }

    @Override
    public void rollback() {
        this.connection.rollback();
        this.detailsHistoryConn.rollback();
        try {
            this.txIdUsernameEntityPoolConn.rollback();
        }
        catch (EntityPoolConnectionException e) {
            LOGGER.warn("Could not rollback transaction", (Throwable)e);
        }
        try {
            this.customTxIdToTimestampConn.rollback();
        }
        catch (TransactionException e) {
            LOGGER.warn("Could not rollback transaction", (Throwable)e);
        }
    }

    @Override
    public void put(long subject, long predicate, long object, long context, boolean isAdded, boolean isExplicit) {
        if (context < 0L) {
            context = 0L;
        }
        this.putInternal(this.txTime, subject, predicate, object, context, isAdded, isExplicit, this.usernameEntityId, this.customTxEntityId);
    }

    @Override
    public void putFrom(HistoryCollectionIterator iterator, HistoryConnection iteratorConn) {
        assert (this.customTxEntityId == 0L);
        assert (this.usernameEntityId == 0L);
        long resolvedUsernameId = this.getOrCreateEntity((Value)iteratorConn.getUsername(iterator.dateTime));
        IRI customTxId = iteratorConn.getCustomTxId(iterator.dateTime);
        long resolvedCustomTxId = this.getOrCreateEntity((Value)customTxId);
        this.putInternal(iterator.dateTime, iterator.subject, iterator.predicate, iterator.object, iterator.context, iterator.isAdded, iterator.isExplicit, resolvedUsernameId, resolvedCustomTxId);
        if (customTxId != null) {
            this.customTxIdToTimestampConn.setTimestamp(this.getOrCreateEntity((Value)customTxId), iterator.dateTime);
        }
    }

    private void putInternal(long datetime, long subject, long predicate, long object, long context, boolean isAdded, boolean isExplicit, long usernameEntityId, long customTxEntityId) {
        int status = (isAdded ? 1 : 0) | (isExplicit ? 2 : 0);
        this.connection.add(datetime, subject, predicate, object, context, status);
        this.detailsHistoryConn.add(datetime, usernameEntityId, customTxEntityId);
        this.modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementIterator getStatements(long dateTime, long rsubject, long rpredicate, long robject, long rcontext, Supplier<StatementIterator> engineIteratorSupplier, PluginConnection pluginConnection) {
        assert (rsubject > 0L || robject > 0L) : "At least the subject must be explicit";
        StatementsKey statementsKey = new StatementsKey(dateTime, rsubject, rpredicate, robject, rcontext);
        SortedSet<HistoryElement> elementsAtPoint = this.cache.get(statementsKey);
        if (elementsAtPoint == null) {
            elementsAtPoint = new TreeSet<HistoryElement>();
            try (StatementIterator engineIterator = engineIteratorSupplier.get();){
                while (engineIterator.next()) {
                    HistoryElement e = this.historyElementForStatements(engineIterator.subject, engineIterator.predicate, engineIterator.object, engineIterator.context > 0L ? engineIterator.context : 0L, engineIterator.isExplicit());
                    elementsAtPoint.add(e);
                }
            }
            try (HistoryCollectionIterator itr = this.getHistoryCollectionIterator(dateTime, Long.MAX_VALUE, rsubject, rpredicate, robject, rcontext);){
                while (itr.next()) {
                    if (!this.isIteratorElementMatch(rsubject, rpredicate, robject, rcontext, itr)) continue;
                    HistoryElement ne = this.historyElementForStatements(itr.subject, itr.predicate, itr.object, itr.context, itr.isExplicit);
                    if (itr.isAdded) {
                        elementsAtPoint.remove(ne);
                        continue;
                    }
                    elementsAtPoint.add(ne);
                }
            }
            this.cache.put(statementsKey, elementsAtPoint);
        }
        return this.toEngineIterator(elementsAtPoint);
    }

    private HistoryElement historyElementForStatements(long subject, long predicate, long object, long context, boolean isExplicit) {
        return new HistoryElement(0L, subject, predicate, object, context, true, isExplicit);
    }

    @Override
    public HistoryCollectionIterator getHistoryCollectionIterator(long minDateTime, long maxDateTime, long rsubject, long rpredicate, long robject, long rcontext) {
        if (maxDateTime == 0L) {
            maxDateTime = Long.MAX_VALUE;
        }
        long minSubject = rsubject;
        long maxSubject = rsubject;
        if (rsubject == 0L) {
            maxSubject = Long.MAX_VALUE;
        }
        long minPredicate = rpredicate;
        long maxPredicate = rpredicate;
        if (rpredicate == 0L) {
            maxPredicate = Long.MAX_VALUE;
        }
        long minObject = robject;
        long maxObject = robject;
        if (robject == 0L) {
            maxObject = Long.MAX_VALUE;
        }
        long minContext = rcontext;
        long maxContext = rcontext;
        if (rcontext == 0L) {
            maxContext = Long.MAX_VALUE;
        }
        return this.connection.get(maxDateTime, minSubject, minPredicate, minObject, minContext, minDateTime, maxSubject, maxPredicate, maxObject, maxContext);
    }

    private boolean isIteratorElementMatch(long rsubject, long rpredicate, long robject, long rcontext, HistoryCollectionIterator he) {
        if (rcontext == (long)SystemGraphs.EXPLICIT_GRAPH.getId() && !he.isExplicit) {
            return false;
        }
        if (rcontext == (long)SystemGraphs.IMPLICIT_GRAPH.getId() && he.isExplicit) {
            return false;
        }
        return !(rsubject != 0L && rsubject != he.subject || rpredicate != 0L && rpredicate != he.predicate || robject != 0L && robject != he.object || rcontext != 0L && rcontext != (long)SystemGraphs.EXPLICIT_GRAPH.getId() && rcontext != (long)SystemGraphs.IMPLICIT_GRAPH.getId() && rcontext != he.context);
    }

    private StatementIterator toEngineIterator(final SortedSet<HistoryElement> elementsAtPoint) {
        return new StatementIterator(){
            final Iterator<HistoryElement> itty;
            {
                this.itty = elementsAtPoint.iterator();
            }

            public boolean next() {
                if (this.itty.hasNext()) {
                    HistoryElement he = this.itty.next();
                    this.subject = he.subject;
                    this.predicate = he.predicate;
                    this.object = he.object;
                    this.context = he.context != 0L ? he.context : (he.isExplicit ? HistoryPlugin.EXPLICIT_GRAPH_ID : HistoryPlugin.IMPLICIT_GRAPH_ID);
                    return true;
                }
                return false;
            }

            public void close() {
            }
        };
    }

    @Override
    public CloseableIterator<HistoryElement> getHistoryElementsIterator(long minDateTime, long maxDateTime, final long rsubject, final long rpredicate, final long robject, final long rcontext) {
        final HistoryCollectionIterator itr = this.getHistoryCollectionIterator(minDateTime, maxDateTime, rsubject, rpredicate, robject, rcontext);
        return new CloseableIterator<HistoryElement>(){
            boolean hasNext = this.hasNextMatchingElement();

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public HistoryElement next() {
                try {
                    if (!this.hasNext) {
                        throw new IllegalStateException("No more elements");
                    }
                    HistoryElement historyElement = itr.getHistoryElement();
                    return historyElement;
                }
                finally {
                    this.hasNext = this.hasNextMatchingElement();
                }
            }

            private boolean hasNextMatchingElement() {
                boolean hasNextL = itr.next();
                while (hasNextL) {
                    if (CollectionHistoryConnection.this.isIteratorElementMatch(rsubject, rpredicate, robject, rcontext, itr)) {
                        return true;
                    }
                    hasNextL = itr.next();
                }
                return false;
            }

            @Override
            public void close() {
                itr.close();
            }
        };
    }

    @Override
    public CloseableIterator<HistoryElement> getHistoryElementsIterator() {
        return this.getHistoryElementsIterator(0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.detailsHistoryConn != null) {
            this.detailsHistoryConn.close();
        }
        if (this.customTxIdToTimestampConn != null) {
            this.customTxIdToTimestampConn.close();
        }
        if (this.txIdUsernameEntityPoolConn != null) {
            this.txIdUsernameEntityPoolConn.close();
        }
    }

    @Override
    public boolean isOpen() {
        if (this.connection != null) {
            return this.connection.isOpen();
        }
        return false;
    }

    @Override
    public long getTimestampFromCustomTxId(Value value) {
        return this.customTxIdToTimestampConn.getTimestamp(this.getEntity(value));
    }

    @Override
    public void setUsername(String username) {
        this.usernameEntityId = this.getOrCreateEntity((Value)(StringUtils.isNotEmpty((CharSequence)username) ? VF.createLiteral(username) : null));
    }

    @Override
    public void setCustomTxId(Value value) {
        if (!value.isIRI()) {
            throw new PluginException("The history transaction ID should be an IRI");
        }
        if (value.stringValue().startsWith("http://www.ontotext.com/at/")) {
            throw new PluginException("History transaction ID should not start with the \"http://www.ontotext.com/at/\" prefix");
        }
        if (this.modified) {
            throw new PluginException("History transaction ID must be set before any statements are written into history");
        }
        if (this.customTxEntityId == 0L) {
            this.customTxEntityId = this.getOrCreateEntity(value);
            if (!this.customTxIdToTimestampConn.setTimestamp(this.customTxEntityId, this.txTime)) {
                throw new PluginException("History transaction ID already used: " + value.stringValue());
            }
        } else if (this.getEntity(value) != this.customTxEntityId) {
            throw new PluginException("History transaction ID already set for this transaction");
        }
    }

    @Override
    public Literal getUsername(long txTime) {
        Value username = this.txIdUsernameEntityPoolConn.getValue(this.detailsHistoryConn.getUsername(txTime));
        if (username != null && !username.isLiteral()) {
            throw new PluginException("History username is not a Literal: " + username);
        }
        return (Literal)username;
    }

    @Override
    public IRI getCustomTxId(long txTime) {
        Value customTxId = this.txIdUsernameEntityPoolConn.getValue(this.detailsHistoryConn.getCustomTxId(txTime));
        if (customTxId != null && !customTxId.isIRI()) {
            throw new PluginException("Custom transaction ID in history is not an IRI: " + customTxId);
        }
        return (IRI)customTxId;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    private Value longToValue(long value) {
        return this.txIdUsernameEntityPoolConn.getValue(value);
    }

    private long getEntity(Value value) {
        long id = 0L;
        if (value != null && (id = this.txIdUsernameEntityPoolConn.getId(value)) < 0L) {
            id = this.txIdUsernameEntityPoolConn.getRealId(id);
        }
        return id;
    }

    private long getOrCreateEntity(Value value) {
        long id = 0L;
        if (value != null) {
            id = this.txIdUsernameEntityPoolConn.getId(value);
            if (id == 0L) {
                id = this.txIdUsernameEntityPoolConn.createId(value);
            }
            if (id < 0L) {
                id = this.txIdUsernameEntityPoolConn.getRealId(id);
            }
        }
        return id;
    }

    private static class StatementsKey {
        long dateTime;
        long subject;
        long predicate;
        long object;
        long context;

        public StatementsKey(long dateTime, long subject, long predicate, long object, long context) {
            this.dateTime = dateTime;
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.dateTime, this.subject, this.predicate, this.object, this.context});
        }

        public boolean equals(Object obj) {
            return obj instanceof StatementsKey && this.dateTime == ((StatementsKey)obj).dateTime && this.subject == ((StatementsKey)obj).subject && this.predicate == ((StatementsKey)obj).predicate && this.object == ((StatementsKey)obj).object && this.context == ((StatementsKey)obj).context;
        }
    }
}

