/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder.validation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.functions.StorePresenceQueryInvoker;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidator;
import com.ontotext.graphql.responder.validation.AsyncMutationActiveValidatorCallback;
import com.ontotext.graphql.responder.validation.MutationValidationException;
import com.ontotext.models.Operation;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.security.Role;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.sparql.ExecutionError;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public interface MutationActiveValidator {
    public OperationResponse validate(UpdateExecution var1, ActiveValidationContext var2);

    public Phase getPhase();

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class AsyncValidationTask
    implements Runnable {
        private final AsyncMutationActiveValidatorCallback asyncCallback;
        private final CountDownLatch waitTask;
        private final Semaphore maxConcurrentTasks;
        private final ActiveValidationContext context;
        private final Consumer<Exception> onAsyncFailure;
        private Future<?> future;
        private Exception failure;

        AsyncValidationTask(AsyncMutationActiveValidatorCallback asyncCallback, CountDownLatch waitTask, Semaphore maxConcurrentTasks, ActiveValidationContext context, Consumer<Exception> onAsyncFailure) {
            this.asyncCallback = asyncCallback;
            this.waitTask = waitTask;
            this.maxConcurrentTasks = maxConcurrentTasks;
            this.context = context;
            this.onAsyncFailure = onAsyncFailure;
        }

        @Override
        public void run() {
            try {
                this.maxConcurrentTasks.acquire();
                try {
                    this.asyncCallback.invokeAsync();
                }
                catch (RuntimeException re) {
                    this.failure = re;
                    this.onAsyncFailure.accept(re);
                }
                finally {
                    this.maxConcurrentTasks.release();
                }
            }
            catch (InterruptedException ie) {
                this.failure = ie;
                Thread.currentThread().interrupt();
            }
            finally {
                this.waitTask.countDown();
            }
        }

        public OperationResponse completeValidation() {
            assert (this.future != null && this.future.isDone()) : "Async validation is not complete!";
            if (this.failure != null) {
                return this.context.handleValidationFailure(this.asyncCallback.getValidator(), this.failure);
            }
            try {
                return this.asyncCallback.completeValidation();
            }
            catch (RuntimeException re) {
                return this.context.handleValidationFailure(this.asyncCallback.getValidator(), re);
            }
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public boolean isDone() {
            return this.future != null && this.future.isDone();
        }

        public void cancel() {
            if (!this.isDone()) {
                this.waitTask.countDown();
                this.future.cancel(true);
            }
        }
    }

    public static class AsyncMutationActiveValidatorProxy
    implements AsyncMutationActiveValidatorCallback {
        private final MutationActiveValidator validator;
        private final UpdateExecution request;
        private final ActiveValidationContext context;

        public AsyncMutationActiveValidatorProxy(MutationActiveValidator validator, UpdateExecution request, ActiveValidationContext context) {
            this.validator = validator;
            this.request = request;
            this.context = context;
        }

        @Override
        public void invokeAsync() {
        }

        @Override
        public OperationResponse completeValidation() {
            return this.validator.validate(this.request, this.context);
        }

        @Override
        public MutationActiveValidator getValidator() {
            return this.validator;
        }
    }

    public static class MutationValidationExecutor {
        private static final AtomicInteger COUNT = new AtomicInteger();
        private final ExecutorService validationExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setPriority(4).setNameFormat("mutation-validator-" + COUNT.incrementAndGet() + "-%d").setDaemon(true).build());

        public void shutdownAsyncProcessing() {
            this.validationExecutor.shutdown();
        }

        public Map<UpdateExecution, OperationResponse> validate(MutationExecutionRequest request, SparqlQueryInvoker invoker, SparqlEndpoint endpoint, Phase phase) {
            ActiveValidationContext context = MutationValidationExecutor.buildContext(request, invoker, endpoint);
            boolean allOperationsAreInvalid = request.getExecutions().stream().map(UpdateExecution::getOperation).noneMatch(Operation::isValid);
            if (allOperationsAreInvalid) {
                return request.getExecutions().stream().map(updateExecution -> Pair.of((Object)updateExecution, (Object)OperationResponse.createFailed())).collect(MutationValidationExecutor.toUpdateResponse());
            }
            if (context.needAsyncValidation(request, phase)) {
                return this.validateAsync(request, phase, context);
            }
            return request.getExecutions().stream().map(updateExecution -> {
                Pair<UpdateExecution, OperationResponse> responsePair = context.callValidators(request, (UpdateExecution)updateExecution, phase);
                if (((OperationResponse)responsePair.getValue()).isValid() && !updateExecution.getOperation().isValid()) {
                    return Pair.of((Object)updateExecution, (Object)OperationResponse.createFailed());
                }
                return responsePair;
            }).collect(MutationValidationExecutor.toUpdateResponse());
        }

        private Map<UpdateExecution, OperationResponse> validateAsync(MutationExecutionRequest request, Phase phase, ActiveValidationContext context) {
            AsyncTaskEvaluator evaluator = new AsyncTaskEvaluator(this.validationExecutor, request, context, phase);
            List<Pair<UpdateExecution, List<AsyncValidationTask>>> tasks = evaluator.evaluate();
            return tasks.stream().map(pair -> {
                OperationResponse operationResponse = ((List)pair.getValue()).stream().map(AsyncValidationTask::completeValidation).reduce(new OperationResponse(), OperationResponse::addAll);
                if (operationResponse.isValid() && !((UpdateExecution)pair.getLeft()).getOperation().isValid()) {
                    return Pair.of((Object)((UpdateExecution)pair.getLeft()), (Object)OperationResponse.createFailed());
                }
                return Pair.of((Object)((UpdateExecution)pair.getLeft()), (Object)operationResponse);
            }).collect(MutationValidationExecutor.toUpdateResponse());
        }

        @NotNull
        private static <K, V> Collector<Pair<K, V>, ?, Map<K, V>> toUpdateResponse() {
            return Collectors.toMap(Pair::getLeft, Pair::getRight, CollectionsUtil.throwIfSame(), LinkedHashMap::new);
        }

        private static ActiveValidationContext buildContext(MutationExecutionRequest request, SparqlQueryInvoker invoker, SparqlEndpoint endpoint) {
            Set<Role> roles = request.getRoles();
            ValidatorOptions options = request.getValidatorOptions();
            SomlSchema schema = request.getSomlSchema();
            return new ActiveValidationContext(endpoint, invoker, roles, options, schema);
        }

        private static class AsyncTaskEvaluator {
            private final ExecutorService executorService;
            private final MutationExecutionRequest request;
            private final ActiveValidationContext context;
            private final Phase phase;
            private AtomicReference<List<Pair<UpdateExecution, List<AsyncValidationTask>>>> tasks = new AtomicReference();

            AsyncTaskEvaluator(ExecutorService executorService, MutationExecutionRequest request, ActiveValidationContext context, Phase phase) {
                this.executorService = executorService;
                this.request = request;
                this.context = context;
                this.phase = phase;
            }

            @NotNull
            private List<Pair<UpdateExecution, List<AsyncValidationTask>>> evaluate() {
                List<Pair<UpdateExecution, List<AsyncMutationActiveValidatorCallback>>> validationsPerUpdate = this.collectAsyncCallbacks();
                int totalAsyncTasks = validationsPerUpdate.stream().mapToInt(pair -> ((List)pair.getValue()).size()).sum();
                CountDownLatch waitLatch = new CountDownLatch(totalAsyncTasks);
                if (totalAsyncTasks == 0) {
                    return validationsPerUpdate.stream().map(CollectionsUtil.foldRight(list -> List.of())).collect(Collectors.toList());
                }
                Semaphore maxConcurrentTasks = this.getMaxConcurrentTasksLimiter();
                Loggers.graphqlLogger().debug("Starting async validation for {} tasks with {} concurrent threads", (Object)waitLatch.getCount(), (Object)maxConcurrentTasks.availablePermits());
                this.tasks.set(validationsPerUpdate.stream().map(CollectionsUtil.foldRight(this.scheduleTasks(waitLatch, maxConcurrentTasks))).collect(Collectors.toList()));
                this.awaitTaskCompletion(waitLatch);
                return this.tasks.get();
            }

            @NotNull
            private List<Pair<UpdateExecution, List<AsyncMutationActiveValidatorCallback>>> collectAsyncCallbacks() {
                return this.request.getExecutions().stream().map(update -> this.context.createAsyncRequests(this.request, (UpdateExecution)update, this.phase)).collect(Collectors.toList());
            }

            @NotNull
            private Function<List<AsyncMutationActiveValidatorCallback>, List<AsyncValidationTask>> scheduleTasks(CountDownLatch waitLatch, Semaphore maxConcurrentTasks) {
                return list -> list.stream().map(this.scheduleAsyncTask(waitLatch, maxConcurrentTasks)).collect(Collectors.toList());
            }

            @NotNull
            private Function<AsyncMutationActiveValidatorCallback, AsyncValidationTask> scheduleAsyncTask(CountDownLatch waitLatch, Semaphore maxConcurrentTasks) {
                return asyncCallback -> {
                    AsyncValidationTask task = new AsyncValidationTask((AsyncMutationActiveValidatorCallback)asyncCallback, waitLatch, maxConcurrentTasks, this.context, this.onAsyncFailure());
                    Future<?> future = this.executorService.submit(SparqlEndpointRequestContext.decorateTask((Runnable)task));
                    task.setFuture(future);
                    return task;
                };
            }

            private void awaitTaskCompletion(CountDownLatch waitLatch) {
                try {
                    long timeoutSeconds = this.context.getValidatorOptions().getAsyncValidationTimeoutSeconds();
                    if (!waitLatch.await(timeoutSeconds, TimeUnit.SECONDS)) {
                        this.stopIncompleteTasks();
                        waitLatch.await();
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.stopIncompleteTasks();
                }
                while (this.tasks.get().stream().flatMap(async -> ((List)async.getValue()).stream()).anyMatch(task -> !task.isDone())) {
                    Thread.onSpinWait();
                }
            }

            @NotNull
            private Semaphore getMaxConcurrentTasksLimiter() {
                return new Semaphore(this.context.getValidatorOptions().getMaxConcurrentValidationsPerRequest());
            }

            private void stopIncompleteTasks() {
                while (this.tasks.get() == null) {
                    Thread.onSpinWait();
                }
                this.tasks.get().stream().flatMap(async -> ((List)async.getValue()).stream()).filter(task -> !task.isDone()).forEach(AsyncValidationTask::cancel);
            }

            @NotNull
            private Consumer<Exception> onAsyncFailure() {
                return failure -> {
                    ValidatorOptions.ValidationFailureMode failureMode = this.context.getValidatorOptions().getValidationFailureMode();
                    if (failureMode != ValidatorOptions.ValidationFailureMode.WARN && failureMode != ValidatorOptions.ValidationFailureMode.IGNORE) {
                        this.stopIncompleteTasks();
                    }
                };
            }
        }
    }

    public static class ActiveValidationContext {
        private final SparqlEndpoint endpoint;
        private final SparqlQueryInvoker sparqlInvoker;
        private final SomlSchema soml;
        private Set<Role> roles;
        private ValidatorOptions validatorOptions;
        private StorePresenceQueryInvoker storeInvoker;
        private Map<String, ObjectData> trackedObjects = new ConcurrentHashMap<String, ObjectData>();

        public ActiveValidationContext(SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker, SomlSchema soml) {
            this(endpoint, sparqlInvoker, Collections.emptySet(), null, soml);
        }

        public ActiveValidationContext(SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker, Set<Role> roles, ValidatorOptions validatorOptions, SomlSchema soml) {
            this.endpoint = endpoint;
            this.sparqlInvoker = sparqlInvoker;
            this.roles = roles;
            this.validatorOptions = Objects.requireNonNullElse(validatorOptions, ValidatorOptions.emptyOptions());
            this.soml = soml;
        }

        Pair<UpdateExecution, OperationResponse> callValidators(MutationExecutionRequest request, UpdateExecution update, Phase phase) {
            return Pair.of((Object)update, (Object)request.getValidators().stream().filter(validator -> validator.getPhase().equals((Object)phase)).filter(this::isValidatorEnabled).map(validator -> this.callValidator((MutationActiveValidator)validator, update)).reduce(new OperationResponse(), OperationResponse::addAll));
        }

        Pair<UpdateExecution, List<AsyncMutationActiveValidatorCallback>> createAsyncRequests(MutationExecutionRequest request, UpdateExecution update, Phase phase) {
            return Pair.of((Object)update, request.getValidators().stream().filter(validator -> validator.getPhase().equals((Object)phase)).filter(this::isValidatorEnabled).map(validator -> this.asAsyncRequest((MutationActiveValidator)validator, update)).filter(Objects::nonNull).collect(Collectors.toList()));
        }

        private AsyncMutationActiveValidatorCallback asAsyncRequest(MutationActiveValidator validator, UpdateExecution update) {
            if (validator instanceof AsyncMutationActiveValidator) {
                return ((AsyncMutationActiveValidator)validator).createAsyncValidator(update, this);
            }
            return new AsyncMutationActiveValidatorProxy(validator, update, this);
        }

        private OperationResponse callValidator(MutationActiveValidator validator, UpdateExecution update) {
            try {
                return validator.validate(update, this);
            }
            catch (RuntimeException re) {
                return this.handleValidationFailure(validator, re);
            }
        }

        @NotNull
        private OperationResponse handleValidationFailure(MutationActiveValidator validator, Exception re) {
            ValidatorOptions.ValidationFailureMode failureMode = this.validatorOptions.getValidationFailureMode();
            if (failureMode == ValidatorOptions.ValidationFailureMode.DEFAULT || failureMode == ValidatorOptions.ValidationFailureMode.FAIL) {
                throw new MutationValidationException("Mutation validations failed with: " + re.getMessage(), re);
            }
            if (Loggers.graphqlLogger().isDebugEnabled()) {
                Loggers.graphqlLogger().debug("Async validation failed", (Throwable)re);
            }
            OperationResponse response = new OperationResponse();
            String message = validator.getName() + " failed with: " + re.getMessage();
            if (failureMode == ValidatorOptions.ValidationFailureMode.ERROR) {
                response.addErrorMessage((Serializable)new ExecutionError(message, (Throwable)re));
            } else if (failureMode == ValidatorOptions.ValidationFailureMode.WARN) {
                response.addWarningMessage((Serializable)new ExecutionError(message, (Throwable)re));
            } else {
                Loggers.graphqlLogger().warn(message, (Throwable)re);
            }
            return response;
        }

        public SparqlEndpoint getEndpoint() {
            return this.endpoint;
        }

        public SparqlQueryInvoker getSparqlInvoker() {
            return this.sparqlInvoker;
        }

        public ActiveValidationContext setRoles(Set<Role> roles) {
            this.roles = roles;
            return this;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public ActiveValidationContext setValidatorOptions(ValidatorOptions validatorOptions) {
            this.validatorOptions = validatorOptions;
            return this;
        }

        public ValidatorOptions getValidatorOptions() {
            return this.validatorOptions;
        }

        public boolean isValidatorEnabled(MutationActiveValidator validator) {
            return this.validatorOptions == null || this.validatorOptions.isValidatorEnabled(validator.getName());
        }

        public boolean isValidatorEnabled(Class<?> validator) {
            return this.validatorOptions == null || this.validatorOptions.isValidatorEnabled(validator.getSimpleName());
        }

        public StorePresenceQueryInvoker getStoreInvoker() {
            if (this.storeInvoker == null) {
                this.storeInvoker = new StorePresenceQueryInvoker((Endpoint)this.endpoint, this.sparqlInvoker);
            }
            return this.storeInvoker;
        }

        public SomlSchema getSoml() {
            return this.soml;
        }

        public Map<String, ObjectData> getTrackedObjects() {
            return this.trackedObjects;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean needAsyncValidation(MutationExecutionRequest request, Phase phase) {
            if (!this.getValidatorOptions().isAsyncValidationEnabled()) return false;
            if (!request.getValidators().stream().filter(validator -> validator.getPhase().equals((Object)phase)).filter(this::isValidatorEnabled).anyMatch(AsyncMutationActiveValidator.class::isInstance)) return false;
            return true;
        }

        public static class ObjectData {
            private final String id;
            private String shapeId;

            private ObjectData(String id) {
                this.id = id;
            }

            public static ObjectData create(String id) {
                return new ObjectData(id);
            }

            public String getId() {
                return this.id;
            }

            public ObjectData setShapeId(String shapeId) {
                this.shapeId = shapeId;
                return this;
            }

            public String getShapeId() {
                return this.shapeId;
            }
        }
    }

    public static enum Phase {
        PRE_TX,
        PRE_COMMIT,
        POST_COMMIT;

    }
}

