/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;
import com.ontotext.models.security.Role;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.sparql.ConnectionReusePolicies;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.TransactionPolicies;
import com.ontotext.sparql.TransactionPolicy;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UpdateExecution
implements EndpointExecution {
    private final SomlSchema somlSchema;
    private final ShaclSchema shaclSchema;
    private final OperationBuilderOptions options;
    private final String requestId;
    private final Endpoint endpoint;
    private String txId;
    private List<UpdateStep> updateSteps = new LinkedList<UpdateStep>();
    private TransactionPolicy transactionPolicy = TransactionPolicies.getSingleTxWithoutSelects();
    private ConnectionReusePolicy connectionReusePolicy = ConnectionReusePolicies.serializedSingleConnection();
    private QueryExecution query;
    private Mutation operation;
    private MutationExecutionRequest request;
    private Set<Role> roles;
    private ValidatorOptions validatorOptions;
    private boolean silent = false;
    private int index;

    public UpdateExecution(String requestId, Endpoint endpoint, SomlSchema soml, ShaclSchema shacl, OperationBuilderOptions options) {
        this.requestId = requestId;
        this.endpoint = endpoint;
        this.somlSchema = soml;
        this.shaclSchema = shacl;
        this.options = options;
    }

    public QueryExecutionRequest toQueryRequest() {
        QueryExecutionRequest executionContext = new QueryExecutionRequest(this.somlSchema);
        if (this.query != null) {
            this.query.setConnectionReusePolicy(ConnectionReusePolicies.toNoneCloseableConnectionPolicy((ConnectionReusePolicy)this.connectionReusePolicy));
            executionContext.addExecution(this.query);
            executionContext.setSilent(this.isSilent());
        }
        return executionContext;
    }

    public List<UpdateStep> getUpdateSteps() {
        return this.updateSteps;
    }

    public void addUpdateStepAt(int idx, UpdateStep updateStep) {
        updateStep.setSilent(this.silent);
        this.updateSteps.add(idx, updateStep);
    }

    public void addUpdateStep(UpdateStep updateStep) {
        updateStep.setSilent(this.silent);
        this.updateSteps.add(updateStep);
    }

    public TransactionPolicy getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(TransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
    }

    @Override
    public ConnectionReusePolicy getConnectionReusePolicy() {
        return this.connectionReusePolicy;
    }

    public void setConnectionReusePolicy(ConnectionReusePolicy connectionReusePolicy) {
        this.connectionReusePolicy = connectionReusePolicy;
    }

    public QueryExecution getQuery() {
        return this.query;
    }

    public void setQuery(QueryExecution query) {
        this.query = query;
        if (query != null) {
            this.query.setSilent(this.silent);
        }
    }

    public void setQuery(Query graphQuery, List<QueryStep> remoteQueries) {
        this.setQuery(new QueryExecution(this.requestId, Objects.requireNonNull(graphQuery, "Graph query is required"), Objects.requireNonNull(remoteQueries, "Remote query is required"), Objects.requireNonNull(this.endpoint, "Endpoint is required")));
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    @NotNull
    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = Objects.requireNonNull(txId, "Transaction id is required");
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Query getGraphQuery() {
        return this.query.getGraphQuery();
    }

    public UpdateExecution setOperation(Mutation operation) {
        this.operation = operation;
        return this;
    }

    public Mutation getOperation() {
        return this.operation;
    }

    @Override
    public SomlSchema getSchema() {
        return this.somlSchema;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public ValidatorOptions getValidatorOptions() {
        return this.validatorOptions;
    }

    public OperationBuilderOptions getOperationOptions() {
        return this.options;
    }

    public void setValidatorOptions(ValidatorOptions validatorOptions) {
        this.validatorOptions = validatorOptions;
    }

    public ShaclSchema getShaclSchema() {
        return this.shaclSchema;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(boolean silent) {
        this.silent = silent;
        if (this.query != null) {
            this.query.setSilent(silent);
        }
        this.updateSteps.forEach(updateStep -> updateStep.setSilent(silent));
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public boolean needToFetchChanges() {
        return this.operation.requestedChanges() || this.getRequest() != null && this.getRequest().hasPostCommitValidator();
    }

    protected void initialize() {
        Arguments arguments = this.operation.getArguments();
        if (arguments == null) {
            return;
        }
        arguments.getExpandOverOwlSameAs().ifPresent(expandOwlSameAs -> this.updateSteps.forEach(updateStep -> updateStep.setExpandSameAs((Boolean)expandOwlSameAs)));
        arguments.getIncludeInferred().ifPresent(includeInferred -> this.updateSteps.forEach(updateStep -> updateStep.setIncludeInferred((Boolean)includeInferred)));
    }

    public MutationExecutionRequest getRequest() {
        return this.request;
    }

    public void setRequest(MutationExecutionRequest request) {
        this.request = request;
    }
}

