/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.SimpleExecution;
import com.ontotext.graphql.responder.SimpleRequest;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.SparqlRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SimpleEndpointInvoker
implements EndpointInvoker<SparqlEndpoint, SimpleExecution, SimpleRequest, Object> {
    private SparqlQueryInvoker sparqlInvoker;

    public SimpleEndpointInvoker() {
        this(new SparqlQueryInvoker());
    }

    public SimpleEndpointInvoker(SparqlQueryInvoker queryInvoker) {
        this.sparqlInvoker = Objects.requireNonNull(queryInvoker, "Sparql query invoker cannot be null");
    }

    public SimpleEndpointInvoker(SparqlConnectionFactory connectionFactory) {
        this.sparqlInvoker = connectionFactory != null ? new SparqlQueryInvoker(connectionFactory) : new SparqlQueryInvoker();
    }

    @Override
    public List<EndpointExecutionResponse<Object>> invoke(SparqlEndpoint endpoint, SimpleRequest executionContext) {
        List<SimpleExecution> executions = executionContext.getExecutions();
        ArrayList<EndpointExecutionResponse<Object>> responses = new ArrayList<EndpointExecutionResponse<Object>>(executions.size());
        for (SimpleExecution execution : executions) {
            SparqlRequest<String> request = execution.toSparqlRequest();
            ExecutionResponse response = this.sparqlInvoker.invoke(request, endpoint, execution.getConnectionReusePolicy());
            if (response.isSuccessful()) {
                responses.add(EndpointExecutionResponse.of(execution, null, execution.getRequestId()));
                continue;
            }
            responses.add(EndpointExecutionResponse.ofError(execution, null, Collections.singletonList(response.getError().getMessage())));
        }
        return responses;
    }

    @Override
    public Class<SparqlEndpoint> getEndpointType() {
        return SparqlEndpoint.class;
    }

    @Override
    public Class<SimpleRequest> getExecutionRequestType() {
        return SimpleRequest.class;
    }

    @Override
    public void close() {
        this.sparqlInvoker.close();
    }
}

