/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.PostQueryProcessor;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.models.Operation;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.concurrent.ExecutionTree;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.ExecutionError;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.SparqlResponse;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySparqlEndpointInvoker
implements EndpointInvoker<SparqlEndpoint, QueryExecution, QueryExecutionRequest, RdfTree> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PostQueryProcessor.PostQueryProcessorsExecutor postQueryProcessorsExecutor;
    private SparqlQueryInvoker sparqlInvoker;

    public QuerySparqlEndpointInvoker() {
        this(new SparqlQueryInvoker());
    }

    public QuerySparqlEndpointInvoker(SparqlConnectionFactory connectionFactory) {
        this(connectionFactory != null ? new SparqlQueryInvoker(connectionFactory) : new SparqlQueryInvoker());
    }

    public QuerySparqlEndpointInvoker(SparqlQueryInvoker queryInvoker) {
        this.sparqlInvoker = Objects.requireNonNull(queryInvoker, "Sparql query invoker cannot be null");
        this.postQueryProcessorsExecutor = new PostQueryProcessor.PostQueryProcessorsExecutor(this.sparqlInvoker);
    }

    @Override
    public List<EndpointExecutionResponse<RdfTree>> invoke(SparqlEndpoint endpoint, QueryExecutionRequest request) {
        LinkedHashMap<QueryExecution, CompletableFuture<EndpointExecutionResponse<RdfTree>>> transformResponses = new LinkedHashMap<QueryExecution, CompletableFuture<EndpointExecutionResponse<RdfTree>>>(request.getExecutions().size());
        AtomicInteger sharedLimit = new AtomicInteger(endpoint.getMaxTupleResults());
        for (QueryExecution query : request.getExecutions()) {
            CompletionStage<EndpointExecutionResponse<Object>> future = this.isEmptyOrInvalidQuery(query) ? CompletableFuture.completedFuture(this.buildEmptyResponse(query)) : (query.getGraphQuery().getArguments().isFromSparqlGraph() ? CompletableFuture.completedFuture(this.buildGraphqlExplain(query)) : ExecutionTree.newExecutor(this.workFunction(request.getSomlSchema(), endpoint, query.getConnectionReusePolicy(), sharedLimit), this.rdfDataMerger(), this.toResponse(query)).invoke(query.getQuerySteps()).whenComplete(this.closeConnection(query)));
            transformResponses.put(query, (CompletableFuture<EndpointExecutionResponse<RdfTree>>)future);
        }
        Map collectedResults = transformResponses.entrySet().stream().map(entry -> Pair.of((Object)((QueryExecution)entry.getKey()), (Object)((EndpointExecutionResponse)((CompletableFuture)entry.getValue()).join()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue, (v1, v2) -> v2, LinkedHashMap::new));
        collectedResults.forEach(this.postQueryProcessorsExecutor::execute);
        return new ArrayList<EndpointExecutionResponse<RdfTree>>(collectedResults.values());
    }

    private boolean isEmptyOrInvalidQuery(QueryExecution query) {
        return query.getGraphQuery().getSelections().isEmpty() && !query.getGraphQuery().isCountSelection() || !query.getGraphQuery().isValid();
    }

    @NotNull
    private EndpointExecutionResponse<RdfTree> buildEmptyResponse(QueryExecution query) {
        if (!query.getGraphQuery().isValid()) {
            return EndpointExecutionResponse.ofError(query, (Operation)query.getGraphQuery(), Collections.emptyList());
        }
        return EndpointExecutionResponse.of(query, (Operation)query.getGraphQuery(), EntityPoolFactory.defaultPool().emptyTree());
    }

    @NotNull
    private EndpointExecutionResponse<RdfTree> buildGraphqlExplain(QueryExecution query) {
        if (!query.getGraphQuery().isValid()) {
            return EndpointExecutionResponse.ofError(query, (Operation)query.getGraphQuery(), Collections.emptyList());
        }
        RdfTree data = EntityPoolFactory.defaultPool().emptyTree();
        for (QueryStep queryStep : query.getQuerySteps()) {
            data.add("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + query.getGraphQuery().getResponseName(), (Object)SparqlUtil.prettyPrint((String)queryStep.getQuery(null)));
        }
        return EndpointExecutionResponse.of(query, (Operation)query.getGraphQuery(), data);
    }

    private BiConsumer<EndpointExecutionResponse<?>, Throwable> closeConnection(QueryExecution query) {
        return (response, throwable) -> query.getConnectionReusePolicy().close();
    }

    private <D> BiFunction<QueryStep, ExecutionResponse<D>, CompletableFuture<ExecutionResponse<D>>> workFunction(SomlSchema somlSchema, SparqlEndpoint endpoint, ConnectionReusePolicy connectionReusePolicy, AtomicInteger limit) {
        return (queryStep, previousResponse) -> {
            if (previousResponse != null) {
                if (previousResponse.getError() != null) {
                    return this.createFailure(new IllegalArgumentException("The previous execution failed due to: " + previousResponse.getError().getMessage(), previousResponse.getError()));
                }
                if (!(previousResponse instanceof SparqlResponse)) {
                    return this.createFailure(new IllegalArgumentException("The previous execution data should be from a SPARQL select operation. Got: " + previousResponse.getClass().getName()));
                }
            }
            try {
                return this.sparqlInvoker.invokeAsync(QuerySparqlEndpointInvoker.createQueryRequest((SparqlResponse)previousResponse, queryStep, somlSchema, limit), endpoint, connectionReusePolicy);
            }
            catch (RuntimeException re) {
                return this.createFailure(re);
            }
        };
    }

    private <D> CompletableFuture<ExecutionResponse<D>> createFailure(Throwable error) {
        CompletableFuture<Object> failure = CompletableFuture.completedFuture(null);
        failure.obtrudeException(error);
        return failure;
    }

    private BiFunction<RdfTree, Collection<Throwable>, EndpointExecutionResponse<RdfTree>> toResponse(QueryExecution queryExecution) {
        Query graphQuery = queryExecution.getGraphQuery();
        return (rdfData, errors) -> {
            if (errors != null && !errors.isEmpty()) {
                return EndpointExecutionResponse.ofError(queryExecution, (Operation)graphQuery, errors.stream().peek(error -> LOGGER.debug("Error during asynchronous execution: ", error)).map(ExecutionError::new).collect(Collectors.toList()));
            }
            return EndpointExecutionResponse.of(queryExecution, (Operation)graphQuery, rdfData);
        };
    }

    private BinaryOperator<RdfTree> rdfDataMerger() {
        return (current, newData) -> {
            if (current == null) {
                if (newData == null) {
                    return EntityPoolFactory.defaultPool().emptyTree();
                }
                return newData;
            }
            current.merge(newData);
            return current;
        };
    }

    private static SparqlRequest<?> createQueryRequest(SparqlResponse previousData, QueryStep queryStep, SomlSchema somlSchema, AtomicInteger limit) {
        queryStep.prepareForRequestBuilding(previousData, limit);
        return queryStep.toSparqlRequest(somlSchema);
    }

    @Override
    public Class<SparqlEndpoint> getEndpointType() {
        return SparqlEndpoint.class;
    }

    @Override
    public Class<QueryExecutionRequest> getExecutionRequestType() {
        return QueryExecutionRequest.class;
    }

    @Override
    public void close() {
        this.sparqlInvoker.close();
    }
}

