/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequestProcessor;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.plugin.Inject;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelExecutionRequestProcessor<T extends EndpointExecution, R extends ExecutionRequest<T>>
implements ExecutionRequestProcessor,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS = "graphql.forceMultiRepositorySequentialRequests";
    private static final String GDB_FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS = "graphdb.graphql.forceMultiRepositorySequentialRequests";
    private ExecutorService service;
    private Boolean forceMultiRepositorySequentialRequests = Boolean.FALSE;

    @Override
    public <E extends EndpointExecution> List<TransformContext> processRequest(ExecutionRequest<E> execRequest, EndpointInvokerResolver invokerResolver) {
        ExecutionRequest<E> request;
        Set<Map.Entry<Endpoint, List<T>>> uniqueEndpoints;
        ArrayList<TransformContext> transformContexts = new ArrayList<TransformContext>(execRequest.getExecutions().size());
        if (!execRequest.getErrors().isEmpty()) {
            transformContexts.add(new TransformContext(execRequest.getErrors(), 0));
        }
        if (!execRequest.getWarnings().isEmpty()) {
            TransformContext transformContext = new TransformContext();
            transformContext.addWarnings(execRequest.getWarnings());
            transformContexts.add(transformContext);
        }
        if ((uniqueEndpoints = (request = execRequest).groupedByEndpoint()).size() == 1 || this.forceSequentialRequests()) {
            return this.callSequentially(request, uniqueEndpoints, invokerResolver, transformContexts);
        }
        return this.callConcurrently(request, uniqueEndpoints, invokerResolver, transformContexts);
    }

    protected boolean forceSequentialRequests() {
        return this.forceMultiRepositorySequentialRequests;
    }

    protected List<TransformContext> callSequentially(R request, Set<Map.Entry<Endpoint, List<T>>> uniqueEndpoints, EndpointInvokerResolver invokerResolver, List<TransformContext> transformContexts) {
        for (Map.Entry<Endpoint, List<T>> entry : uniqueEndpoints) {
            Endpoint endpoint = entry.getKey();
            List<T> queriesList = entry.getValue();
            try {
                for (Callable<List<TransformContext>> callable : this.createEndpointRequest(endpoint, queriesList, request, invokerResolver)) {
                    transformContexts.addAll((Collection)SparqlEndpointRequestContext.withRepository((Endpoint)endpoint, callable).call());
                }
            }
            catch (Exception ex) {
                String errorMessage = this.createErrorMessage(ex);
                if (errorMessage.contains("HTTP status 403")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Request processing error: ", (Throwable)ex);
                    }
                    LOGGER.error("Request processing error: {}", (Object)ex.getMessage());
                } else {
                    LOGGER.error("Request processing error: ", (Throwable)ex);
                }
                transformContexts.addAll(this.buildFailureResponse(queriesList, errorMessage));
            }
        }
        return transformContexts;
    }

    protected List<TransformContext> callConcurrently(R request, Set<Map.Entry<Endpoint, List<T>>> uniqueEndpoints, EndpointInvokerResolver invokerResolver, List<TransformContext> transformContexts) {
        ArrayList futures = new ArrayList(uniqueEndpoints.size());
        CountDownLatch latch = new CountDownLatch(uniqueEndpoints.size());
        for (Map.Entry<Endpoint, List<T>> entry : uniqueEndpoints) {
            Endpoint endpoint = entry.getKey();
            List<T> queriesList = entry.getValue();
            this.createEndpointRequest(endpoint, queriesList, request, invokerResolver).stream().map(callable -> this.notifyWhenDone(SparqlEndpointRequestContext.withRepository((Endpoint)endpoint, (Callable)callable), latch)).map(task -> new RequestEntity(this.getService().submit(task), queriesList)).forEach(futures::add);
        }
        boolean interrupted = false;
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            interrupted = true;
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while waiting for tasks to finish", (Throwable)ie);
        }
        for (RequestEntity requestEntity : futures) {
            try {
                List<TransformContext> contexts;
                if (interrupted) {
                    if (requestEntity.getFuture().isDone()) {
                        contexts = requestEntity.getFuture().get();
                    } else {
                        requestEntity.getFuture().cancel(true);
                        contexts = this.buildFailureResponse(requestEntity, "Query interrupted");
                    }
                } else {
                    contexts = requestEntity.getFuture().get();
                }
                transformContexts.addAll(contexts);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupted while collecting concurrent results", (Throwable)ie);
                transformContexts.addAll(this.buildFailureResponse(requestEntity, "Query interrupted"));
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                LOGGER.error("Concurrent request processing error: ", cause);
                String errorMessage = this.createErrorMessage(cause);
                transformContexts.addAll(this.buildFailureResponse(requestEntity, errorMessage));
            }
        }
        return transformContexts;
    }

    @NotNull
    private String createErrorMessage(Throwable cause) {
        Object errorMessage = Objects.toString(this.resolveErrorMessage(cause), cause.getClass().getName());
        errorMessage = "Request failed with: " + (String)errorMessage;
        return errorMessage;
    }

    private String resolveErrorMessage(Throwable error) {
        String rootMessage = error.getMessage();
        if (error.getCause() == null) {
            return rootMessage;
        }
        String currentMessage = rootMessage;
        while ((error = error.getCause()) != null) {
            String message = error.getMessage();
            if (message == null || !rootMessage.contains(message)) continue;
            currentMessage = message;
        }
        return currentMessage;
    }

    @NotNull
    private List<TransformContext> buildFailureResponse(RequestEntity<T> requestEntity, String message) {
        return this.buildFailureResponse(requestEntity.getExecutions(), message);
    }

    @NotNull
    private List<TransformContext> buildFailureResponse(List<? extends EndpointExecution> executions, String message) {
        return executions.stream().map(exec -> new TransformContext(exec.getGraphQuery(), Collections.singletonList(message), exec.getIndex())).collect(Collectors.toList());
    }

    private <C> Callable<C> notifyWhenDone(Callable<C> callable, CountDownLatch latch) {
        return () -> {
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                latch.countDown();
            }
        };
    }

    protected abstract List<Callable<List<TransformContext>>> createEndpointRequest(Endpoint var1, List<T> var2, R var3, EndpointInvokerResolver var4);

    protected ExecutorService getService() {
        if (this.service == null) {
            this.service = this.createExecutorService();
        }
        return this.service;
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("sparql-request-%d").setDaemon(true).build());
    }

    @Inject
    public void setConfiguration(ConfigurationResolver configuration) {
        if (configuration == null) {
            return;
        }
        Boolean value = (Boolean)configuration.resolve(GDB_FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS, Boolean.class, null);
        if (value != null) {
            this.forceMultiRepositorySequentialRequests = value;
            return;
        }
        this.forceMultiRepositorySequentialRequests = (Boolean)configuration.resolve(FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS, Boolean.class, (Object)Boolean.FALSE);
    }

    @Override
    public void close() {
        if (this.service != null) {
            this.service.shutdown();
            this.service = null;
        }
    }

    private static class RequestEntity<S extends EndpointExecution> {
        private final Future<List<TransformContext>> future;
        private final List<S> executions;

        private RequestEntity(Future<List<TransformContext>> future, List<S> executions) {
            this.future = future;
            this.executions = executions;
        }

        public Future<List<TransformContext>> getFuture() {
            return this.future;
        }

        public List<S> getExecutions() {
            return this.executions;
        }
    }
}

