/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.MutationRevertRequest;
import com.ontotext.graphql.responder.QuerySparqlEndpointInvoker;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.graphql.responder.validation.PostMutationContext;
import com.ontotext.graphql.responder.validation.PostMutationProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.ShaclConstraintViolation;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ValidationReportParser;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.exceptions.SerializableException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.QueryInvocationExceptionMappers;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.TransactionControlRequest;
import com.ontotext.sparql.TransactionPolicy;
import com.ontotext.sparql.UpdateResponse;
import com.ontotext.sparql.UpdateResultDiff;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationSparqlEndpointInvoker
implements EndpointInvoker<SparqlEndpoint, UpdateExecution, MutationExecutionRequest, MutationResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SparqlQueryInvoker sparqlInvoker;
    private final QuerySparqlEndpointInvoker queryEndpointInvoker;
    private final PostMutationProcessor.PostMutationProcessorsExecutor postMutationProcessorsExecutor;
    private final MutationRequestExecutor mutationRequestExecutor;
    private final MutationActiveValidator.MutationValidationExecutor validationExecutor;

    public MutationSparqlEndpointInvoker() {
        this(new SparqlQueryInvoker());
    }

    public MutationSparqlEndpointInvoker(SparqlQueryInvoker queryInvoker) {
        this.sparqlInvoker = Objects.requireNonNull(queryInvoker, "Sparql query invoker cannot be null");
        this.queryEndpointInvoker = new QuerySparqlEndpointInvoker(this.sparqlInvoker);
        this.postMutationProcessorsExecutor = new PostMutationProcessor.PostMutationProcessorsExecutor(this.sparqlInvoker);
        this.mutationRequestExecutor = new MutationRequestExecutor();
        this.validationExecutor = new MutationActiveValidator.MutationValidationExecutor();
    }

    public MutationSparqlEndpointInvoker(SparqlConnectionFactory connectionFactory) {
        this(MutationSparqlEndpointInvoker.getInvoker(connectionFactory));
    }

    private static SparqlQueryInvoker getInvoker(SparqlConnectionFactory connectionFactory) {
        if (connectionFactory != null) {
            return new SparqlQueryInvoker(connectionFactory);
        }
        return new SparqlQueryInvoker();
    }

    @Override
    public List<EndpointExecutionResponse<MutationResponse>> invoke(SparqlEndpoint endpoint, MutationExecutionRequest request) {
        return this.mutationRequestExecutor.executeMutation(endpoint, request);
    }

    @Override
    public Class<SparqlEndpoint> getEndpointType() {
        return SparqlEndpoint.class;
    }

    @Override
    public Class<MutationExecutionRequest> getExecutionRequestType() {
        return MutationExecutionRequest.class;
    }

    private static EndpointExecutionResponse<MutationResponse> createEmpty(UpdateExecution update) {
        return EndpointExecutionResponse.of(update, (Operation)update.getOperation(), new MutationResponse(EntityPoolFactory.defaultPool().emptyTree(), new UpdateResultDiff()));
    }

    @Override
    public void close() {
        this.sparqlInvoker.close();
        this.queryEndpointInvoker.close();
        this.validationExecutor.shutdownAsyncProcessing();
    }

    private class MutationRequestExecutor {
        private MutationRequestExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<EndpointExecutionResponse<MutationResponse>> executeMutation(SparqlEndpoint endpoint, MutationExecutionRequest request) {
            Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponseMapping = this.validate(request, endpoint, MutationActiveValidator.Phase.PRE_TX);
            if (this.containsInvalid(updateResponseMapping)) {
                updateResponseMapping.forEach(this::setRollbackStatus);
                return this.returnResponses(updateResponseMapping);
            }
            TransactionContext transactionContext = this.buildTransactionContext(updateResponseMapping.keySet(), endpoint);
            Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> deleteOperationsReads = this.executeReads(transactionContext, this::isDelete, updateResponseMapping);
            if (!deleteOperationsReads.isEmpty() && deleteOperationsReads.values().stream().noneMatch(EndpointExecutionResponse::isValid)) {
                return this.returnResponses(deleteOperationsReads);
            }
            try {
                this.beginTx(transactionContext, request.getShaclSchema());
                this.executeUpdates(endpoint, updateResponseMapping);
                if (this.containsInvalid(updateResponseMapping)) {
                    updateResponseMapping.forEach(this::setRollbackStatus);
                    this.callPostActions(request, updateResponseMapping);
                    List<EndpointExecutionResponse<MutationResponse>> list = this.returnResponses(updateResponseMapping);
                    return list;
                }
                this.validateRespMapping(request, updateResponseMapping, endpoint, MutationActiveValidator.Phase.PRE_COMMIT);
                if (this.containsInvalid(updateResponseMapping)) {
                    updateResponseMapping.forEach(this::setRollbackStatus);
                    this.callPostActions(request, updateResponseMapping);
                    List<EndpointExecutionResponse<MutationResponse>> list = this.returnResponses(updateResponseMapping);
                    return list;
                }
                this.commitTx(transactionContext);
                this.validateRespMapping(request, updateResponseMapping, endpoint, MutationActiveValidator.Phase.POST_COMMIT);
                if (this.containsInvalid(updateResponseMapping)) {
                    this.revertCommit(request, endpoint, updateResponseMapping, transactionContext);
                    List<EndpointExecutionResponse<MutationResponse>> list = this.returnResponses(updateResponseMapping);
                    return list;
                }
            }
            catch (TransactionExecutionFailed tef) {
                TransactionControlRequest onError = transactionContext.getTransactionPolicy().onError(transactionContext.getTransactionId(), (Throwable)tef);
                if (onError != null) {
                    MutationSparqlEndpointInvoker.this.sparqlInvoker.invoke((SparqlRequest)onError, endpoint, transactionContext.getConnectionPolicy());
                }
                updateResponseMapping.forEach(this::setRollbackStatus);
                this.callPostActions(request, updateResponseMapping);
                ShaclSchema shaclSchema = request.getShaclSchema();
                List<EndpointExecutionResponse<MutationResponse>> list = new TransactionErrorHandler(shaclSchema, transactionContext).transform(tef, updateResponseMapping);
                return list;
            }
            finally {
                transactionContext.getConnectionPolicy().close();
            }
            Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> readResponses = this.executeReads(transactionContext, update -> !this.isDelete((UpdateExecution)update), updateResponseMapping);
            deleteOperationsReads.forEach(updateResponseMapping::replace);
            readResponses.forEach(updateResponseMapping::replace);
            this.callPostActions(request, updateResponseMapping);
            return this.returnResponses(updateResponseMapping);
        }

        private void callPostActions(MutationExecutionRequest request, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponseMapping) {
            PostMutationContext context = new PostMutationContext();
            updateResponseMapping.forEach((update, response) -> MutationSparqlEndpointInvoker.this.postMutationProcessorsExecutor.execute((UpdateExecution)update, (EndpointExecutionResponse<MutationResponse>)response, request, context));
            MutationSparqlEndpointInvoker.this.postMutationProcessorsExecutor.finalizeProcessing(request, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void revertCommit(MutationExecutionRequest request, SparqlEndpoint endpoint, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponseMapping, TransactionContext transactionContext) throws TransactionExecutionFailed {
            TransactionContext revertContext = new TransactionContext(this, UUID.randomUUID().toString(), transactionContext.getTransactionPolicy(), transactionContext.getConnectionPolicy(), transactionContext.getEndpoint());
            try {
                this.beginTx(revertContext, null);
                updateResponseMapping.keySet().stream().map(MutationRevertRequest::new).forEach(req -> MutationSparqlEndpointInvoker.this.sparqlInvoker.invoke((SparqlRequest)req, endpoint, transactionContext.getConnectionPolicy()));
                this.commitTx(revertContext);
            }
            finally {
                updateResponseMapping.forEach(this::setRollbackStatus);
                this.callPostActions(request, updateResponseMapping);
            }
        }

        private void executeUpdates(SparqlEndpoint endpoint, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponseMapping) {
            for (Map.Entry<UpdateExecution, EndpointExecutionResponse<MutationResponse>> entry : updateResponseMapping.entrySet()) {
                entry.setValue(new UpdateStepsExecutor(entry.getKey(), endpoint, MutationSparqlEndpointInvoker.this.sparqlInvoker).execute());
                if (entry.getValue().isValid()) continue;
                return;
            }
        }

        private void setRollbackStatus(UpdateExecution execution, EndpointExecutionResponse<MutationResponse> response) {
            if (execution.getTransactionPolicy().rollBackOnSingleUpdateFailure()) {
                response.rollback(true);
            } else {
                response.rollback(!response.isValid());
            }
        }

        private List<EndpointExecutionResponse<MutationResponse>> returnResponses(Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponseMapping) {
            return new ArrayList<EndpointExecutionResponse<MutationResponse>>(updateResponseMapping.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> validate(MutationExecutionRequest request, SparqlEndpoint endpoint, MutationActiveValidator.Phase phase) {
            if (request.isHealthRequest()) {
                return request.getExecutions().stream().collect(Collectors.toMap(Function.identity(), MutationSparqlEndpointInvoker::createEmpty, CollectionsUtil.throwIfSame(), LinkedHashMap::new));
            }
            Timer timer = Timer.start();
            try {
                Map map = MutationSparqlEndpointInvoker.this.validationExecutor.validate(request, MutationSparqlEndpointInvoker.this.sparqlInvoker, endpoint, phase).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, report -> this.buildEndpointResponse((Map.Entry<UpdateExecution, OperationResponse>)report, request), CollectionsUtil.throwIfSame(), LinkedHashMap::new));
                return map;
            }
            finally {
                Loggers.graphqlLogger().trace("Mutation validation for phase {} took {} ms", (Object)phase, (Object)timer.getDuration());
            }
        }

        private EndpointExecutionResponse<MutationResponse> buildEndpointResponse(Map.Entry<UpdateExecution, OperationResponse> validationReport, MutationExecutionRequest request) {
            OperationResponse response = validationReport.getValue();
            request.addWarnings(this.getWarnings(response));
            if (response.isValid()) {
                return MutationSparqlEndpointInvoker.createEmpty(validationReport.getKey());
            }
            return this.buildErrorResponse(validationReport.getKey(), response);
        }

        private void validateRespMapping(MutationExecutionRequest request, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> respMapping, SparqlEndpoint endpoint, MutationActiveValidator.Phase phase) {
            Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> validationMapping = this.validate(request, endpoint, phase);
            respMapping.replaceAll((update, response) -> {
                EndpointExecutionResponse valResp = (EndpointExecutionResponse)validationMapping.get(update);
                if (valResp != null && !valResp.isValid()) {
                    return EndpointExecutionResponse.ofError(update, response.getOperation(), ListUtils.union(response.getErrors(), valResp.getErrors()), response::getData);
                }
                return response;
            });
        }

        private List<Serializable> getWarnings(OperationResponse response) {
            return response.getWarnings().stream().map(OperationResponse.OperationMessage::toString).collect(Collectors.toList());
        }

        private EndpointExecutionResponse<MutationResponse> buildErrorResponse(UpdateExecution update, OperationResponse response) {
            List<Serializable> errors = this.collectErrors(response);
            Mutation operation = update.getOperation();
            operation.invalidate();
            return EndpointExecutionResponse.ofError(update, (Operation)operation, errors);
        }

        private List<Serializable> collectErrors(OperationResponse response) {
            return response.getErrors().stream().map(OperationResponse.OperationMessage::serialize).collect(Collectors.toList());
        }

        private TransactionContext buildTransactionContext(Set<UpdateExecution> updates, SparqlEndpoint endpoint) {
            UpdateExecution update = updates.iterator().next();
            String txId = update.getTxId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wrapping multiple updates with request ids: {} in one transaction with id: {}", (Object)updates.stream().map(UpdateExecution::getRequestId).collect(Collectors.joining(",")), (Object)txId);
            }
            TransactionPolicy txPolicy = update.getTransactionPolicy();
            ConnectionReusePolicy connection = update.getConnectionReusePolicy();
            return new TransactionContext(this, txId, txPolicy, connection, endpoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> executeReads(TransactionContext context, Predicate<UpdateExecution> requestFilter, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> map) {
            LinkedHashMap<UpdateExecution, EndpointExecutionResponse<MutationResponse>> copy = new LinkedHashMap<UpdateExecution, EndpointExecutionResponse<MutationResponse>>(map);
            copy.keySet().removeIf(requestFilter.negate());
            if (copy.isEmpty()) {
                return Collections.emptyMap();
            }
            try {
                copy.replaceAll((update, response) -> {
                    EndpointExecutionResponse<RdfTree> result = MutationSparqlEndpointInvoker.this.queryEndpointInvoker.invoke(context.getEndpoint(), update.toQueryRequest()).get(0);
                    if (result.isValid()) {
                        return EndpointExecutionResponse.of(update, (Operation)update.getOperation(), new MutationResponse(result.getData(), new UpdateResultDiff()));
                    }
                    return EndpointExecutionResponse.ofError(update, (Operation)update.getOperation(), Collections.singletonList("Failed to fetch data after update due to: " + String.valueOf(result.getErrors())));
                });
            }
            finally {
                context.getConnectionPolicy().close();
            }
            return copy;
        }

        private boolean isDelete(UpdateExecution update) {
            return OperationType.DELETE.equals((Object)update.getOperation().getOperationType());
        }

        private void beginTx(TransactionContext context, ShaclSchema schema) throws TransactionExecutionFailed {
            ExecutionResponse response;
            String txId = context.getTransactionId();
            TransactionControlRequest txRequest = context.getTransactionPolicy().onBeforeFirst(txId);
            if (txRequest == null) {
                LOGGER.debug("Skipped begin for manual Tx: {}", (Object)txId);
                return;
            }
            if (null != schema) {
                txRequest.setShaclEnabled(((Boolean)ObjectsUtil.getOrDefault((Object)schema.isEnabledAtTransactionLevel(), (Object)Boolean.TRUE)).booleanValue());
            }
            if ((response = MutationSparqlEndpointInvoker.this.sparqlInvoker.invoke((SparqlRequest)txRequest, context.getEndpoint(), context.getConnectionPolicy())) == null || response.getError() == null) {
                LOGGER.debug("Transaction {} started successfully.", (Object)context.getTransactionId());
                return;
            }
            throw new TransactionExecutionFailed(false, response.getError());
        }

        private boolean containsInvalid(Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> map) {
            return map.values().stream().anyMatch(response -> !response.isValid());
        }

        private void commitTx(TransactionContext context) throws TransactionExecutionFailed {
            String txId = context.getTransactionId();
            TransactionControlRequest request = context.getTransactionPolicy().onAfterLast(txId);
            if (request == null) {
                LOGGER.debug("Skipped commit for manual Tx: {}", (Object)txId);
                return;
            }
            ExecutionResponse response = MutationSparqlEndpointInvoker.this.sparqlInvoker.invoke((SparqlRequest)request, context.getEndpoint(), context.getConnectionPolicy());
            if (response == null || response.getError() == null) {
                LOGGER.debug("Transaction with id: {} was committed successfully.", (Object)txId);
                return;
            }
            throw new TransactionExecutionFailed(true, QueryInvocationExceptionMappers.map((Throwable)response.getError()));
        }

        private class TransactionContext {
            private final String transactionId;
            private final TransactionPolicy transactionPolicy;
            private final ConnectionReusePolicy connectionPolicy;
            private final SparqlEndpoint endpoint;

            private TransactionContext(MutationRequestExecutor mutationRequestExecutor, String transactionId, TransactionPolicy transactionPolicy, ConnectionReusePolicy connectionPolicy, SparqlEndpoint endpoint) {
                this.transactionId = transactionId;
                this.transactionPolicy = transactionPolicy;
                this.connectionPolicy = connectionPolicy;
                this.endpoint = endpoint;
            }

            private String getTransactionId() {
                return this.transactionId;
            }

            private TransactionPolicy getTransactionPolicy() {
                return this.transactionPolicy;
            }

            private ConnectionReusePolicy getConnectionPolicy() {
                return this.connectionPolicy;
            }

            private SparqlEndpoint getEndpoint() {
                return this.endpoint;
            }
        }

        private class TransactionExecutionFailed
        extends Exception {
            private static final String TRANSACTION_FAILURE = "Transaction failure: ";
            private static final long serialVersionUID = 4267627554219318588L;
            private final Collection<Throwable> errors;
            private final boolean thrownOnCommit;
            private final transient ValidationReportParser parser = new ValidationReportParser();

            private TransactionExecutionFailed(boolean thrownOnCommit, Throwable ... error) {
                this.thrownOnCommit = thrownOnCommit;
                this.errors = Arrays.asList(error);
            }

            private List<Serializable> getErrorMessages() {
                Stream<Throwable> stream = this.errors.stream();
                if (LOGGER.isDebugEnabled()) {
                    stream = stream.peek(error -> LOGGER.debug(TRANSACTION_FAILURE, error));
                }
                return stream.filter(error -> !(error instanceof ValidationException) && !error.toString().contains("Failed SHACL validation")).map(throwable -> throwable instanceof SerializableException ? ((SerializableException)throwable).messageAsSerializable() : throwable.getMessage()).filter(Objects::nonNull).collect(Collectors.toList());
            }

            private List<ValidationException> getValidationExceptions(ShaclSchema shaclSchema) {
                List<ValidationException> exceptionList = this.errors.stream().filter(ValidationException.class::isInstance).map(ValidationException.class::cast).collect(Collectors.toList());
                List oldShaclErrors = this.errors.stream().filter(error -> !(error instanceof ValidationException)).filter(error -> error.toString().contains("Failed SHACL validation")).map(error -> () -> this.parser.parseShaclReport(error.toString(), shaclSchema)).collect(Collectors.toList());
                exceptionList.addAll(oldShaclErrors);
                if (LOGGER.isDebugEnabled()) {
                    exceptionList.forEach(error -> LOGGER.debug(TRANSACTION_FAILURE, (Throwable)error));
                }
                return exceptionList;
            }

            private boolean isThrownOnCommit() {
                return this.thrownOnCommit;
            }
        }

        private class TransactionErrorHandler {
            private final ShaclSchema shaclSchema;
            private final TransactionContext context;
            private final ValidationReportParser parser = new ValidationReportParser();

            private TransactionErrorHandler(ShaclSchema shaclSchema, TransactionContext context) {
                this.shaclSchema = shaclSchema;
                this.context = context;
            }

            private List<EndpointExecutionResponse<MutationResponse>> transform(TransactionExecutionFailed exception, Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponse) {
                List<Serializable> txErrors = exception.getErrorMessages();
                if (!exception.isThrownOnCommit()) {
                    return this.returnResponseWithCommonErrors(updateResponse, txErrors);
                }
                List<ValidationException> shaclValidationExceptions = exception.getValidationExceptions(this.shaclSchema);
                if (shaclValidationExceptions.isEmpty()) {
                    return this.returnResponseWithCommonErrors(updateResponse, txErrors);
                }
                List shaclErrors = shaclValidationExceptions.stream().map(this::reportShaclErrors).flatMap(response -> response.getErrorMessages().stream()).collect(Collectors.toList());
                ArrayList<Serializable> errors = new ArrayList<Serializable>(txErrors.size() + shaclErrors.size());
                errors.addAll(shaclErrors);
                errors.addAll(txErrors);
                return this.returnResponseWithCommonErrors(updateResponse, errors);
            }

            private List<EndpointExecutionResponse<MutationResponse>> returnResponseWithCommonErrors(Map<UpdateExecution, EndpointExecutionResponse<MutationResponse>> updateResponse, List<Serializable> txErrors) {
                LinkedHashMap<UpdateExecution, EndpointExecutionResponse<MutationResponse>> resp = new LinkedHashMap<UpdateExecution, EndpointExecutionResponse<MutationResponse>>();
                boolean addedErrors = false;
                for (Map.Entry<UpdateExecution, EndpointExecutionResponse<MutationResponse>> entry : updateResponse.entrySet()) {
                    UpdateExecution execution = entry.getKey();
                    resp.put(execution, EndpointExecutionResponse.ofError(execution, entry.getValue().getOperation(), addedErrors ? Collections.emptyList() : txErrors, () -> (MutationResponse)((EndpointExecutionResponse)entry.getValue()).getData()));
                    addedErrors = true;
                }
                return MutationRequestExecutor.this.returnResponses(resp);
            }

            private List<Statement> fetchStatements() {
                String txId = this.context.getTransactionId();
                SparqlEndpoint endpoint = this.context.getEndpoint();
                ConnectionReusePolicy connection = this.context.getConnectionPolicy();
                return MutationSparqlEndpointInvoker.this.sparqlInvoker.fetchStatements(txId, endpoint, connection, null, SHACL.PROPERTY, null, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
            }

            private OperationResponse reportShaclErrors(ValidationException violations) {
                List errors = this.parser.parse(violations, this.shaclSchema);
                ArrayList clusterMismatchedConstraints = new ArrayList();
                Function typeResolver = this.parser.createShaclTypeResolver(this.fetchStatements());
                errors.stream().filter(ShaclConstraintViolation::needsParsing).forEach(constraint -> this.fetchActualViolation((ShaclConstraintViolation)constraint, typeResolver, clusterMismatchedConstraints));
                this.parser.processClusterMismatches(errors, clusterMismatchedConstraints, this.shaclSchema);
                OperationResponse response = new OperationResponse();
                errors.forEach(constraint -> response.addError(Objects.toString(constraint)));
                return response;
            }

            private void fetchActualViolation(ShaclConstraintViolation constraint, Function<ShaclConstraintViolation, Resource> typeResolver, List<ShaclConstraintViolation> clusterMismatchedConstraints) {
                Resource type = typeResolver.apply(constraint);
                if (null == type) {
                    clusterMismatchedConstraints.add(constraint);
                    return;
                }
                try {
                    this.fetchActualViolation(constraint, this.shaclSchema.getPrefixes().toName(type.stringValue()));
                }
                catch (IllegalArgumentException iae) {
                    clusterMismatchedConstraints.add(constraint);
                }
            }

            private void fetchActualViolation(ShaclConstraintViolation constraint, String object) {
                constraint.setSemanticObject(object);
                constraint.parseTargetValue(this.shaclSchema);
            }
        }
    }

    public static class UpdateStepsExecutor {
        final UpdateExecution request;
        final SparqlEndpoint endpoint;
        final SparqlQueryInvoker sparqlInvoker;

        public UpdateStepsExecutor(UpdateExecution request, SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker) {
            this.request = request;
            this.endpoint = endpoint;
            this.sparqlInvoker = sparqlInvoker;
        }

        public EndpointExecutionResponse<MutationResponse> execute() {
            List<UpdateStep> updateSteps = this.request.getUpdateSteps();
            if (updateSteps.isEmpty()) {
                return MutationSparqlEndpointInvoker.createEmpty(this.request);
            }
            EndpointExecutionResponse<MutationResponse> response = null;
            for (UpdateStep updateStep : updateSteps) {
                response = this.executeUpdateStep(updateStep);
                if (response == null || response.isValid()) continue;
                return response;
            }
            return response;
        }

        private EndpointExecutionResponse<MutationResponse> executeMutation(UpdateStep updateStep) {
            TransactionPolicy txPolicy = this.request.getTransactionPolicy();
            Function<String, TransactionControlRequest> onBeforeEach = arg_0 -> ((TransactionPolicy)txPolicy).onBeforeEach(arg_0);
            EndpointExecutionResponse<MutationResponse> beforeUpdate = this.performTxRequest(updateStep.getRequestId(), onBeforeEach.andThen(this.updateLoggingPolicy()));
            if (beforeUpdate != null) {
                return beforeUpdate;
            }
            SparqlRequest<String> updateRequest = this.createUpdateRequest(updateStep);
            ConnectionReusePolicy reusePolicy = this.request.getConnectionReusePolicy();
            ExecutionResponse response = this.sparqlInvoker.invoke(updateRequest, this.endpoint, reusePolicy);
            Throwable rollbackCause = null;
            if (response != null && response.getError() != null) {
                rollbackCause = response.getError();
            } else if (response != null && !(response instanceof UpdateResponse)) {
                rollbackCause = new IllegalStateException("Unexpected response for a query update: " + String.valueOf(response));
            }
            if (rollbackCause != null) {
                throw new RollBackException(rollbackCause);
            }
            EndpointExecutionResponse<MutationResponse> afterUpdate = this.performTxRequest(updateStep.getRequestId(), arg_0 -> ((TransactionPolicy)txPolicy).onAfterEach(arg_0));
            if (afterUpdate != null && !afterUpdate.isValid()) {
                return afterUpdate;
            }
            return MutationSparqlEndpointInvoker.createEmpty(this.request);
        }

        @NotNull
        private Function<TransactionControlRequest, TransactionControlRequest> updateLoggingPolicy() {
            return transactionControlRequest -> {
                if (transactionControlRequest != null) {
                    return transactionControlRequest.disableRequestLogging();
                }
                return null;
            };
        }

        private EndpointExecutionResponse<MutationResponse> performTxRequest(String requestId, Function<String, TransactionControlRequest> txStepBuilder) {
            TransactionControlRequest txStep = txStepBuilder.apply(requestId);
            return this.executeTxCtrlRequest(txStep);
        }

        protected EndpointExecutionResponse<MutationResponse> rollBack(Error rollbackCause) {
            TransactionControlRequest rollBack = this.request.getTransactionPolicy().onError(this.request.getRequestId(), rollbackCause.getCause());
            if (rollBack == null) {
                LOGGER.info("Ignoring exception for update failure: {}", (Object)rollbackCause);
                return null;
            }
            LOGGER.warn("Rolling back transaction due to failure: {}", (Object)rollbackCause);
            ExecutionResponse rollBackResponse = this.sparqlInvoker.invoke((SparqlRequest)rollBack, this.endpoint, this.request.getConnectionReusePolicy());
            if (rollBackResponse == null || rollBackResponse.getError() == null) {
                return this.reportErrors(Collections.singletonList(rollbackCause), "Transaction rollbacked due to: ");
            }
            return this.reportErrors(Arrays.asList(rollbackCause, new Error(rollBackResponse.getError())), "Error during transaction rollback: ");
        }

        private EndpointExecutionResponse<MutationResponse> executeTxCtrlRequest(TransactionControlRequest txRequest) {
            if (txRequest == null) {
                return null;
            }
            ExecutionResponse txCtrlResponse = this.sparqlInvoker.invoke((SparqlRequest)txRequest, this.endpoint, this.request.getConnectionReusePolicy());
            if (txCtrlResponse == null || txCtrlResponse.getError() == null) {
                return null;
            }
            return this.reportErrors(Collections.singletonList(new Error(txCtrlResponse.getError())), "Error before update execution: ");
        }

        protected EndpointExecutionResponse<MutationResponse> reportErrors(Collection<Error> collection, String message) {
            return EndpointExecutionResponse.ofError(this.request.getQuery(), (Operation)this.request.getQuery().getGraphQuery(), collection.stream().peek(error -> LOGGER.debug(message, error.getCause())).map(Error::getMessage).collect(Collectors.toList()), () -> new MutationResponse(EntityPoolFactory.defaultPool().emptyTree(), new UpdateResultDiff()));
        }

        private SparqlRequest<String> createUpdateRequest(UpdateStep updateStep) {
            return updateStep.toSparqlRequest(this.request.getSchema());
        }

        private EndpointExecutionResponse<MutationResponse> executeUpdateStep(UpdateStep updateStep) {
            EndpointExecutionResponse<MutationResponse> response;
            try {
                response = this.executeMutation(updateStep);
            }
            catch (RollBackException re) {
                Error error = new Error(re.getCause());
                response = this.rollBack(error);
            }
            return response;
        }

        private static class RollBackException
        extends RuntimeException {
            private static final long serialVersionUID = -4564160302094130165L;

            RollBackException(Throwable cause) {
                super(cause);
            }
        }

        public static class Error {
            Throwable cause;
            Serializable message;

            public Error(Throwable cause) {
                this.cause = cause;
                this.extractSerializedMessage(cause);
            }

            public Error(Throwable cause, Serializable message) {
                this.cause = cause;
                this.message = message;
            }

            private void extractSerializedMessage(Throwable cause) {
                for (Throwable curr = cause; curr != null; curr = curr.getCause()) {
                    if (!(curr instanceof SerializableException)) continue;
                    this.message = ((SerializableException)curr).messageAsSerializable();
                    break;
                }
            }

            public Throwable getCause() {
                return this.cause;
            }

            public Serializable getMessage() {
                return this.message != null ? this.message : this.cause.getMessage();
            }

            public void setMessage(Serializable message) {
                this.message = message;
            }
        }
    }
}

