/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.soaas.common.connection.Endpoint;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class EndpointInvokerStore
implements EndpointInvokerResolver {
    private final Map<Class, List<EndpointInvoker>> endpointToInvoker;

    public EndpointInvokerStore(Collection<EndpointInvoker> invokers) {
        this.endpointToInvoker = invokers.stream().collect(Collectors.groupingBy(EndpointInvoker::getEndpointType));
    }

    @Override
    public Optional<EndpointInvoker> resolve(Endpoint endpoint, ExecutionRequest<?> executionContext) {
        return this.endpointToInvoker.getOrDefault(endpoint.getClass(), Collections.emptyList()).stream().filter(invoker -> invoker.accept(endpoint, executionContext)).findFirst();
    }

    @Override
    public void close() {
        this.endpointToInvoker.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).forEach(instance -> IOUtils.closeQuietly((Closeable)instance, ex -> {}));
    }
}

