/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.models.Operation;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface EndpointExecutionResponse<D> {
    @NotNull
    public EndpointExecution getRequest();

    public Operation getOperation();

    public D getData();

    public List<Serializable> getErrors();

    public Map<String, Object> getExtensions();

    default public boolean isValid() {
        return this.getData() != null && (this.getErrors() == null || this.getErrors().isEmpty());
    }

    public static <D> EndpointExecutionResponse<D> of(EndpointExecution request, Operation operation, D data) {
        return new DefaultEndpointExecutionResponse<D>(request, operation, data, null);
    }

    public static <D> EndpointExecutionResponse<D> ofError(EndpointExecution request, Operation operation, List<? extends Serializable> errors) {
        return new DefaultEndpointExecutionResponse<Object>(request, operation, null, errors);
    }

    public static <D> EndpointExecutionResponse<D> ofError(EndpointExecution request, Operation operation, List<? extends Serializable> errors, Supplier<D> defaultData) {
        return new DefaultEndpointExecutionResponse<D>(request, operation, defaultData.get(), errors);
    }

    public boolean rollback();

    public void rollback(boolean var1);

    public static class DefaultEndpointExecutionResponse<D>
    implements EndpointExecutionResponse<D> {
        private final EndpointExecution request;
        private final Operation operation;
        private final D data;
        private final List<Serializable> errors;
        private final Map<String, Object> extensions;
        private boolean rollback = false;

        DefaultEndpointExecutionResponse(EndpointExecution request, Operation operation, D data, List<? extends Serializable> errors) {
            this.request = request;
            this.operation = operation;
            this.data = data;
            this.errors = new LinkedList(errors == null ? Collections.emptyList() : errors);
            this.extensions = new LinkedHashMap<String, Object>();
        }

        @Override
        @NotNull
        public EndpointExecution getRequest() {
            return this.request;
        }

        @Override
        public Operation getOperation() {
            return this.operation;
        }

        @Override
        public D getData() {
            return this.data;
        }

        @Override
        public List<Serializable> getErrors() {
            return this.errors;
        }

        @Override
        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        @Override
        public boolean rollback() {
            return this.rollback;
        }

        @Override
        public void rollback(boolean rollback) {
            this.rollback = rollback;
        }
    }
}

