/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalNameTokenizer
extends Tokenizer {
    private static final Logger log = LoggerFactory.getLogger(LocalNameTokenizer.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private String stringToTokenize;
    private int tokenStart;

    LocalNameTokenizer() {
    }

    private void readStringToTokenize(Reader input) {
        char[] buffer = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int numChars;
            while ((numChars = input.read(buffer, 0, buffer.length)) != -1) {
                stringBuilder.append(buffer, 0, numChars);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tokenStart = 0;
        this.stringToTokenize = stringBuilder.toString();
    }

    private boolean isOtherNameCharacter(char character) {
        return character == '\'' || character == '`';
    }

    public void end() throws IOException {
        super.end();
        if (this.stringToTokenize != null) {
            this.offsetAtt.setOffset(this.stringToTokenize.length(), this.stringToTokenize.length());
        }
        this.stringToTokenize = null;
    }

    public boolean incrementToken() throws IOException {
        try {
            int tokenEnd;
            int endOfString;
            this.clearAttributes();
            if (this.stringToTokenize == null) {
                this.readStringToTokenize(this.input);
            }
            if (this.tokenStart >= (endOfString = this.stringToTokenize.length())) {
                return false;
            }
            char startTokenChar = this.stringToTokenize.charAt(this.tokenStart);
            while (startTokenChar == ' ' || startTokenChar == '\t' || startTokenChar == '\n' || startTokenChar == '\r') {
                ++this.tokenStart;
                if (this.tokenStart == endOfString) {
                    return false;
                }
                startTokenChar = this.stringToTokenize.charAt(this.tokenStart);
            }
            if (this.tokenStart + 1 >= endOfString) {
                this.termAtt.setEmpty().append(this.stringToTokenize.substring(this.tokenStart));
                this.positionIncrementAttribute.setPositionIncrement(1);
                this.offsetAtt.setOffset(this.tokenStart, this.stringToTokenize.length());
                ++this.tokenStart;
                return true;
            }
            char nextTokenChar = this.stringToTokenize.charAt(tokenEnd);
            if (Character.isLowerCase(startTokenChar)) {
                for (tokenEnd = this.tokenStart + 1; tokenEnd < endOfString && this.lowerCaseOrOtherName(this.stringToTokenize.charAt(tokenEnd)); ++tokenEnd) {
                }
            } else if (Character.isUpperCase(startTokenChar)) {
                if (Character.isUpperCase(nextTokenChar)) {
                    while (tokenEnd < endOfString && this.upperCaseOrOtherName(this.stringToTokenize.charAt(tokenEnd))) {
                        ++tokenEnd;
                    }
                    if (tokenEnd < endOfString && Character.isLowerCase(this.stringToTokenize.charAt(tokenEnd))) {
                        --tokenEnd;
                    }
                } else if (Character.isLowerCase(nextTokenChar)) {
                    while (tokenEnd < endOfString && this.lowerCaseOrOtherName(this.stringToTokenize.charAt(tokenEnd))) {
                        ++tokenEnd;
                    }
                }
            } else if (Character.isDigit(startTokenChar)) {
                while (tokenEnd < endOfString && Character.isDigit(this.stringToTokenize.charAt(tokenEnd))) {
                    ++tokenEnd;
                }
            } else {
                while (tokenEnd < endOfString && !this.letterDigitOrOtherName(this.stringToTokenize.charAt(tokenEnd))) {
                    ++tokenEnd;
                }
            }
            if (this.tokenStart == tokenEnd) {
                return false;
            }
            this.termAtt.setEmpty().append(this.stringToTokenize.substring(this.tokenStart, tokenEnd));
            this.positionIncrementAttribute.setPositionIncrement(1);
            this.offsetAtt.setOffset(this.tokenStart, tokenEnd);
            this.tokenStart = tokenEnd;
            return true;
        }
        catch (Exception e) {
            log.error("Error while processing token", (Throwable)e);
            this.stringToTokenize = null;
            throw new RuntimeException(e);
        }
    }

    private boolean lowerCaseOrOtherName(char c) {
        return Character.isLowerCase(c) || this.isOtherNameCharacter(c);
    }

    private boolean upperCaseOrOtherName(char c) {
        return Character.isUpperCase(c) || this.isOtherNameCharacter(c);
    }

    private boolean letterDigitOrOtherName(char c) {
        return Character.isLetterOrDigit(c) || this.isOtherNameCharacter(c);
    }
}

