/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.ontotext.trree.plugin.autocomplete.AutocompleteIndex;
import com.ontotext.trree.plugin.autocomplete.LabelConfig;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.BytesRef;

class LabelsIterator
implements InputIterator,
AutoCloseable,
Closeable {
    private final LabelConfig labelConfig;
    private final Entities entities;
    private final AutocompleteIndex autocompleteIndex;
    private final StatementIterator statementIterator;
    private long currentSubject = 0L;
    private String currentLabel;

    LabelsIterator(Entities entities, Statements statements, LabelConfig labelConfig, AutocompleteIndex autocompleteIndex) {
        this.autocompleteIndex = autocompleteIndex;
        this.entities = entities;
        this.labelConfig = labelConfig;
        this.statementIterator = statements.get(0L, labelConfig.labelId, 0L);
    }

    public long weight() {
        return this.autocompleteIndex.getWeight(this.currentSubject, this.currentLabel);
    }

    public BytesRef payload() {
        return this.autocompleteIndex.getEntityIDAsPayload(this.currentSubject, true);
    }

    public boolean hasPayloads() {
        return true;
    }

    public Set<BytesRef> contexts() {
        return this.autocompleteIndex.getLabelContexts();
    }

    public boolean hasContexts() {
        return true;
    }

    public BytesRef next() throws IOException {
        while (this.statementIterator.next() && !this.autocompleteIndex.isShouldInterrupt()) {
            String language;
            this.currentSubject = this.statementIterator.subject;
            if (this.entities.getType(this.currentSubject) != Entities.Type.URI && this.entities.getType(this.currentSubject) != Entities.Type.TRIPLE || !this.labelConfig.languageMatches(language = this.entities.getLanguage(this.statementIterator.object))) continue;
            this.currentLabel = this.entities.get(this.statementIterator.object).stringValue();
            return new BytesRef((CharSequence)this.currentLabel);
        }
        return null;
    }

    @Override
    public void close() {
        this.statementIterator.close();
    }
}

