/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.ontotext.trree.plugin.autocomplete.AbstractEntitiesIterator;
import com.ontotext.trree.plugin.autocomplete.AutocompleteIndex;
import com.ontotext.trree.sdk.Entities;
import org.apache.lucene.util.BytesRef;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

class EntitiesIterator
extends AbstractEntitiesIterator {
    private final Entities entities;

    EntitiesIterator(Entities entities, AutocompleteIndex autocompleteIndex) {
        super(autocompleteIndex);
        this.entities = entities;
    }

    public BytesRef payload() {
        return this.autocompleteIndex.getEntityIDAsPayload(this.currentIteratorIndex, false);
    }

    public BytesRef next() {
        while (++this.currentIteratorIndex <= this.entities.size() && !this.autocompleteIndex.isShouldInterrupt()) {
            Value v = this.entities.get(this.currentIteratorIndex);
            if (!(v instanceof IRI) || AutocompleteIndex.SPECIAL_ENTITIES.contains(v.stringValue())) continue;
            this.currentURI = (IRI)v;
            this.currentLocalName = this.currentURI.getLocalName();
            return new BytesRef((CharSequence)this.currentLocalName);
        }
        return null;
    }
}

