/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import com.ontotext.graphdb.GraphDBRepositoryManager;
import java.io.File;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.Connect;
import org.eclipse.rdf4j.console.command.Disconnect;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class GraphDBConnect
extends Connect {
    private final Disconnect disconnect;

    public GraphDBConnect(ConsoleIO consoleIO, ConsoleState state, Disconnect disconnect) {
        super(consoleIO, state, disconnect);
        this.disconnect = disconnect;
    }

    public boolean connectLocal(String path) {
        File dir = new File(path + File.separator + "data");
        boolean result = false;
        if (dir.exists() && dir.isDirectory()) {
            result = this.installNewManager((RepositoryManager)new GraphDBRepositoryManager(dir), dir.getParent());
        } else {
            this.writeError("Specified path is not an (existing) directory: " + path);
        }
        return result;
    }

    public boolean connectDefault() {
        return this.installNewManager((RepositoryManager)new GraphDBRepositoryManager(this.getConsoleState().getDataDirectory()), "default data directory");
    }

    private boolean installNewManager(RepositoryManager newManager, String newManagerID) {
        boolean installed = false;
        String managerID = this.getConsoleState().getManagerID();
        if (newManagerID.equals(managerID)) {
            this.writeln("Already connected to " + managerID);
            installed = true;
        } else {
            try {
                newManager.init();
                this.disconnect.execute(false);
                this.getConsoleState().setManager(newManager);
                this.getConsoleState().setManagerID(newManagerID);
                this.writeln("Connected to " + newManagerID);
                installed = true;
            }
            catch (RepositoryException e) {
                this.writeError("Failed to install new manager", (Exception)((Object)e));
            }
        }
        return installed;
    }
}

