/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.server;

import com.ontotext.graphdb.LoggerConfigurator;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;

public class Util {
    private static final Field responseFacadeResponseField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean portIsAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static void configureServerLogging() {
        LoggerConfigurator.setConsoleLogging(false);
    }

    private static long getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index >= 1) {
            return Long.parseLong(jvmName.substring(0, index));
        }
        throw new RuntimeException("Unable to get the PID of the running process.");
    }

    public static void writePidFile(String pidFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pidFile);){
            fileWriter.write(Long.toString(Util.getProcessId()));
            fileWriter.write(System.lineSeparator());
        }
    }

    public static void unsetHeader(HttpServletResponse response, String headerName) {
        if (responseFacadeResponseField != null && response instanceof ResponseFacade) {
            try {
                Response r = (Response)responseFacadeResponseField.get(response);
                r.getCoyoteResponse().getMimeHeaders().removeHeader(headerName);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static {
        Field field;
        try {
            field = ResponseFacade.class.getDeclaredField("response");
            field.setAccessible(true);
        }
        catch (Exception e) {
            field = null;
        }
        responseFacadeResponseField = field;
    }
}

