/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.server;

import com.ontotext.graphdb.server.Util;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;

public class CustomErrorHandler
extends HttpServlet {
    private void handleError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Throwable ex;
        Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        String message = (String)request.getAttribute("jakarta.servlet.error.message");
        if (StringUtils.isEmpty((CharSequence)message) && StringUtils.isEmpty((CharSequence)(message = ExceptionUtils.getRootCauseMessage((Throwable)(ex = (Throwable)request.getAttribute("jakarta.servlet.error.exception")))))) {
            if (statusCode != null) {
                try {
                    message = HttpStatus.valueOf((int)statusCode).getReasonPhrase();
                }
                catch (IllegalArgumentException e) {
                    message = "Unknown error";
                }
            } else {
                message = "Unknown error";
            }
        }
        try {
            Util.unsetHeader(response, "content-disposition");
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.println(message);
        }
        catch (IllegalStateException ise) {
            this.log(message, ise);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getMethod().equalsIgnoreCase("PATCH")) {
            this.handleError(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleError(req, resp);
    }
}

