/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.ontotext.graphdb.Config;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.MDC;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggerConfigurator
extends BasicConfigurator
implements Configurator {
    private static boolean consoleLogging = true;

    public static void setConsoleLogging(boolean consoleLogging) {
        LoggerConfigurator.consoleLogging = consoleLogging;
    }

    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        try {
            URL logbackConfig;
            URL uRL = logbackConfig = consoleLogging ? this.getConsoleLogbackConfigFile() : this.getLogbackConfigFile();
            if (logbackConfig != null) {
                JoranConfigurator joranConfigurator = new JoranConfigurator();
                joranConfigurator.setContext((Context)loggerContext);
                joranConfigurator.doConfigure(logbackConfig);
                if (!consoleLogging) {
                    if (loggerContext.getMDCAdapter() == null) {
                        loggerContext.setMDCAdapter(MDC.getMDCAdapter());
                    }
                    loggerContext.getLogger(Config.class).info("Using '" + String.valueOf(logbackConfig) + "' as logback's configuration file");
                }
            } else {
                this.setupSaneDefault(loggerContext, null);
            }
            if (!consoleLogging) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
            }
        }
        catch (JoranException | MalformedURLException e) {
            this.setupSaneDefault(loggerContext, e);
        }
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }

    private URL getLogbackConfigFile() throws MalformedURLException {
        System.setProperty("logDestinationDirectory", Config.getLogsDirectory());
        File logbackInConf = Config.getUserLogfile();
        URL logbackUrl = logbackInConf.exists() ? logbackInConf.toURI().toURL() : Config.class.getClassLoader().getResource("com/ontotext/graphdb/default-logback.xml");
        return logbackUrl;
    }

    private URL getConsoleLogbackConfigFile() throws MalformedURLException {
        File logbackInConf = new File(Config.getConfDirectory(), "tools-logback.xml");
        if (logbackInConf.exists()) {
            return logbackInConf.toURI().toURL();
        }
        return Config.class.getClassLoader().getResource("com/ontotext/graphdb/default-tools-logback.xml");
    }

    private void setupSaneDefault(LoggerContext loggerContext, Throwable cause) {
        super.configure(loggerContext);
        Logger logger = loggerContext.getLogger(Config.class);
        logger.setLevel(Level.INFO);
        logger.warn("Could not configure logging using config file, falling back to console logging", cause);
    }
}

