/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import com.google.common.util.concurrent.AtomicDoubleArray;
import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.HashMultiset;
import graphql.com.google.common.collect.Multiset;
import graphql.com.google.common.collect.Multisets;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.EditorialCostForMapping;
import graphql.schema.diffing.FillupIsolatedVertices;
import graphql.schema.diffing.HungarianAlgorithm;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

@Internal
public class DiffImpl {
    private static final MappingEntry LAST_ELEMENT = new MappingEntry();
    private final SchemaGraph completeSourceGraph;
    private final SchemaGraph completeTargetGraph;
    private final FillupIsolatedVertices.IsolatedVertices isolatedVertices;
    private final SchemaDiffingRunningCheck runningCheck;

    public DiffImpl(SchemaGraph completeSourceGraph, SchemaGraph completeTargetGraph, FillupIsolatedVertices.IsolatedVertices isolatedVertices, SchemaDiffingRunningCheck runningCheck) {
        this.completeSourceGraph = completeSourceGraph;
        this.completeTargetGraph = completeTargetGraph;
        this.isolatedVertices = isolatedVertices;
        this.runningCheck = runningCheck;
    }

    OptimalEdit diffImpl(Mapping startMapping, List<Vertex> relevantSourceList, List<Vertex> relevantTargetList) throws Exception {
        int graphSize = relevantSourceList.size();
        ArrayList<EditOperation> initialEditOperations = new ArrayList<EditOperation>();
        int mappingCost = EditorialCostForMapping.editorialCostForMapping(startMapping, this.completeSourceGraph, this.completeTargetGraph, initialEditOperations);
        int level = startMapping.size();
        MappingEntry firstMappingEntry = new MappingEntry(startMapping, level, mappingCost);
        System.out.println("first entry: lower bound: " + mappingCost + " at level " + level);
        OptimalEdit optimalEdit = new OptimalEdit();
        PriorityQueue<MappingEntry> queue = new PriorityQueue<MappingEntry>((mappingEntry1, mappingEntry2) -> {
            int compareResult = Double.compare(mappingEntry1.lowerBoundCost, mappingEntry2.lowerBoundCost);
            if (compareResult == 0) {
                return Integer.compare(mappingEntry2.level, mappingEntry1.level);
            }
            return compareResult;
        });
        queue.add(firstMappingEntry);
        firstMappingEntry.siblingsFinished = true;
        while (!queue.isEmpty()) {
            MappingEntry mappingEntry = (MappingEntry)queue.poll();
            if (mappingEntry.lowerBoundCost >= (double)optimalEdit.ged) continue;
            if (mappingEntry.level > 0 && !mappingEntry.siblingsFinished) {
                this.addSiblingToQueue(mappingEntry.level, queue, optimalEdit, relevantSourceList, relevantTargetList, mappingEntry);
            }
            if (mappingEntry.level < graphSize) {
                this.addChildToQueue(mappingEntry, queue, optimalEdit, relevantSourceList, relevantTargetList);
            }
            this.runningCheck.check();
        }
        return optimalEdit;
    }

    private void addChildToQueue(MappingEntry parentEntry, PriorityQueue<MappingEntry> queue, OptimalEdit optimalEdit, List<Vertex> sourceList, List<Vertex> targetList) {
        int level = parentEntry.level;
        Mapping partialMapping = parentEntry.partialMapping;
        Assert.assertTrue(level == partialMapping.size());
        ArrayList<Vertex> availableTargetVertices = new ArrayList<Vertex>(targetList);
        availableTargetVertices.removeAll(partialMapping.getTargets());
        Assert.assertTrue(availableTargetVertices.size() + partialMapping.size() == targetList.size());
        Vertex v_i = sourceList.get(level);
        int costMatrixSize = sourceList.size() - level;
        AtomicDoubleArray[] costMatrixForHungarianAlgo = new AtomicDoubleArray[costMatrixSize];
        Arrays.setAll(costMatrixForHungarianAlgo, index -> new AtomicDoubleArray(costMatrixSize));
        AtomicDoubleArray[] costMatrix = new AtomicDoubleArray[costMatrixSize];
        Arrays.setAll(costMatrix, index -> new AtomicDoubleArray(costMatrixSize));
        LinkedHashSet<Vertex> partialMappingSourceSet = new LinkedHashSet<Vertex>(partialMapping.getSources());
        LinkedHashSet<Vertex> partialMappingTargetSet = new LinkedHashSet<Vertex>(partialMapping.getTargets());
        for (int i = level; i < sourceList.size(); ++i) {
            Vertex v = sourceList.get(i);
            int j = 0;
            for (Vertex u : availableTargetVertices) {
                double cost = this.calcLowerBoundMappingCost(v, u, partialMapping.getSources(), partialMappingSourceSet, partialMapping.getTargets(), partialMappingTargetSet);
                costMatrixForHungarianAlgo[i - level].set(j, cost);
                costMatrix[i - level].set(j, cost);
                ++j;
            }
            this.runningCheck.check();
        }
        HungarianAlgorithm hungarianAlgorithm = new HungarianAlgorithm(costMatrixForHungarianAlgo);
        int[] assignments = hungarianAlgorithm.execute();
        int editorialCostForMapping = EditorialCostForMapping.editorialCostForMapping(partialMapping, this.completeSourceGraph, this.completeTargetGraph, new ArrayList<EditOperation>());
        double costMatrixSum = this.getCostMatrixSum(costMatrix, assignments);
        double lowerBoundForPartialMapping = (double)editorialCostForMapping + costMatrixSum;
        int v_i_target_IndexSibling = assignments[0];
        Vertex bestExtensionTargetVertexSibling = availableTargetVertices.get(v_i_target_IndexSibling);
        Mapping newMappingSibling = partialMapping.extendMapping(v_i, bestExtensionTargetVertexSibling);
        if (lowerBoundForPartialMapping >= (double)optimalEdit.ged) {
            return;
        }
        MappingEntry newMappingEntry = new MappingEntry(newMappingSibling, level + 1, lowerBoundForPartialMapping);
        LinkedBlockingQueue<MappingEntry> siblings = new LinkedBlockingQueue<MappingEntry>();
        newMappingEntry.mappingEntriesSiblings = siblings;
        newMappingEntry.assignments = assignments;
        newMappingEntry.availableTargetVertices = availableTargetVertices;
        queue.add(newMappingEntry);
        Mapping fullMapping = partialMapping.copy();
        for (int i = 0; i < assignments.length; ++i) {
            fullMapping.add(sourceList.get(level + i), availableTargetVertices.get(assignments[i]));
        }
        ArrayList<EditOperation> editOperations = new ArrayList<EditOperation>();
        int costForFullMapping = EditorialCostForMapping.editorialCostForMapping(fullMapping, this.completeSourceGraph, this.completeTargetGraph, editOperations);
        this.updateOptimalEdit(optimalEdit, costForFullMapping, fullMapping, editOperations);
        this.calculateRestOfChildren(availableTargetVertices, hungarianAlgorithm, costMatrix, editorialCostForMapping, partialMapping, v_i, optimalEdit.ged, level + 1, siblings);
    }

    private void updateOptimalEdit(OptimalEdit optimalEdit, int newGed, Mapping mapping, List<EditOperation> editOperations) {
        if (newGed < optimalEdit.ged) {
            optimalEdit.ged = newGed;
            optimalEdit.listOfEditOperations.clear();
            optimalEdit.listOfEditOperations.add(editOperations);
            optimalEdit.listOfSets.clear();
            optimalEdit.listOfSets.add(new LinkedHashSet<EditOperation>(editOperations));
            optimalEdit.mappings.clear();
            optimalEdit.mappings.add(mapping);
            System.out.println("setting new best edit at level " + mapping.size() + " with size " + editOperations.size());
        } else if (newGed == optimalEdit.ged) {
            LinkedHashSet<EditOperation> newSet = new LinkedHashSet<EditOperation>(editOperations);
            for (Set<EditOperation> set : optimalEdit.listOfSets) {
                if (!set.equals(newSet)) continue;
                return;
            }
            optimalEdit.listOfSets.add(newSet);
            optimalEdit.listOfEditOperations.add(editOperations);
            optimalEdit.mappings.add(mapping);
        }
    }

    private void calculateRestOfChildren(List<Vertex> availableTargetVertices, HungarianAlgorithm hungarianAlgorithm, AtomicDoubleArray[] costMatrixCopy, double editorialCostForMapping, Mapping partialMapping, Vertex v_i, int upperBound, int level, LinkedBlockingQueue<MappingEntry> siblings) {
        int[] assignments;
        for (int child = 1; child < availableTargetVertices.size() && hungarianAlgorithm.costMatrix[0].get((assignments = hungarianAlgorithm.nextChild())[0]) != 2.147483647E9; ++child) {
            double costMatrixSumSibling = this.getCostMatrixSum(costMatrixCopy, assignments);
            double lowerBoundForPartialMappingSibling = editorialCostForMapping + costMatrixSumSibling;
            int v_i_target_IndexSibling = assignments[0];
            Vertex bestExtensionTargetVertexSibling = availableTargetVertices.get(v_i_target_IndexSibling);
            Mapping newMappingSibling = partialMapping.extendMapping(v_i, bestExtensionTargetVertexSibling);
            if (lowerBoundForPartialMappingSibling >= (double)upperBound) break;
            MappingEntry sibling = new MappingEntry(newMappingSibling, level, lowerBoundForPartialMappingSibling);
            sibling.mappingEntriesSiblings = siblings;
            sibling.assignments = assignments;
            sibling.availableTargetVertices = availableTargetVertices;
            siblings.add(sibling);
            this.runningCheck.check();
        }
        siblings.add(LAST_ELEMENT);
    }

    private void addSiblingToQueue(int level, PriorityQueue<MappingEntry> queue, OptimalEdit optimalEdit, List<Vertex> sourceList, List<Vertex> targetGraph, MappingEntry mappingEntry) throws InterruptedException {
        MappingEntry sibling = mappingEntry.mappingEntriesSiblings.take();
        if (sibling == LAST_ELEMENT) {
            mappingEntry.siblingsFinished = true;
            return;
        }
        if (sibling.lowerBoundCost < (double)optimalEdit.ged) {
            queue.add(sibling);
            Mapping fullMapping = sibling.partialMapping.removeLastElement();
            for (int i = 0; i < sibling.assignments.length; ++i) {
                fullMapping.add(sourceList.get(level - 1 + i), sibling.availableTargetVertices.get(sibling.assignments[i]));
            }
            ArrayList<EditOperation> editOperations = new ArrayList<EditOperation>();
            int costForFullMapping = EditorialCostForMapping.editorialCostForMapping(fullMapping, this.completeSourceGraph, this.completeTargetGraph, editOperations);
            this.updateOptimalEdit(optimalEdit, costForFullMapping, fullMapping, editOperations);
        }
    }

    private double getCostMatrixSum(AtomicDoubleArray[] costMatrix, int[] assignments) {
        double costMatrixSum = 0.0;
        for (int i = 0; i < assignments.length; ++i) {
            costMatrixSum += costMatrix[i].get(assignments[i]);
        }
        return costMatrixSum;
    }

    private double calcLowerBoundMappingCost(Vertex v, Vertex u, List<Vertex> partialMappingSourceList, Set<Vertex> partialMappingSourceSet, List<Vertex> partialMappingTargetList, Set<Vertex> partialMappingTargetSet) {
        if (!this.isolatedVertices.mappingPossible(v, u)) {
            return 2.147483647E9;
        }
        boolean equalNodes = v.getType().equals(u.getType()) && v.getProperties().equals(u.getProperties());
        List<Edge> adjacentEdgesV = this.completeSourceGraph.getAdjacentEdges(v);
        HashMultiset<String> multisetLabelsV = HashMultiset.create();
        for (Edge edge : adjacentEdgesV) {
            if (partialMappingSourceSet.contains(edge.getFrom()) || partialMappingSourceSet.contains(edge.getTo())) continue;
            multisetLabelsV.add(edge.getLabel());
        }
        List<Edge> adjacentEdgesU = this.completeTargetGraph.getAdjacentEdges(u);
        HashMultiset<String> multisetLabelsU = HashMultiset.create();
        for (Edge edge : adjacentEdgesU) {
            if (partialMappingTargetSet.contains(edge.getFrom()) || partialMappingTargetSet.contains(edge.getTo())) continue;
            multisetLabelsU.add(edge.getLabel());
        }
        int anchoredVerticesCost = 0;
        for (int i = 0; i < partialMappingSourceList.size(); ++i) {
            String labelTargetEdgeInverse;
            Edge sourceEdgeInverse;
            String labelTargetEdge;
            Vertex vPrime = partialMappingSourceList.get(i);
            Vertex mappedVPrime = partialMappingTargetList.get(i);
            Edge sourceEdge = this.completeSourceGraph.getEdge(v, vPrime);
            String labelSourceEdge = sourceEdge != null ? sourceEdge.getLabel() : null;
            Edge targetEdge = this.completeTargetGraph.getEdge(u, mappedVPrime);
            String string = labelTargetEdge = targetEdge != null ? targetEdge.getLabel() : null;
            if (!Objects.equals(labelSourceEdge, labelTargetEdge)) {
                ++anchoredVerticesCost;
            }
            String labelSourceEdgeInverse = (sourceEdgeInverse = this.completeSourceGraph.getEdge(vPrime, v)) != null ? sourceEdgeInverse.getLabel() : null;
            Edge targetEdgeInverse = this.completeTargetGraph.getEdge(mappedVPrime, u);
            String string2 = labelTargetEdgeInverse = targetEdgeInverse != null ? targetEdgeInverse.getLabel() : null;
            if (!Objects.equals(labelSourceEdgeInverse, labelTargetEdgeInverse)) {
                ++anchoredVerticesCost;
            }
            this.runningCheck.check();
        }
        Multiset intersection = Multisets.intersection(multisetLabelsV, multisetLabelsU);
        int multiSetEditDistance = Math.max(multisetLabelsV.size(), multisetLabelsU.size()) - intersection.size();
        double result = (equalNodes ? 0 : 1) + multiSetEditDistance + anchoredVerticesCost;
        return result;
    }

    private List<String> getDebugMap(Mapping mapping) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : mapping.getMap().entrySet()) {
            result.add(((Vertex)entry.getKey()).getDebugName() + "->" + ((Vertex)entry.getValue()).getDebugName());
        }
        return result;
    }

    public static class OptimalEdit {
        public List<Mapping> mappings = new ArrayList<Mapping>();
        public List<List<EditOperation>> listOfEditOperations = new ArrayList<List<EditOperation>>();
        public List<Set<EditOperation>> listOfSets = new ArrayList<Set<EditOperation>>();
        public int ged = Integer.MAX_VALUE;

        public OptimalEdit() {
        }

        public OptimalEdit(List<Mapping> mappings, List<List<EditOperation>> listOfEditOperations, int ged) {
            this.mappings = mappings;
            this.listOfEditOperations = listOfEditOperations;
            this.ged = ged;
        }
    }

    private static class MappingEntry {
        public boolean siblingsFinished;
        public LinkedBlockingQueue<MappingEntry> mappingEntriesSiblings;
        public int[] assignments;
        public List<Vertex> availableTargetVertices;
        Mapping partialMapping = new Mapping();
        int level;
        double lowerBoundCost;

        public MappingEntry(Mapping partialMapping, int level, double lowerBoundCost) {
            this.partialMapping = partialMapping;
            this.level = level;
            this.lowerBoundCost = lowerBoundCost;
        }

        public MappingEntry() {
        }
    }
}

