/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.tasks.processing.TaskProviderCallback;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class TaskProvider<T> {
    private final int concurrencyLevel;
    private final TaskProviderCallback<T> taskProviderCallback;
    private Deque<T> tasks = new LinkedList<T>();
    private Set<T> doneTasks = new LinkedHashSet<T>();
    private boolean isDone = false;
    private int loadedTasksCount;

    TaskProvider(int concurrencyLevel, TaskProviderCallback<T> taskProviderCallback) {
        this.concurrencyLevel = concurrencyLevel;
        this.taskProviderCallback = taskProviderCallback;
    }

    public synchronized T getNextTask() {
        T task = this.tasks.pollFirst();
        if (task == null) {
            this.loadMoreTasks();
            task = this.tasks.pollFirst();
        }
        return task;
    }

    public synchronized void doneWithTask(T task) {
        this.doneTasks.add(task);
        if (this.doneTasks.size() >= this.loadedTasksCount || this.isDone) {
            this.taskProviderCallback.updateTasks(new ArrayList<T>(this.doneTasks));
            this.doneTasks.clear();
        }
    }

    private void loadMoreTasks() {
        if (this.isDone) {
            return;
        }
        this.tasks = new LinkedList<T>(this.taskProviderCallback.getNextTasks(this.concurrencyLevel));
        this.loadedTasksCount = this.tasks.size();
        this.isDone = this.tasks.isEmpty();
    }
}

