/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.util.RetryExecutionException;
import com.ontotext.soaas.util.RetryingOperation;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskProvider;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;

public class RetryingTaskDispatcher<T extends Task, D extends DataEndpoint>
implements TaskDispatcher<T, D> {
    private static final Logger LOGGER = Loggers.tasksLogger();
    private static final long DELAY_BEFORE_RETRY = TimeUnit.SECONDS.toMillis(5L);
    private final TaskDispatcher<T, D> delegate;
    private final long retryDelay;

    public RetryingTaskDispatcher(TaskDispatcher<T, D> delegate) {
        this(delegate, DELAY_BEFORE_RETRY);
    }

    public RetryingTaskDispatcher(TaskDispatcher<T, D> delegate, long retryDelay) {
        this.delegate = delegate;
        this.retryDelay = retryDelay;
    }

    @Override
    public void dispatch(T task, D dataEndpoint, JobContext jobContext) {
        Runnable runnable = () -> this.delegate.dispatch((Task)task, dataEndpoint, jobContext);
        this.invokeRetrying(runnable, this.rethrowOrRetry());
    }

    @Override
    public T getNextTask(TaskProvider<T> provider) {
        AtomicReference taskCollector = new AtomicReference();
        this.invokeRetrying(() -> taskCollector.set(this.delegate.getNextTask(provider)), this.logAndRetry("loading task"));
        return (T)((Task)taskCollector.get());
    }

    @Override
    public void doneWithTask(TaskProvider<T> provider, T task) {
        this.invokeRetrying(() -> this.delegate.doneWithTask((TaskProvider<Task>)provider, (Task)task), this.logAndRetry("task update"));
    }

    private void invokeRetrying(Runnable runnable, Consumer<RuntimeException> onException) {
        new RetryingOperation(runnable, 0L, this.retryDelay, -1, onException).run();
    }

    private Consumer<RuntimeException> rethrowOrRetry() {
        return ex -> {
            if (ex instanceof IllegalMonitorStateException) {
                LOGGER.info("Task execution failed. Will try again soon...");
                throw new RetryExecutionException();
            }
            if (ex instanceof RepositoryException) {
                LOGGER.info("Task execution failed due to communication failure: {}. Will try again soon...", (Object)ex.getMessage());
                throw new RetryExecutionException();
            }
            throw ex;
        };
    }

    private Consumer<RuntimeException> logAndRetry(String message) {
        return ex -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrying {} due to:", (Object)message, ex);
            } else {
                LOGGER.info("Retrying {} due to: {}", (Object)message, (Object)ex.getMessage());
            }
            throw new RetryExecutionException();
        };
    }
}

