/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.TaskProcessor;
import com.ontotext.tasks.processing.AsyncTaskEvaluator;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskEvaluator;
import com.ontotext.tasks.processing.TaskProvider;
import com.ontotext.tasks.processing.TaskProviderCallback;
import com.ontotext.tasks.processing.TaskRunner;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;

public class ConcurrentTaskProcessor
implements TaskProcessor {
    private final DataEndpointProvider dataEndpoint;
    private final TaskEvaluator taskEvaluator;
    private final int tasksPerValidationJob;
    private Map<String, List<Pair<Future<?>, TaskRunner<?, ?>>>> activeTasks = new ConcurrentHashMap();

    public ConcurrentTaskProcessor(int tasksPerJob, int maxConcurrentTasks, DataEndpointProvider dataEndpoint) {
        this(tasksPerJob, new AsyncTaskEvaluator(tasksPerJob * maxConcurrentTasks), dataEndpoint);
    }

    public ConcurrentTaskProcessor(int tasksPerJob, TaskEvaluator taskEvaluator, DataEndpointProvider dataEndpoint) {
        this.tasksPerValidationJob = tasksPerJob;
        this.taskEvaluator = taskEvaluator;
        this.dataEndpoint = dataEndpoint;
    }

    @Override
    public <T extends Task> void start(JobContext jobContext, TaskProviderCallback<T> taskProviderCallback, TaskDispatcher<T, DataEndpoint> taskDispatcher) {
        TaskProvider<T> taskProvider = new TaskProvider<T>(this.tasksPerValidationJob, taskProviderCallback);
        if (jobContext.isSyncEvent()) {
            new TaskRunner<T, DataEndpoint>(taskProvider, this.dataEndpoint.getDataEndpoint(jobContext.getRepository()), taskDispatcher, jobContext, null).run();
            return;
        }
        for (int i = 0; i < this.tasksPerValidationJob; ++i) {
            TaskRunner<T, DataEndpoint> taskRunner = new TaskRunner<T, DataEndpoint>(taskProvider, this.dataEndpoint.getDataEndpoint(jobContext.getRepository()), taskDispatcher, jobContext, this::onJobComplete);
            Future<?> future = this.taskEvaluator.submitTask(taskRunner);
            this.activeTasks.computeIfAbsent(jobContext.getJobId(), id -> new LinkedList()).add(Pair.of(future, taskRunner));
        }
    }

    private void onJobComplete(JobContext jobContext) {
        this.activeTasks.remove(jobContext.getJobId());
    }

    @Override
    public void stop(String jobId, boolean forced) {
        List<Pair<Future<?>, TaskRunner<?, ?>>> jobFutures = this.activeTasks.remove(jobId);
        if (jobFutures != null) {
            this.stopRunners(forced, jobFutures);
        }
    }

    @Override
    public synchronized void stop(boolean forced) {
        for (List<Pair<Future<?>, TaskRunner<?, ?>>> futures : this.activeTasks.values()) {
            this.stopRunners(forced, futures);
        }
        this.activeTasks.clear();
    }

    private void stopRunners(boolean forced, List<Pair<Future<?>, TaskRunner<?, ?>>> jobFutures) {
        for (Pair<Future<?>, TaskRunner<?, ?>> jobFuture : jobFutures) {
            ((Future)jobFuture.getLeft()).cancel(forced);
            if (!forced) continue;
            ((TaskRunner)jobFuture.getRight()).waitUntilDone();
        }
    }
}

