/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks;

import com.google.common.collect.ImmutableSet;
import com.ontotext.repository.http.HttpUtils;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.HealthCheckable;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.exceptions.InvalidConfigurationException;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.TaskProcessor;
import com.ontotext.tasks.TaskProcessorFactory;
import com.ontotext.tasks.processing.AsyncTaskEvaluator;
import com.ontotext.tasks.processing.ConcurrentTaskProcessor;
import com.ontotext.tasks.processing.SequentialTaskProcessor;
import com.ontotext.tasks.processing.TaskEvaluator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GraphDbTaskProcessorFactory
implements TaskProcessorFactory,
HealthCheckable {
    private static final Logger LOGGER = Loggers.tasksLogger();
    private static final int MAX_CONCURRENT_TASKS_PER_VALIDATION = 32;
    private static final int MAX_VALIDATION_JOBS = 10;
    private static final String NAME = "validation-task-processor-factory";
    private final EndpointProvider endpointProvider;
    private final SparqlConnectionFactory connectionFactory;
    private final int jobsPerValidation;
    private final int maxValidationJobs;
    private Mode currentMode;
    private TaskEvaluator taskEvaluator;

    public GraphDbTaskProcessorFactory(EndpointProvider endpointProvider, SparqlConnectionFactory connectionFactory, int jobsPerValidation, int maxValidationJobs) {
        this.endpointProvider = endpointProvider;
        this.connectionFactory = connectionFactory;
        this.jobsPerValidation = Math.max(Math.min(jobsPerValidation, 32), 1);
        this.maxValidationJobs = Math.max(Math.min(maxValidationJobs, 10), 1);
    }

    @Override
    public TaskProcessor createProcessor() {
        Mode mode = this.getEndpointMode();
        if (mode == null) {
            LOGGER.warn("Could not determine repository type for: {}", (Object)this.endpointProvider.getEndpoint());
        } else if (mode == Mode.CONCURRENT) {
            LOGGER.debug("Creating concurrent validation processor with {} concurrent validators and {} active validations at a time", (Object)this.jobsPerValidation, (Object)this.maxValidationJobs);
            return new ConcurrentTaskProcessor(this.jobsPerValidation, this.getTaskEvaluator(mode), this.getValidationDataEndpointProvider());
        }
        LOGGER.debug("Creating sequential validation processor");
        return new SequentialTaskProcessor(this.getTaskEvaluator(mode), this.getValidationDataEndpointProvider());
    }

    private synchronized TaskEvaluator getTaskEvaluator(Mode mode) {
        if (this.taskEvaluator == null) {
            this.taskEvaluator = mode == Mode.SINGLE ? new AsyncTaskEvaluator(1) : new AsyncTaskEvaluator(this.jobsPerValidation * this.maxValidationJobs);
        }
        return this.taskEvaluator;
    }

    @NotNull
    private DataEndpointProvider getValidationDataEndpointProvider() {
        return DataEndpointProvider.create(this.endpointProvider, this.connectionFactory);
    }

    protected synchronized Mode getEndpointMode() {
        if (this.currentMode == null) {
            SparqlEndpoint endpoint = (SparqlEndpoint)this.endpointProvider.getEndpoint();
            try (CloseableHttpClient httpClient = GraphDbTaskProcessorFactory.getHttpClient(endpoint);){
                this.currentMode = GraphDbTaskProcessorFactory.getMode(httpClient, endpoint);
            }
            catch (IOException io) {
                throw this.createNetworkException(endpoint.getAddress());
            }
        }
        return this.currentMode;
    }

    @Nullable
    private static Mode getMode(CloseableHttpClient httpClient, SparqlEndpoint endpoint) {
        Mode mode = null;
        for (String address : HttpUtils.getAddresses((SparqlEndpoint)endpoint)) {
            Mode checkResponse = GraphDbTaskProcessorFactory.checkEndpoint(httpClient, address, endpoint);
            if (checkResponse == null) continue;
            if (mode == null) {
                mode = checkResponse;
            }
            if (checkResponse == Mode.OTHER) continue;
            break;
        }
        return mode;
    }

    private static Mode checkEndpoint(CloseableHttpClient httpClient, String address, SparqlEndpoint endpoint) {
        try {
            HttpUriRequest repositoryConfigRequest = HttpUtils.newHttpRequest((String)address, (SparqlEndpoint)endpoint);
            CloseableHttpResponse response = httpClient.execute(repositoryConfigRequest);
            GraphDbTaskProcessorFactory.checkResponseStatus((HttpResponse)response, endpoint);
            JSONObject jsonObject = new JSONObject(HttpUtils.getResponseAsString((HttpResponse)response));
            Optional<String> type = GraphDbTaskProcessorFactory.getType(jsonObject);
            return type.map(Mode::parse).orElse(Mode.OTHER);
        }
        catch (IOException io) {
            return null;
        }
        catch (URISyntaxException use) {
            throw new InvalidConfigurationException(use.getMessage(), ErrorCode.BAD_CONFIG_INVALID_GRAPHDB_ADDRESS);
        }
        catch (JSONException je) {
            LOGGER.error("Unexpected response from {}", (Object)address, (Object)je);
            return Mode.OTHER;
        }
    }

    private static Optional<String> getType(JSONObject jsonObject) {
        return Optional.ofNullable(jsonObject.optString("type", null));
    }

    private static void checkResponseStatus(HttpResponse response, SparqlEndpoint endpoint) throws IOException {
        PlatformConfigurationException breakingPce = HttpUtils.checkRepositoryResponseValidity((HttpResponse)response, (String)GraphDbTaskProcessorFactory.getRepositoryAddress(endpoint));
        if (breakingPce != null) {
            throw breakingPce;
        }
    }

    @NotNull
    private PlatformConfigurationException createNetworkException(String address) {
        return new PlatformConfigurationException(String.format("Could not connect to %s, check network settings", address), ErrorCode.BAD_CONFIG_GRAPHDB_UNREACHABLE);
    }

    private static String getRepositoryAddress(SparqlEndpoint endpoint) {
        return String.format("Repository: %s at address %s", endpoint.getRepository(), endpoint.getAddress());
    }

    @NotNull
    private static CloseableHttpClient getHttpClient(SparqlEndpoint endpoint) {
        return HttpUtils.buildClient((SparqlEndpoint)endpoint).setDefaultHeaders(null).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HealthResult runHealthCheck() {
        SparqlEndpoint healthEndpoint = (SparqlEndpoint)this.endpointProvider.getHealthEndpoint();
        if (StringUtils.isBlank((CharSequence)healthEndpoint.getAddress())) {
            return HealthResult.green((String)NAME);
        }
        try (CloseableHttpClient httpClient = GraphDbTaskProcessorFactory.getHttpClient(healthEndpoint);){
            if (GraphDbTaskProcessorFactory.getMode(httpClient, healthEndpoint) != null) {
                HealthResult healthResult2 = HealthResult.green((String)NAME);
                return healthResult2;
            }
            HealthResult healthResult = new HealthResult(NAME, HealthResult.Status.RED, "Could not determine repository type!");
            return healthResult;
        }
        catch (IOException io) {
            return new HealthResult(NAME, HealthResult.Status.RED, io.getMessage());
        }
    }

    public static enum Mode {
        SINGLE("free", "se"),
        CONCURRENT("master", "worker", "graphdb"),
        OTHER(new String[0]);

        private final Set<String> types;

        private Mode(String ... types) {
            this.types = ImmutableSet.copyOf((Object[])types);
        }

        public Set<String> getTypes() {
            return this.types;
        }

        public static Mode parse(String repoType) {
            for (Mode mode : Mode.values()) {
                if (!mode.getTypes().contains(repoType)) continue;
                return mode;
            }
            return OTHER;
        }
    }
}

