/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks;

import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.TaskProcessor;
import com.ontotext.tasks.TaskProcessorFactory;
import com.ontotext.tasks.job.JobEvent;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.tasks.job.JobNotifiable;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.RetryingTaskDispatcher;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskProviderCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class BaseTaskService<T extends Task>
implements JobListener {
    protected static final Logger LOGGER = Loggers.tasksLogger();
    private final TaskProcessorFactory taskProcessorFactory;
    private final Function<String, JobContext> jobContextLoader;
    private Map<String, TaskProcessor> activeProcessors = new ConcurrentHashMap<String, TaskProcessor>();
    private TaskDispatcher<T, DataEndpoint> taskDispatcher;

    public BaseTaskService(JobNotifiable notifiable, TaskProcessorFactory taskProcessorFactory, Function<String, JobContext> jobContextLoader) {
        this.taskProcessorFactory = taskProcessorFactory;
        this.jobContextLoader = jobContextLoader;
        notifiable.addJobListener(this);
    }

    public void startJob(String jobId, String repository, boolean sync) {
        if (this.activeProcessors.containsKey(jobId)) {
            LOGGER.info("Tried to start job while one is currently running for: {}", (Object)jobId);
            return;
        }
        LOGGER.info("Requested indexing of {}", (Object)jobId);
        TaskProcessor processor = this.taskProcessorFactory.createProcessor();
        TaskProcessor previousProcessor = this.activeProcessors.put(jobId, processor);
        if (previousProcessor != null) {
            previousProcessor.stop(true);
        }
        JobContext jobContext = this.jobContextLoader.apply(jobId);
        jobContext.setSyncEvent(sync);
        jobContext.setRepository(repository);
        processor.start(jobContext, this.getTaskProviderCallback(jobId), this.buildDispatcher());
    }

    protected TaskDispatcher<T, DataEndpoint> buildDispatcher() {
        if (this.taskDispatcher == null) {
            this.taskDispatcher = this.createNewDispatcher();
        }
        if (this.taskDispatcher instanceof RetryingTaskDispatcher) {
            return this.taskDispatcher;
        }
        return new RetryingTaskDispatcher<T, DataEndpoint>(this.taskDispatcher);
    }

    protected abstract TaskDispatcher<T, DataEndpoint> createNewDispatcher();

    @NotNull
    protected abstract TaskProviderCallback<T> getTaskProviderCallback(String var1);

    public void stopJob(String schemaId, boolean forced) {
        TaskProcessor processor = this.activeProcessors.remove(schemaId);
        if (processor != null) {
            LOGGER.info("Stopping job: {}, forced={}", (Object)schemaId, (Object)forced);
            processor.stop(schemaId, forced);
        }
    }

    @Override
    public void onEvent(JobEvent jobEvent) {
        LOGGER.info("New event for Job({}) in {}", (Object)jobEvent.getSchemaId(), (Object)jobEvent.getEventType());
        switch (jobEvent.getEventType()) {
            case NEW_JOB: 
            case JOB_RESUMED: {
                this.startJob(jobEvent.getSchemaId(), jobEvent.getRepository(), jobEvent.isSync());
                break;
            }
            case JOB_COMPLETED: {
                this.stopJob(jobEvent.getSchemaId(), false);
                break;
            }
            case JOB_REMOVED: 
            case JOB_CANCELED: {
                this.stopJob(jobEvent.getSchemaId(), true);
                break;
            }
        }
    }

    public TaskDispatcher<T, DataEndpoint> getTaskDispatcher() {
        return this.taskDispatcher;
    }

    public void setTaskDispatcher(TaskDispatcher<T, DataEndpoint> taskDispatcher) {
        this.taskDispatcher = taskDispatcher;
    }
}

