/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.graphdb.fedx.GraphDBFedXRepositoryConfig;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import java.util.Collection;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.SparqlEndpointConfiguration;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class RepositoryUtils {
    public static boolean isOntopRepository(SemanticRepository repo, SemanticLocation location) {
        return RepositoryUtils.isOntopRepository(repo.getRepository(), location, repo.getRepositoryID());
    }

    public static boolean isOntopRepository(Repository repo, SemanticLocation location, String repoId) {
        if (location.isLocal()) {
            return repo instanceof OntopRepository;
        }
        RepositoryImplConfig repositoryImplConfig = location.getRepositoryConfiguration(repoId).getRepositoryImplConfig();
        return repositoryImplConfig.getType().equals("graphdb:OntopRepository");
    }

    public static boolean isFedXWithSPARQLEndpoint(SemanticRepository semanticRepository, SemanticLocation semanticLocation) {
        return RepositoryUtils.isFedXWithSPARQLEndpoint(semanticRepository.getRepository(), semanticLocation, semanticRepository.getRepositoryID());
    }

    public static boolean isFedXWithSPARQLEndpoint(Repository repo, SemanticLocation semanticLocation, String repoId) {
        if (semanticLocation.isLocal()) {
            FedXRepository fedXRepository = null;
            if (repo instanceof RepositoryWrapper && ((RepositoryWrapper)repo).getDelegate() instanceof FedXRepository) {
                fedXRepository = (FedXRepository)((RepositoryWrapper)repo).getDelegate();
            }
            if (repo instanceof FedXRepository) {
                fedXRepository = (FedXRepository)repo;
            }
            if (fedXRepository != null) {
                Collection availableEndpoints = fedXRepository.getFederationContext().getEndpointManager().getAvailableEndpoints();
                for (Endpoint e : availableEndpoints) {
                    if (!(e.getEndpointConfiguration() instanceof SparqlEndpointConfiguration)) continue;
                    return true;
                }
            }
        } else {
            RepositoryImplConfig repositoryImplConfig = semanticLocation.getRepositoryConfiguration(repoId).getRepositoryImplConfig();
            if (repositoryImplConfig.getType().equals("graphdb:FedXRepository")) {
                SimpleValueFactory VF = SimpleValueFactory.getInstance();
                return ((GraphDBFedXRepositoryConfig)repositoryImplConfig).getMembers().contains(null, VF.createIRI("http://rdf4j.org/config/federation#store"), (Value)VF.createLiteral("SPARQLEndpoint"), new Resource[0]);
            }
        }
        return false;
    }

    public static boolean isFedXRepository(SemanticRepository semanticRepository, SemanticLocation semanticLocation) {
        if (semanticLocation.isLocal()) {
            Repository repo = semanticRepository.getRepository();
            if (repo instanceof RepositoryWrapper && ((RepositoryWrapper)repo).getDelegate() instanceof FedXRepository) {
                return true;
            }
            return repo instanceof FedXRepository;
        }
        RepositoryImplConfig repositoryImplConfig = semanticLocation.getRepositoryConfiguration(semanticRepository.getRepositoryID()).getRepositoryImplConfig();
        return repositoryImplConfig.getType().equals("graphdb:FedXRepository");
    }
}

