/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.config.AbstractParameter;
import com.ontotext.config.RepositoryTemplateParameters;
import com.ontotext.forest.core.GraphDBMultipartFile;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.graphdb.RepositorySizeInfo;
import com.ontotext.forest.core.proxy.AltBodyHttpServletRequest;
import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.proxy.SkipParametersHttpServletRequest;
import com.ontotext.forest.core.semantic.LastRunSemanticStateHelper;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.forest.repositories.DummyRepositoryConnection;
import com.ontotext.forest.repositories.GraphDBRepositoriesService;
import com.ontotext.forest.repositories.OwlimParameter;
import com.ontotext.forest.repositories.RepositoryConfigBean;
import com.ontotext.forest.repositories.UploadFileResult;
import com.ontotext.forest.repositories.model.GraphDBRepository;
import com.ontotext.forest.repositories.ontop.JDBCPropertiesFileBean;
import com.ontotext.forest.repositories.ontop.JdbcDriver;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.trree.AbstractInferencer;
import com.ontotext.trree.rules.RuleCompilerException;
import com.ontotext.trree.rules.RuntimeInferencerCompiler;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.WebUtils;

@RequestMapping(value={"/rest/repositories"})
@Controller
@Tag(name="Repository Management", description="Manage repositories")
public class RepositoryManagementController {
    public static final String REST_REPOSITORIES_URL = "/rest/repositories";
    public static final String REPOSITORY_ID_NAME = "repositoryID";
    public static final String REPOSITORY_ID_PATH_STRING = "/{repositoryID}";
    public static final String TURTLE_MIME_TYPE = "text/turtle";
    public static final String APPLICATION_ZIP_MIME_TYPE = "application/zip";
    public static final String ONTOP_OWL_FILE = "owlFile";
    public static final String ONTOP_OBDA_FILE = "obdaFile";
    private static final String ONTOP_PROPERTIES_FILE = "propertiesFile";
    public static final String ONTOP_CONSTRAINT_FILE = "constraintFile";
    public static final String ONTOP_DB_METADATA_FILE = "dbMetadataFile";
    public static final String ONTOP_LENSES_FILE = "lensesFile";
    private static final String[] ONTOP_PARAMS = new String[]{"obdaFile", "owlFile", "propertiesFile", "constraintFile", "dbMetadataFile", "lensesFile"};
    private static final String REPOSITORIES_DIR = "repositories";
    private static final Set<String> FORBIDDEN_EXTENSIONS = Set.of(".jar", ".jsp", ".exe", ".sh", ".bat", ".php", ".cmd");
    private static final String FILE_LOCATION_REQUEST_PARAM = "fileLocation";
    public static final String TMP_STRING = "tmp";
    private final Logger logger = LoggerFactory.getLogger(RepositoryManagementController.class);
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private SemanticLocationManagement locationManagement;
    @Autowired
    private GraphDBRepositoriesService service;
    @Autowired
    private LastRunSemanticStateHelper lastRunSemanticStateHelper;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TypeReference<List<GraphDBRepository>> listOfRepoType = new TypeReference<List<GraphDBRepository>>(this){};
    private Class<?> inferencerClass;

    @Operation(summary="Create a repository in an attached RDF4J location", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<?> createRepository(final @Parameter(description="A ttl configuration file for the repository") @RequestParam(name="config") MultipartFile config, final @Parameter(description="An OBDA (Ontology-Based Data Access) file") @RequestParam(name="obdaFile", required=false) MultipartFile obdafile, final @Parameter(description="An OWL (Web Ontology Language) format file") @RequestParam(name="owlFile", required=false) MultipartFile owlFile, final @Parameter(description="A configuration properties file") @RequestParam(name="propertiesFile", required=false) MultipartFile propertiesFile, final @Parameter(description="An OBDA constraint file") @RequestParam(name="constraintFile", required=false) MultipartFile constraintFile, final @Parameter(description="A database metadata file") @RequestParam(name="dbMetadataFile", required=false) MultipartFile dbMetadataFile, final @Parameter(description="A lens definitions file") @RequestParam(name="lensesFile", required=false) MultipartFile lensesFile, @Parameter(description="Sesame location") @RequestParam(required=false) @Nullable String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        return this.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            SemanticLocation semanticLocation2 = semanticLocation;
            Objects.requireNonNull(semanticLocation2);
            new SemanticLocation.WithManagerInitalization<Void>(semanticLocation2){

                protected Void doWithManager(RepositoryManager manager) {
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(config.getBytes());){
                        RepositoryConfig repositoryConfig = semanticLocation.getRepositoryConfig(bis);
                        RepositoryManagementController.this.saveFile(obdafile, repositoryConfig.getID(), semanticLocation);
                        RepositoryManagementController.this.saveFile(owlFile, repositoryConfig.getID(), semanticLocation);
                        RepositoryManagementController.this.saveFile(propertiesFile, repositoryConfig.getID(), semanticLocation);
                        RepositoryManagementController.this.saveFile(constraintFile, repositoryConfig.getID(), semanticLocation);
                        RepositoryManagementController.this.saveFile(dbMetadataFile, repositoryConfig.getID(), semanticLocation);
                        RepositoryManagementController.this.saveFile(lensesFile, repositoryConfig.getID(), semanticLocation);
                        semanticLocation.createRepository(repositoryConfig);
                    }
                    catch (IOException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    return null;
                }
            }.run();
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        });
    }

    @PostMapping(consumes={"application/json"})
    @Operation(summary="Create a repository in an attached RDF4J location", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> createRepository(final @Validated @RequestBody RepositoryConfigBean bean, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (bean.getType().equals("fedx") && !bean.getParams().containsKey("member")) {
            throw new GraphDBWorkbenchException("A FedX repo should be created with at least one member");
        }
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(bean.getLocation());
        return this.proxyWithBodyToRemoteIfNeeded(bean, request, response, semanticLocation, () -> {
            if (StringUtils.isBlank((CharSequence)bean.getId())) {
                return new ResponseEntity((Object)"Repository id cannot be blank!", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (semanticLocation.containsRepository(bean.getId())) {
                return new ResponseEntity((Object)String.format("Repository %s already exists.", bean.getId()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (semanticLocation.containsRepository(bean.getId())) {
                return new ResponseEntity((Object)String.format("Repository %s already exists.", bean.getId()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.processUploadedRulesetFile(bean.getParams().get("ruleset"), bean.getId(), semanticLocation);
            SemanticLocation semanticLocation2 = semanticLocation;
            Objects.requireNonNull(semanticLocation2);
            new SemanticLocation.WithManagerInitalization<Void>(semanticLocation2){

                protected Void doWithManager(RepositoryManager manager) throws IOException {
                    RepositoryConfig config = RepositoryManagementController.this.createAndValidateRepositoryConfig(bean, semanticLocation);
                    try {
                        semanticLocation.createRepository(config);
                    }
                    catch (Exception e) {
                        RepositoryManagementController.this.rollbackRepositoryCreation(config.getID(), semanticLocation);
                        throw e;
                    }
                    return null;
                }
            }.run();
            return this.validateRuleset(bean, semanticLocation);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEntity<?> validateRuleset(RepositoryConfigBean bean, SemanticLocation semanticLocation) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, IOException {
        if (bean.getType().equals("graphdb") && this.inferencerClass != null) {
            Constructor<?> constructor = this.inferencerClass.getConstructor(new Class[0]);
            AbstractInferencer infer = (AbstractInferencer)constructor.newInstance(new Object[0]);
            infer.setInferStatementsFlag(false);
            infer.setRuleset(bean.getParams().get("ruleset").getValueString());
            infer.setUseSameAsOptimization(!bean.getParams().get("disableSameAs").getValueString().equals("true"));
            infer.setRepositoryConnection(DummyRepositoryConnection.createDummyRepositoryConnection());
            infer.setConfigParams(bean.toConfigParameters());
            File tmpFolder = WebUtils.getTempDir((ServletContext)RequestUtils.getServletContext());
            File tmpRulesetFolder = new File(String.valueOf(tmpFolder) + "/customRulesetDir");
            Path tmpRulesetFolderPath = Path.of(tmpRulesetFolder.getAbsolutePath(), new String[0]);
            if (!Files.exists(tmpRulesetFolderPath, new LinkOption[0])) {
                Files.createDirectory(tmpRulesetFolderPath, new FileAttribute[0]);
            }
            infer.setWorkDir(tmpRulesetFolder);
            boolean isExceptionThrown = false;
            try {
                infer.initialize();
            }
            catch (Exception e) {
                isExceptionThrown = true;
                semanticLocation.removeRepository(bean.getId());
                ResponseEntity responseEntity = new ResponseEntity((Object)("Invalid ruleset: " + ExceptionUtils.getRootCause((Throwable)e).getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            finally {
                if (!isExceptionThrown) {
                    this.inferencerClass = null;
                    List rulesetTempFile = Arrays.stream(tmpFolder.listFiles()).map(File::toString).filter(f -> f.endsWith(".pie")).collect(Collectors.toList());
                    if (!rulesetTempFile.isEmpty()) {
                        Files.deleteIfExists(Path.of((String)rulesetTempFile.get(0), new String[0]));
                    }
                }
                try {
                    infer.shutdown();
                }
                finally {
                    FileUtils.deleteDirectory((File)tmpRulesetFolder);
                }
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    private void saveFile(MultipartFile file, String repoID, SemanticLocation semanticLocation) throws IOException {
        if (file == null || file.isEmpty()) {
            return;
        }
        String originalFileName = file.getOriginalFilename();
        if (originalFileName == null || originalFileName.trim().isEmpty()) {
            throw new RepositoryConfigException("Missing original file name.");
        }
        String sanitizedFileName = FilenameUtils.getName((String)originalFileName);
        if (!sanitizedFileName.equals(originalFileName)) {
            throw new RepositoryConfigException("Invalid file name: do not include path elements.");
        }
        String fileNameWithoutExt = FilenameUtils.removeExtension((String)sanitizedFileName);
        if ((ONTOP_OBDA_FILE.equals(file.getName()) || ONTOP_OWL_FILE.equals(file.getName())) && "config".equalsIgnoreCase(fileNameWithoutExt)) {
            FileUtils.deleteDirectory((File)new File(semanticLocation.getRepositoryLocation(repoID)));
            throw new RepositoryConfigException("Invalid name 'config' for " + file.getName() + ". Use another file name.");
        }
        String ext = FilenameUtils.getExtension((String)sanitizedFileName);
        if (FORBIDDEN_EXTENSIONS.contains("." + ext.toLowerCase())) {
            throw new RepositoryConfigException("This file is not allowed.");
        }
        File repoRoot = new File(semanticLocation.getRepositoryLocation(repoID)).getCanonicalFile();
        File fileDest = new File(repoRoot, sanitizedFileName).getCanonicalFile();
        fileDest.getParentFile().mkdirs();
        file.transferTo(fileDest.toPath());
    }

    private void processUploadedRulesetFile(OwlimParameter rulesetParameter, String repoID, SemanticLocation semanticLocation) throws IOException {
        String value;
        if (rulesetParameter != null && !StringUtils.isBlank((CharSequence)(value = (String)rulesetParameter.getValue())) && Paths.get(value, new String[0]).isAbsolute()) {
            this.processUploadedFile(rulesetParameter, repoID, semanticLocation);
        }
    }

    private void processUploadedFile(OwlimParameter parameter, String repoID, SemanticLocation semanticLocation) throws IOException {
        String value;
        if (parameter != null && !StringUtils.isBlank((CharSequence)(value = (String)parameter.getValue()))) {
            Path fileTmp = Paths.get(value, new String[0]);
            Path fileDest = Paths.get(semanticLocation.getRepositoryLocation(repoID), this.getDestFileName(fileTmp));
            Files.createDirectories(fileDest.getParent(), new FileAttribute[0]);
            if (Files.exists(fileDest, new LinkOption[0])) {
                Files.copy(fileDest, fileDest.resolveSibling(String.valueOf(fileDest.getFileName()) + ".bak"), new CopyOption[0]);
            }
            Files.copy(fileTmp, fileDest, StandardCopyOption.REPLACE_EXISTING);
            parameter.setValue(fileDest.toString());
        }
    }

    private RepositoryConfig createAndValidateRepositoryConfig(RepositoryConfigBean bean, SemanticLocation semanticLocation) throws IOException {
        RepositoryConfig config = this.service.getRepositoryConfig(bean);
        if ("ontop".equals(bean.getType())) {
            for (String ontopParam : ONTOP_PARAMS) {
                this.processUploadedFile(bean.getParams().get(ontopParam), bean.getId(), semanticLocation);
            }
            config = this.service.getRepositoryConfig(bean);
        }
        return config;
    }

    @Hidden
    @PostMapping(value={"/ontop/test-connection"})
    public ResponseEntity<?> validateOntopConnectionProperties(@RequestBody OwlimParameter ontopProperties, @RequestParam(required=false) @Nullable String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyWithBodyToRemoteIfNeeded(ontopProperties, request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            if (!ontopProperties.getName().equals(ONTOP_PROPERTIES_FILE)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE).body((Object)"Please provide a valid Ontop Properties file.");
            }
            try {
                this.service.validateOntopConnectionProperties(ontopProperties);
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
            }
        });
    }

    @Operation(summary="Delete a repository in an attached RDF4J location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(value={"/{repositoryID}"})
    public ResponseEntity<?> deleteRepository(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws Exception {
        SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        return this.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            try {
                this.semanticDataManagement.removeRepositoryFromLocation(semanticLocation, repoId);
            }
            catch (RepositoryException | RepositoryConfigException e) {
                throw new GraphDBWorkbenchException("Couldn't remove repository.", e);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        });
    }

    @Hidden
    @Operation(summary="Get the default repository configuration for the repository type")
    @GetMapping(value={"/default-config/{repositoryType}"})
    public ResponseEntity<RepositoryConfigBean> getDefaultConfig(@Parameter(name="repository type: 'graphdb', 'fedx' or 'ontop'") @PathVariable(value="repositoryType") String repoType, @RequestParam(required=false) @Nullable String repositoryID, @RequestParam(required=false) @Nullable String repositoryTitle) {
        RepositoryConfigBean bean = new RepositoryConfigBean();
        bean.setType(repoType);
        bean.setId(repositoryID);
        bean.setTitle(repositoryTitle);
        switch (repoType) {
            case "graphdb": 
            case "ontop": 
            case "fedx": {
                bean.setParams(this.service.getParametersForType(repoType));
            }
        }
        return new ResponseEntity((Object)bean, (HttpStatusCode)HttpStatus.OK);
    }

    private RepositoryConfigBean getRepositoryConfigBean(String repoId, @Nullable String location) throws GraphDBWorkbenchException {
        return this.getRepositoryConfigBean(repoId, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location));
    }

    private RepositoryConfigBean getRepositoryConfigBean(final String repoId, SemanticLocation semanticLocation) throws GraphDBWorkbenchException {
        if (StringUtils.isBlank((CharSequence)repoId)) {
            throw new IllegalArgumentException("Repository id cannot be blank!");
        }
        SemanticLocation semanticLocation2 = semanticLocation;
        Objects.requireNonNull(semanticLocation2);
        RepositoryConfig repositoryConfig = (RepositoryConfig)new SemanticLocation.WithManagerInitalization<RepositoryConfig>(this, semanticLocation2){

            protected RepositoryConfig doWithManager(RepositoryManager manager) {
                return manager.getRepositoryConfig(repoId);
            }
        }.run();
        if (repositoryConfig != null) {
            RepositoryConfigBean repositoryConfigBean = new RepositoryConfigBean(repositoryConfig);
            Map<String, OwlimParameter> defaultsForType = this.service.getParametersForType(repositoryConfigBean.getType());
            repositoryConfigBean.setMissingDefaults(defaultsForType);
            repositoryConfigBean.setLocation(semanticLocation.getLocation());
            return repositoryConfigBean;
        }
        return null;
    }

    @Operation(summary="Get repository configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RepositoryConfigBean.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})})
    @GetMapping(value={"/{repositoryID}"}, produces={"application/json"})
    public ResponseEntity<?> getRepositoryConfigJSON(@Parameter(in=ParameterIn.PATH, name="repoId", description="repositoryID", schema=@Schema(type="string")) @PathVariable(value="repositoryID") String repoId, @Parameter(in=ParameterIn.QUERY, name="location", description="Valid GraphDB location, default current", schema=@Schema(type="string")) @RequestParam(required=false) @Nullable String location) throws Exception {
        RepositoryConfigBean repositoryConfigBean;
        SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        if (semanticLocation.isLocal()) {
            repositoryConfigBean = this.getRepositoryConfigBean(repoId, location);
        } else {
            try (CloseableHttpResponse response = this.proxyToRemoteSesame.executeGetRequest(semanticLocation, "/rest/repositories/" + repoId);){
                if (response.getStatusLine().getStatusCode() == 404) {
                    ResponseEntity responseEntity = new ResponseEntity((Object)("Unable to find repository " + repoId + " at " + semanticLocation.getLocation()), (HttpStatusCode)HttpStatus.NOT_FOUND);
                    return responseEntity;
                }
                repositoryConfigBean = (RepositoryConfigBean)this.objectMapper.readValue(response.getEntity().getContent(), RepositoryConfigBean.class);
                repositoryConfigBean.setLocation(semanticLocation.getLocation());
            }
        }
        if (repositoryConfigBean != null) {
            return new ResponseEntity((Object)repositoryConfigBean, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get repository configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/turtle", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})})
    @GetMapping(value={"/{repositoryID}"}, produces={"text/turtle"})
    public ResponseEntity<?> getRepositoryConfigTurtle(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws Exception {
        return this.downloadRepositoryConfigTurtle(request, response, repoId, location);
    }

    @Operation(summary="Get repository configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/zip", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})})
    @GetMapping(value={"/{repositoryID}"}, produces={"application/zip"})
    public void getRepositoryConfigZip(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws Exception {
        this.downloadRepositoryConfigZip(request, response, repoId, location);
    }

    @Hidden
    @Operation(summary="Download repository configuration as a Turtle file")
    @GetMapping(value={"/{repositoryID}/download-ttl"}, produces={"text/turtle"})
    public ResponseEntity<?> downloadRepositoryConfigTurtle(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws Exception {
        return this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            RepositoryConfigBean repositoryConfigBean = this.getRepositoryConfigBean(repoId, location);
            if (repositoryConfigBean != null) {
                response.addHeader("Content-Disposition", String.format("attachment; filename=\"%s-config.ttl\"", repoId));
                String turtleRepositoryConfiguration = this.service.getTurtleRepositoryConfiguration(repositoryConfigBean.toConfigParameters(), repositoryConfigBean.getType());
                return new ResponseEntity((Object)turtleRepositoryConfiguration, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        });
    }

    @Hidden
    @Operation(summary="Download repository configuration as a zip file")
    @GetMapping(value={"/{repositoryID}/download-zip"}, produces={"application/zip"})
    public void downloadRepositoryConfigZip(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws Exception {
        this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            RepositoryConfigBean repositoryConfigBean = this.getRepositoryConfigBean(repoId, location);
            if (repositoryConfigBean != null) {
                try {
                    response.setContentType(APPLICATION_ZIP_MIME_TYPE);
                    response.addHeader("Content-Disposition", String.format("attachment; filename=\"%s-config.zip\"", repoId));
                    try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());){
                        Map<String, String> repoParameters = repositoryConfigBean.toConfigParameters();
                        if (repositoryConfigBean.getSesameType().equals("graphdb:OntopRepository")) {
                            for (String ontopParam : ONTOP_PARAMS) {
                                this.addFileToZip(repositoryConfigBean, zipOutputStream, ontopParam, repoParameters);
                            }
                        }
                        String turtleRepositoryConfiguration = this.service.getTurtleRepositoryConfiguration(repoParameters, repositoryConfigBean.getType());
                        ZipEntry e = new ZipEntry("config.ttl");
                        zipOutputStream.putNextEntry(e);
                        zipOutputStream.write(turtleRepositoryConfiguration.getBytes());
                        zipOutputStream.closeEntry();
                        zipOutputStream.flush();
                        zipOutputStream.finish();
                    }
                    response.setStatus(200);
                }
                catch (IOException ex) {
                    this.logger.error("Cannot get repository config", (Throwable)ex);
                    response.setStatus(500);
                }
            } else {
                response.setStatus(404);
            }
            return null;
        });
    }

    private void addFileToZip(RepositoryConfigBean repositoryConfigBean, ZipOutputStream zipOutputStream, String param, Map<String, String> repoParameters) throws IOException {
        File file;
        OwlimParameter paramValue = repositoryConfigBean.getParams().get(param);
        if (paramValue != null && (file = new File(paramValue.getValueString())).exists()) {
            repoParameters.put(RepositoryTemplateParameters.getLabel((String)param), file.getName());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
    }

    @Operation(summary="Edit repository configuration", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PutMapping(value={"/{repositoryID}"})
    public ResponseEntity<?> editRepository(@PathVariable(value="repositoryID") String oldRepoId, final @RequestBody RepositoryConfigBean bean, HttpServletRequest request, HttpServletResponse response) throws Exception {
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(bean.getLocation());
        return this.proxyWithBodyToRemoteIfNeeded(bean, request, response, semanticLocation, () -> {
            if (StringUtils.isBlank((CharSequence)bean.getId())) {
                return new ResponseEntity((Object)"Repository id cannot be blank! ", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (!oldRepoId.equals(bean.getId()) && semanticLocation.containsRepository(bean.getId())) {
                return new ResponseEntity((Object)String.format("Repository %s already exists.", oldRepoId), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            final String changeRepoId = bean.getId();
            bean.setId(oldRepoId);
            if (bean.getParams() != null) {
                SemanticLocation semanticLocation2 = semanticLocation;
                Objects.requireNonNull(semanticLocation2);
                new SemanticLocation.WithManagerInitalization(semanticLocation2){

                    protected Void doWithManager(RepositoryManager manager) throws IOException {
                        RepositoryConfig config = RepositoryManagementController.this.createAndValidateRepositoryConfig(bean, semanticLocation);
                        semanticLocation.editRepositoryConfiguration(config, changeRepoId);
                        return null;
                    }
                }.run();
            }
            if (!changeRepoId.equals(bean.getId())) {
                try {
                    semanticLocation.removeRepository(oldRepoId);
                    this.semanticDataManagement.publishRepositoryChangedEvent(oldRepoId, changeRepoId);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
                }
                catch (Exception e) {
                    if (e instanceof RepositoryException) {
                        this.logger.error("Could not update repo id in the database: {}", (Object)e.getMessage());
                        return new ResponseEntity((Object)("Repository ID was not updated. " + e.getMessage()), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                    this.logger.error("Could not update repo id", (Throwable)e);
                    return new ResponseEntity((Object)("Repository ID was not updated. Reason: " + e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        });
    }

    @Operation(summary="Get repository size", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=RepositorySizeInfo.class))})})
    @GetMapping(value={"/{repositoryID}/size"})
    public ResponseEntity<RepositorySizeInfo> repositorySize(final @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws GraphDBWorkbenchException {
        if (StringUtils.isBlank((CharSequence)repoId)) {
            throw new IllegalArgumentException("Repository id cannot be blank!");
        }
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        final GraphDBRepositoriesService service = this.service;
        SemanticLocation semanticLocation2 = semanticLocation;
        Objects.requireNonNull(semanticLocation2);
        RepositorySizeInfo result = (RepositorySizeInfo)new SemanticLocation.WithManagerInitalization<RepositorySizeInfo>(this, semanticLocation2){

            protected RepositorySizeInfo doWithManager(RepositoryManager manager) {
                return service.getRepositorySizeInfo(semanticLocation, repoId);
            }
        }.run();
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Validate Repository with SHACL Shapes stored in a different repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/turtle", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"/{repositoryID}/validate/repository/{shapesRepositoryID}"}, produces={"text/turtle"})
    public ResponseEntity<String> validateWithShapesInRepository(final @PathVariable(value="repositoryID") String dataRepositoryID, final @PathVariable(value="shapesRepositoryID") String shapesRepositoryID, @RequestParam(required=false) @Nullable String location) throws GraphDBWorkbenchException {
        if (StringUtils.isBlank((CharSequence)dataRepositoryID)) {
            throw new IllegalArgumentException("Data Repository ID  cannot be blank!");
        }
        if (StringUtils.isBlank((CharSequence)shapesRepositoryID)) {
            throw new IllegalArgumentException("Shapes Repository ID cannot be blank!");
        }
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        final GraphDBRepositoriesService service = this.service;
        SemanticLocation semanticLocation2 = semanticLocation;
        Objects.requireNonNull(semanticLocation2);
        Model result = (Model)new SemanticLocation.WithManagerInitalization<Model>(this, semanticLocation2){

            protected Model doWithManager(RepositoryManager manager) {
                return service.validateRepository(semanticLocation, dataRepositoryID, shapesRepositoryID);
            }
        }.run();
        StringWriter stringWriter = new StringWriter();
        WriterConfig writerConfig = new WriterConfig().set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        Rio.write((Iterable)result, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return new ResponseEntity((Object)stringWriter.toString(), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Validate Repository with SHACL Shapes in request body", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/turtle", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"/{repositoryID}/validate/text"}, produces={"text/turtle"})
    public ResponseEntity<String> validateWithShapesInBody(final @PathVariable(value="repositoryID") String dataRepositoryID, @RequestParam(required=false) @Nullable String location, final @RequestBody String shapes, @RequestHeader(value="Content-Type") String contentType) throws GraphDBWorkbenchException {
        if (StringUtils.isBlank((CharSequence)dataRepositoryID)) {
            throw new IllegalArgumentException("Data Repository ID  cannot be blank!");
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            throw new IllegalArgumentException("Content-Type cannot be blank!");
        }
        final RDFFormat rdfFormat = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForMIMEType(contentType).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format: " + contentType));
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        final GraphDBRepositoriesService service = this.service;
        SemanticLocation semanticLocation2 = semanticLocation;
        Objects.requireNonNull(semanticLocation2);
        Model result = (Model)new SemanticLocation.WithManagerInitalization<Model>(this, semanticLocation2){

            protected Model doWithManager(RepositoryManager manager) {
                return service.validateRepository(semanticLocation, dataRepositoryID, shapes, rdfFormat);
            }
        }.run();
        StringWriter stringWriter = new StringWriter();
        WriterConfig writerConfig = new WriterConfig().set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        Rio.write((Iterable)result, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return new ResponseEntity((Object)stringWriter.toString(), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Validate Repository with SHACL Shapes stored in file", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/turtle", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"/{repositoryID}/validate/file"}, consumes={"multipart/form-data"}, produces={"text/turtle"})
    public ResponseEntity<String> validateWithShapesInFile(final @PathVariable(value="repositoryID") String dataRepositoryID, @RequestParam(required=false) @Nullable String location, @RequestParam(value="file") MultipartFile file) throws IOException {
        final String shapes = new String(file.getBytes());
        String contentType = file.getContentType();
        if (StringUtils.isBlank((CharSequence)dataRepositoryID)) {
            throw new IllegalArgumentException("Data Repository ID  cannot be blank!");
        }
        RDFParserRegistry rdfParserRegistry = RDFParserRegistry.getInstance();
        final RDFFormat rdfFormat = (RDFFormat)rdfParserRegistry.getFileFormatForMIMEType(contentType).or(() -> rdfParserRegistry.getFileFormatForFileName(file.getOriginalFilename())).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format for content-type " + contentType + " or extension of file " + file.getOriginalFilename()));
        final SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        final GraphDBRepositoriesService service = this.service;
        SemanticLocation semanticLocation2 = semanticLocation;
        Objects.requireNonNull(semanticLocation2);
        Model result = (Model)new SemanticLocation.WithManagerInitalization<Model>(this, semanticLocation2){

            protected Model doWithManager(RepositoryManager manager) {
                return service.validateRepository(semanticLocation, dataRepositoryID, shapes, rdfFormat);
            }
        }.run();
        StringWriter stringWriter = new StringWriter();
        WriterConfig writerConfig = new WriterConfig().set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        Rio.write((Iterable)result, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return new ResponseEntity((Object)stringWriter.toString(), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @PostMapping(value={"/{repositoryID}/prefix"})
    public ResponseEntity<?> updateNamespacePrefix(@RequestParam String from, @RequestParam String to, @PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) @Nullable String location) throws GraphDBWorkbenchException {
        SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        if (StringUtils.isBlank((CharSequence)repoId)) {
            return new ResponseEntity((Object)"Repository id cannot be blank!", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        SemanticRepository repository = semanticLocation.getRepository(repoId);
        if (repository == null) {
            return new ResponseEntity((Object)("No such repo " + repoId), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (null == repository.getNamespace(from)) {
            return new ResponseEntity((Object)("No such prefix " + from), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        repository.addNamespace(to, repository.getNamespace(from));
        repository.removeNamespace(from);
        return new ResponseEntity((Object)"Updated namespace prefix successfully", (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(value={"/ruleset/upload"})
    @ResponseBody
    public UploadFileResult uploadRuleSet(@RequestParam(value="ruleset") MultipartFile ruleSetFile, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            UploadFileResult ruleset = this.uploadFile(ruleSetFile, ".pie");
            if (!ruleset.getSuccess().booleanValue()) {
                response.setStatus(422);
                return ruleset;
            }
            try {
                this.inferencerClass = RuntimeInferencerCompiler.compileInferencer((String)ruleset.getFileLocation(), (boolean)false);
                return new UploadFileResult(true, "", ruleset.getFileLocation());
            }
            catch (RuleCompilerException e) {
                Object detailedMessage = e.getMessage();
                if (e.getCause() != null) {
                    detailedMessage = (String)detailedMessage + " Due to: " + e.getCause().getMessage();
                }
                response.setStatus(422);
                this.logger.error((String)detailedMessage, (Throwable)e);
                return new UploadFileResult(false, (String)detailedMessage, "");
            }
        });
    }

    @Hidden
    @RequestMapping(value={"/file/upload"})
    @ResponseBody
    public UploadFileResult uploadFile(@RequestParam(value="file") MultipartFile uploadFile, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> this.uploadFile(uploadFile, ""));
    }

    private UploadFileResult uploadFile(MultipartFile file, String extension) {
        try {
            File destFile = this.getFileDestination(file.getOriginalFilename(), extension);
            if (file instanceof GraphDBMultipartFile) {
                ((GraphDBMultipartFile)file).moveTo(destFile);
            } else {
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)destFile);
            }
            return new UploadFileResult(true, "", destFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new UploadFileResult(false, e.getMessage(), "");
        }
    }

    private File getFileDestination(String originalFilename, String defaultExtension) throws IOException {
        File tmpFolder;
        String sanitizedBaseName = FilenameUtils.getName((String)originalFilename);
        if (sanitizedBaseName == null || sanitizedBaseName.trim().isEmpty()) {
            throw new IOException("The file name cannot be empty");
        }
        String namePart = sanitizedBaseName;
        Object extensionPart = defaultExtension != null ? defaultExtension : "";
        int idxExtensionSep = sanitizedBaseName.lastIndexOf(46);
        if (idxExtensionSep > -1) {
            namePart = sanitizedBaseName.substring(0, idxExtensionSep);
            extensionPart = sanitizedBaseName.substring(idxExtensionSep);
            if (FORBIDDEN_EXTENSIONS.contains(((String)extensionPart).toLowerCase())) {
                throw new IOException("Unsupported file type!");
            }
        } else if (!((String)extensionPart).isEmpty() && !((String)extensionPart).startsWith(".")) {
            extensionPart = "." + (String)extensionPart;
        }
        if (!(tmpFolder = WebUtils.getTempDir((ServletContext)Objects.requireNonNull(RequestUtils.getServletContext()))).isDirectory()) {
            throw new IOException("Failed to retrieve a valid temporary directory.");
        }
        int tmpIndex = namePart.lastIndexOf(TMP_STRING);
        if (tmpIndex != -1) {
            String oldTempBase = namePart.substring(0, tmpIndex);
            File[] oldFiles = tmpFolder.listFiles((dir, name) -> name.startsWith(oldTempBase + TMP_STRING));
            if (oldFiles != null) {
                for (File f : oldFiles) {
                    try {
                        Files.deleteIfExists(f.toPath());
                    }
                    catch (IOException e) {
                        this.logger.warn("Failed to delete previous temporary file: {}", (Object)f.getName(), (Object)e);
                    }
                }
            }
            namePart = oldTempBase;
        }
        String uniqueSuffix = TMP_STRING + System.currentTimeMillis();
        String finalTempName = namePart + uniqueSuffix + (String)extensionPart;
        return new File(tmpFolder, finalTempName);
    }

    @Hidden
    @GetMapping(value={"/file"})
    @ResponseBody
    public ResponseEntity<String> getUploadedFileContent(@RequestParam(value="fileLocation") String fileLocation, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        return this.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> {
            ResponseEntity responseEntity;
            File file = new File(fileLocation);
            String repositoryId = this.validateAndExtractRepositoryId(fileLocation, semanticLocation);
            SecurityUtils.checkRepositoryAccess((String)SecurityUtils.getRepoIdLocationCompositeKey((String)repositoryId, (String)location), (boolean)true);
            FileInputStream inputStream = new FileInputStream(file);
            try {
                responseEntity = new ResponseEntity((Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (HttpStatusCode)HttpStatus.OK);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return new ResponseEntity((Object)"File not found", (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                    return new ResponseEntity((Object)"Could not read file", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            ((InputStream)inputStream).close();
            return responseEntity;
        });
    }

    @Hidden
    @RequestMapping(value={"/file/update"})
    @ResponseBody
    public UploadFileResult updateFile(@RequestBody String content, @RequestParam(value="fileLocation") String fileLocation, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyWithBodyToRemoteIfNeeded(content, request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            try {
                File destFile = this.getFileDestination(new File(fileLocation).getName(), "");
                FileUtils.writeStringToFile((File)destFile, (String)content, (Charset)StandardCharsets.UTF_8, (boolean)false);
                return new UploadFileResult(true, "", destFile.getAbsolutePath());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new UploadFileResult(false, e.getMessage(), "");
            }
        });
    }

    @ResponseBody
    @GetMapping(produces={"application/json"})
    @Operation(summary="Get all repositories in the active location or another location")
    public ResponseEntity<List<GraphDBRepository>> getRepositories(@RequestParam(required=false) @Nullable String location) throws GraphDBWorkbenchException {
        return new ResponseEntity(this.getLocationRepositories(this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location)), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @ResponseBody
    @GetMapping(value={"/all"})
    @Operation(summary="Get all repositories from local and the attached locations")
    public ResponseEntity<Map<String, List<GraphDBRepository>>> getRepositoriesFromAttachedLocations(@RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation currentLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        return this.proxyToRemoteIfNeeded(request, response, currentLocation, () -> new ResponseEntity(this.getRepositoriesFromLocations(), (HttpStatusCode)HttpStatus.OK));
    }

    @PostMapping(value={"/{repositoryID}/restart"})
    @ResponseBody
    @Operation(summary="Restart a repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="202", description="Accepted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> restartRepository(@PathVariable(value="repositoryID") String repositoryID, @RequestParam(name="sync", required=false) boolean sync, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation currentLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location);
        return this.proxyToRemoteIfNeeded(request, response, currentLocation, () -> {
            if (!currentLocation.getRepositoryIDs().contains(repositoryID)) {
                return new ResponseEntity((Object)String.format("Repository %s does not exist", repositoryID), (HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            Thread restartThread = currentLocation.restartRepository(repositoryID);
            if (sync) {
                restartThread.join();
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.ACCEPTED);
        });
    }

    @Hidden
    @GetMapping(value={"/ontop/drivers"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<JdbcDriver>> getSupportedDriversData(@RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> new ResponseEntity(this.service.readDriversData(), (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @PostMapping(value={"/ontop/jdbc-properties"}, consumes={"application/json"})
    @ResponseBody
    public UploadFileResult updatePropertiesFile(@Validated @RequestBody JDBCPropertiesFileBean bean, @RequestParam(value="fileLocation", required=false) String fileLocation, @RequestParam(name="location", required=false) String location, @RequestParam(name="driverType", required=false) String driverType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyWithBodyToRemoteIfNeeded(bean, request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            try {
                String fileName = StringUtils.isEmpty((CharSequence)fileLocation) ? "ontop_jdbc" : new File(fileLocation).getName();
                String extension = StringUtils.isEmpty((CharSequence)fileLocation) ? ".properties" : "";
                File destFile = this.getFileDestination(fileName, extension);
                return this.service.storeOntopProperties(destFile, bean, driverType.equals("generic"));
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new UploadFileResult(false, e.getMessage(), "");
            }
        });
    }

    @Hidden
    @GetMapping(value={"/ontop/jdbc-properties"})
    @ResponseBody
    public ResponseEntity<JDBCPropertiesFileBean> getPropertiesFile(@RequestParam(value="fileLocation") String fileLocation, @RequestParam(name="location", required=false) String location, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.proxyToRemoteIfNeeded(request, response, this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(location), () -> {
            try {
                return new ResponseEntity((Object)this.service.readOntopProperties(new File(fileLocation)), (HttpStatusCode)HttpStatus.OK);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        });
    }

    private Map<String, List<GraphDBRepository>> getRepositoriesFromLocations() {
        HashMap<String, List<GraphDBRepository>> result = new HashMap<String, List<GraphDBRepository>>();
        Collection semanticLocations = this.locationManagement.getRepositoryLocations();
        for (SemanticLocation semanticLocation : semanticLocations) {
            if (!semanticLocation.isLocal() && StringUtils.isNotEmpty((CharSequence)semanticLocation.getErrorMsg())) {
                semanticLocation.initializeAsNeeded();
                continue;
            }
            try {
                result.put(semanticLocation.getLocation(), this.getLocationRepositories(semanticLocation));
            }
            catch (Exception e) {
                if (!semanticLocation.isLocal()) {
                    this.logger.warn("Location {} is not reachable, ignoring it.", (Object)semanticLocation.getLabel());
                    continue;
                }
                throw e;
            }
        }
        return result;
    }

    private List<GraphDBRepository> getLocationRepositories(SemanticLocation semanticLocation) {
        if (semanticLocation.isLocal()) {
            return this.getLocalLocationRepositories(semanticLocation);
        }
        if (semanticLocation.getLocationType() == LocationType.GDB) {
            return this.getRemoteLocationRepositories(semanticLocation);
        }
        return List.of();
    }

    @VisibleForTesting
    List<GraphDBRepository> getLocalLocationRepositories(SemanticLocation semanticLocation) {
        if (!semanticLocation.isLocal()) {
            throw new IllegalArgumentException("Provided location must be local");
        }
        ArrayList<GraphDBRepository> result = new ArrayList<GraphDBRepository>();
        GraphDBRepositoryManager manager = (GraphDBRepositoryManager)semanticLocation.sesameManager();
        for (Map.Entry entry : manager.getRepositoryIDsWithState().entrySet()) {
            String type;
            String sesameType;
            String repositoryID = (String)entry.getKey();
            boolean unsupported = false;
            try {
                try {
                    sesameType = manager.getRepositoryConfig(repositoryID).getRepositoryImplConfig().getType();
                }
                catch (RepositoryConfigException e) {
                    String exceptionMessage = e.getMessage();
                    String unsupportedPrefix = "Unsupported repository type: ";
                    if (e.getMessage().startsWith("Unsupported repository type: ")) {
                        sesameType = exceptionMessage.substring("Unsupported repository type: ".length());
                        unsupported = true;
                    }
                    throw e;
                }
                type = SystemStatisticsCollector.getHumanRepositoryType((String)sesameType);
            }
            catch (RepositoryConfigException e) {
                this.logger.error("There is a problem with repository " + repositoryID + " in location " + semanticLocation.getLabel(), (Throwable)e);
                continue;
            }
            String title = !unsupported ? manager.getRepositoryInfo(repositoryID).getDescription() : "";
            String url = semanticLocation.getCanonicalExternalRepositoryUrl(repositoryID);
            String externalUrl = semanticLocation.getWorkbenchExternalRepositoryURL(repositoryID);
            RepositoryConfigBean repositoryConfig = this.getRepositoryConfigBean(repositoryID, semanticLocation);
            boolean writable = true;
            if (repositoryConfig != null && repositoryConfig.getParams().get("readOnly") != null) {
                AbstractParameter.Flag readOnlyFlag = new AbstractParameter.Flag("readOnly", false);
                writable = (Boolean)readOnlyFlag.convert(repositoryConfig.getParams().get("readOnly").getValueString()) == false;
            }
            result.add(new GraphDBRepository(semanticLocation.getLocation(), repositoryID, title, url, externalUrl, sesameType, type, (GraphDBRepositoryManager.RepositoryState)entry.getValue(), semanticLocation.isLocal(), writable, unsupported));
        }
        return result;
    }

    private List<GraphDBRepository> getRemoteLocationRepositories(SemanticLocation semanticLocation) {
        List list;
        block9: {
            if (semanticLocation.isLocal()) {
                throw new IllegalArgumentException("Provided location must be remote");
            }
            CloseableHttpResponse response = this.proxyToRemoteSesame.executeGetRequest(semanticLocation, REST_REPOSITORIES_URL);
            try {
                List repositories = (List)this.objectMapper.readValue(response.getEntity().getContent(), this.listOfRepoType);
                repositories.forEach(r -> {
                    r.setLocation(semanticLocation.getLocation());
                    r.setUri(semanticLocation.getCanonicalExternalRepositoryUrl(r.getId()));
                    r.setExternalUrl(semanticLocation.getWorkbenchExternalRepositoryURL(r.getId()));
                    r.setLocal(false);
                });
                list = repositories;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GraphDBWorkbenchException("Unable to fetch repositories from remote location", (Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }

    private String validateAndExtractRepositoryId(String fileLocation, SemanticLocation semanticLocation) throws IOException {
        boolean allowedPath;
        File file = new File(fileLocation).getCanonicalFile();
        File basePath = new File(semanticLocation.getEffectiveLocation()).getCanonicalFile();
        File repositoriesDir = new File(basePath, REPOSITORIES_DIR).getCanonicalFile();
        File tempBasePath = new File(semanticLocation.getEffectiveLocation().replace("/data", "/work/tmp/graphdb")).getCanonicalFile();
        boolean bl = allowedPath = file.getAbsolutePath().toLowerCase().startsWith(basePath.getAbsolutePath().toLowerCase()) || file.getAbsolutePath().toLowerCase().startsWith(tempBasePath.getAbsolutePath().toLowerCase());
        if (!allowedPath) {
            throw new FileNotFoundException("Not a repository file");
        }
        Path relativePath = repositoriesDir.toPath().relativize(file.toPath());
        return relativePath.getName(0).toString();
    }

    private void rollbackRepositoryCreation(String repoId, SemanticLocation semanticLocation) {
        Path repoDir = Paths.get(semanticLocation.getRepositoryLocation(repoId), new String[0]);
        boolean deleted = FileUtils.deleteQuietly((File)repoDir.toFile());
        if (deleted) {
            this.logger.info("Successfully rolled back repository creation for id: {}", (Object)repoId);
        }
    }

    private String getDestFileName(Path tmpPath) {
        String tmpFileName = tmpPath.getFileName().toString();
        int tmpIndex = tmpFileName.lastIndexOf(TMP_STRING);
        if (tmpIndex == -1) {
            return tmpFileName;
        }
        String fileName = tmpFileName.substring(0, tmpIndex);
        String fileExt = FilenameUtils.getExtension((String)tmpFileName);
        return String.join((CharSequence)".", fileName, fileExt);
    }

    private <T> T proxyToRemoteIfNeeded(HttpServletRequest request, HttpServletResponse response, SemanticLocation location, Callable<T> localProcessor) throws Exception {
        return this.proxyWithBodyToRemoteIfNeeded(null, request, response, location, localProcessor);
    }

    private <T> T proxyWithBodyToRemoteIfNeeded(Object altBody, HttpServletRequest request, HttpServletResponse response, SemanticLocation location, Callable<T> localProcessor) throws Exception {
        if (location.isLocal()) {
            return localProcessor.call();
        }
        request = new SkipParametersHttpServletRequest(request, Collections.singleton("location"));
        if (altBody != null) {
            if (altBody instanceof RepositoryConfigBean) {
                ((RepositoryConfigBean)altBody).setLocation(null);
            }
            request = new AltBodyHttpServletRequest(request, altBody);
        }
        this.proxyToRemoteSesame.proxyRequest(request, response, location);
        return null;
    }
}

