/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventFileSearchCallInProgress
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS;
    private final String itemId;
    private final int outputIndex;

    private ResponsesStreamEventFileSearchCallInProgress(String itemId, int outputIndex) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventFileSearchCallInProgress fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventFileSearchCallInProgress)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventFileSearchCallInProgress deserializedResponsesStreamEventFileSearchCallInProgress = new ResponsesStreamEventFileSearchCallInProgress(itemId, outputIndex);
            deserializedResponsesStreamEventFileSearchCallInProgress.type = type;
            return deserializedResponsesStreamEventFileSearchCallInProgress;
        });
    }
}

