/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventContentPartDone
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_CONTENT_PART_DONE;
    private final String itemId;
    private final int outputIndex;
    private final int contentIndex;
    private final ResponsesContent part;

    private ResponsesStreamEventContentPartDone(String itemId, int outputIndex, int contentIndex, ResponsesContent part) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.contentIndex = contentIndex;
        this.part = part;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public int getContentIndex() {
        return this.contentIndex;
    }

    public ResponsesContent getPart() {
        return this.part;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeIntField("content_index", this.contentIndex);
        jsonWriter.writeJsonField("part", (JsonSerializable)this.part);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventContentPartDone fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventContentPartDone)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            int contentIndex = 0;
            ResponsesContent part = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_CONTENT_PART_DONE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("content_index".equals(fieldName)) {
                    contentIndex = reader.getInt();
                    continue;
                }
                if ("part".equals(fieldName)) {
                    part = ResponsesContent.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventContentPartDone deserializedResponsesStreamEventContentPartDone = new ResponsesStreamEventContentPartDone(itemId, outputIndex, contentIndex, part);
            deserializedResponsesStreamEventContentPartDone.type = type;
            return deserializedResponsesStreamEventContentPartDone;
        });
    }
}

