/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.ai.openai.responses.models.ResponsesReasoningItemStatus;
import com.azure.ai.openai.responses.models.ResponsesReasoningItemSummaryElement;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesReasoningItem
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.REASONING;
    private ResponsesReasoningItemStatus status;
    private final List<ResponsesReasoningItemSummaryElement> summary;

    public ResponsesReasoningItem(List<ResponsesReasoningItemSummaryElement> summary) {
        this.summary = summary;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public ResponsesReasoningItemStatus getStatus() {
        return this.status;
    }

    public List<ResponsesReasoningItemSummaryElement> getSummary() {
        return this.summary;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("summary", this.summary, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesReasoningItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesReasoningItem)jsonReader.readObject(reader -> {
            String id = null;
            List summary = null;
            ResponsesItemType type = ResponsesItemType.REASONING;
            ResponsesReasoningItemStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    summary = reader.readArray(reader1 -> ResponsesReasoningItemSummaryElement.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesReasoningItemStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesReasoningItem deserializedResponsesReasoningItem = new ResponsesReasoningItem(summary);
            deserializedResponsesReasoningItem.setId(id);
            deserializedResponsesReasoningItem.type = type;
            deserializedResponsesReasoningItem.status = status;
            return deserializedResponsesReasoningItem;
        });
    }
}

