/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponseOutputTextAnnotationType;
import com.azure.ai.openai.responses.models.ResponsesOutputTextAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesOutputTextAnnotationUrlCitation
extends ResponsesOutputTextAnnotation {
    private ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.URL_CITATION;
    private final String url;
    private final String title;
    private final int startIndex;
    private final int endIndex;

    public ResponsesOutputTextAnnotationUrlCitation(String url, String title, int startIndex, int endIndex) {
        this.url = url;
        this.title = title;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public ResponseOutputTextAnnotationType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeIntField("start_index", this.startIndex);
        jsonWriter.writeIntField("end_index", this.endIndex);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesOutputTextAnnotationUrlCitation fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesOutputTextAnnotationUrlCitation)jsonReader.readObject(reader -> {
            String url = null;
            String title = null;
            int startIndex = 0;
            int endIndex = 0;
            ResponseOutputTextAnnotationType type = ResponseOutputTextAnnotationType.URL_CITATION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    title = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = reader.getInt();
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponseOutputTextAnnotationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesOutputTextAnnotationUrlCitation deserializedResponsesOutputTextAnnotationUrlCitation = new ResponsesOutputTextAnnotationUrlCitation(url, title, startIndex, endIndex);
            deserializedResponsesOutputTextAnnotationUrlCitation.type = type;
            return deserializedResponsesOutputTextAnnotationUrlCitation;
        });
    }
}

