/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesFunctionCallItemStatus;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesFunctionCallItem
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.FUNCTION_CALL;
    private ResponsesFunctionCallItemStatus status;
    private final String callId;
    private final String name;
    private final String arguments;

    public ResponsesFunctionCallItem(String callId, String name, String arguments) {
        this.callId = callId;
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public ResponsesFunctionCallItemStatus getStatus() {
        return this.status;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getName() {
        return this.name;
    }

    public String getArguments() {
        return this.arguments;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("call_id", this.callId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("arguments", this.arguments);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesFunctionCallItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesFunctionCallItem)jsonReader.readObject(reader -> {
            String id = null;
            String callId = null;
            String name = null;
            String arguments = null;
            ResponsesItemType type = ResponsesItemType.FUNCTION_CALL;
            ResponsesFunctionCallItemStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("call_id".equals(fieldName)) {
                    callId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesFunctionCallItemStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesFunctionCallItem deserializedResponsesFunctionCallItem = new ResponsesFunctionCallItem(callId, name, arguments);
            deserializedResponsesFunctionCallItem.setId(id);
            deserializedResponsesFunctionCallItem.type = type;
            deserializedResponsesFunctionCallItem.status = status;
            return deserializedResponsesFunctionCallItem;
        });
    }
}

