/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesFileSearchCallItemResult;
import com.azure.ai.openai.responses.models.ResponsesFileSearchCallItemStatus;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesFileSearchCallItem
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.FILE_SEARCH_CALL;
    private ResponsesFileSearchCallItemStatus status;
    private final List<String> queries;
    private final List<ResponsesFileSearchCallItemResult> results;

    public ResponsesFileSearchCallItem(List<String> queries, List<ResponsesFileSearchCallItemResult> results) {
        this.queries = queries;
        this.results = results;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public ResponsesFileSearchCallItemStatus getStatus() {
        return this.status;
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public List<ResponsesFileSearchCallItemResult> getResults() {
        return this.results;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("results", this.results, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesFileSearchCallItem fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesFileSearchCallItem)jsonReader.readObject(reader -> {
            String id = null;
            ResponsesFileSearchCallItemStatus status = null;
            List queries = null;
            List results = null;
            ResponsesItemType type = ResponsesItemType.FILE_SEARCH_CALL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesFileSearchCallItemStatus.fromString(reader.getString());
                    continue;
                }
                if ("queries".equals(fieldName)) {
                    queries = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    results = reader.readArray(reader1 -> ResponsesFileSearchCallItemResult.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesFileSearchCallItem deserializedResponsesFileSearchCallItem = new ResponsesFileSearchCallItem(queries, results);
            deserializedResponsesFileSearchCallItem.setId(id);
            deserializedResponsesFileSearchCallItem.status = status;
            deserializedResponsesFileSearchCallItem.type = type;
            return deserializedResponsesFileSearchCallItem;
        });
    }
}

